/*
 * Decompiled with CFR 0.152.
 */
package net.moss.resonance.block;

import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_10;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1540;
import net.minecraft.class_1676;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2275;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5556;
import net.minecraft.class_5688;
import net.minecraft.class_5691;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.moss.resonance.Resonance;
import net.moss.resonance.block.BrittleBlock;
import net.moss.resonance.block.IceFur;
import net.moss.resonance.mixin.AbstractCauldronBlockAccessor;
import net.moss.resonance.util.Utils;
import org.jetbrains.annotations.Nullable;

public class Icicle
extends class_2248
implements class_5688,
class_3737 {
    public static final class_2753 VERTICAL_DIRECTION = class_2741.field_28062;
    public static final class_2754<class_5691> THICKNESS = class_2741.field_28063;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2758 AGE = class_2741.field_12482;
    private static final class_265 TIP_MERGE_SHAPE = class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final class_265 UP_TIP_SHAPE = class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private static final class_265 DOWN_TIP_SHAPE = class_2248.method_9541((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final class_265 BASE_SHAPE = class_2248.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final class_265 FRUSTUM_SHAPE = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final class_265 MIDDLE_SHAPE = class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final class_265 DRIP_COLLISION_SHAPE = class_2248.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public Icicle(class_4970.class_2251 settings) {
        super(settings.method_49229(class_4970.class_2250.field_10657));
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)VERTICAL_DIRECTION, (Comparable)class_2350.field_11036)).method_11657(THICKNESS, (Comparable)class_5691.field_28065)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{VERTICAL_DIRECTION, THICKNESS, WATERLOGGED, AGE});
    }

    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        if (direction.method_10166() != class_2350.class_2351.field_11052) {
            return state;
        }
        class_2350 direction2 = (class_2350)state.method_11654((class_2769)VERTICAL_DIRECTION);
        if (direction2 == class_2350.field_11033 && world.method_8397().method_8674(pos, (Object)this)) {
            return state;
        }
        if (direction == direction2.method_10153() && !this.method_9558(state, (class_4538)world, pos)) {
            if (direction2 == class_2350.field_11033) {
                world.method_39279(pos, (class_2248)this, 2);
            } else {
                world.method_39279(pos, (class_2248)this, 1);
            }
            return state;
        }
        boolean bl = state.method_11654(THICKNESS) == class_5691.field_28064;
        class_5691 thickness = Icicle.getThickness((class_4538)world, pos, direction2, bl);
        return (class_2680)state.method_11657(THICKNESS, (Comparable)thickness);
    }

    protected void method_19286(class_1937 world, class_2680 state, class_3965 hit, class_1676 projectile) {
        if (world.field_9236) {
            return;
        }
        class_2338 blockPos = hit.method_17777();
        if (projectile.method_36971(world, blockPos) && projectile.method_54457(world) && projectile.method_18798().method_1033() > 0.6) {
            world.method_22352(blockPos, true);
        }
    }

    public void method_9554(class_1937 world, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        if (state.method_11654((class_2769)VERTICAL_DIRECTION) == class_2350.field_11036 && state.method_11654(THICKNESS) == class_5691.field_28065) {
            entity.method_5747(fallDistance + 2.0f, 2.0f, Utils.damageSource(world, Resonance.ICICLE_DAMAGE));
        } else {
            super.method_9554(world, state, pos, entity, fallDistance);
        }
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (Icicle.isFacingDirection(state, class_2350.field_11033) && state.method_11654(THICKNESS) == class_5691.field_28065 && !this.isColdAndWet(state, world, pos) && random.method_43057() < 0.2f) {
            class_243 vec3d = state.method_26226((class_1922)world, pos);
            double a = (double)pos.method_10263() + 0.5 + vec3d.field_1352;
            double b = (float)(pos.method_10264() + 1) - 0.065f;
            double c = (double)pos.method_10260() + 0.5 + vec3d.field_1350;
            world.method_8406((class_2394)class_2398.field_28078, a, b, c, 0.0, 0.0, 0.0);
        }
    }

    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (Icicle.isFacingDirection(state, class_2350.field_11036) && !this.method_9558(state, (class_4538)world, pos)) {
            world.method_22352(pos, true);
        } else {
            Icicle.spawnFallingBlock(state, world, pos);
        }
    }

    protected void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (world.method_8314(class_1944.field_9282, pos) > 11 - state.method_26193((class_1922)world, pos) || world.method_8597().comp_644()) {
            world.method_8650(pos, false);
        }
        Icicle.dripTick(state, world, pos, random.method_43057());
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue() && Icicle.isFacingDirection(state, class_2350.field_11033)) {
            if (Icicle.isTip(state, true) && state.method_11654(THICKNESS) == class_5691.field_28064) {
                this.freezeFloor(state, world, pos, random);
            } else if (random.method_43057() < 0.01f && (Integer)state.method_11654((class_2769)AGE) < 5) {
                class_2338 posDown = pos.method_10074();
                class_2338 posUp = pos.method_10084();
                class_2680 stateDown = world.method_8320(posDown);
                boolean isCold = this.isColdAndWet(state, (class_1937)world, pos);
                int age = Math.min((Integer)state.method_11654((class_2769)AGE) + random.method_39332(1, isCold ? 2 : 3), 5);
                if (Icicle.isTip(stateDown, false) && stateDown.method_11654((class_2769)VERTICAL_DIRECTION) == class_2350.field_11036) {
                    Icicle.place((class_1936)world, pos, class_2350.field_11033, class_5691.field_28064, age);
                    Icicle.place((class_1936)world, posDown, class_2350.field_11036, class_5691.field_28064, age);
                    this.freezeFloor(state, world, pos, random);
                } else if (stateDown.method_26234((class_1922)world, posDown)) {
                    Icicle.place((class_1936)world, pos, class_2350.field_11033, class_5691.field_28064, age);
                    this.freezeFloor(state, world, pos, random);
                } else if (stateDown.method_26215() || stateDown.method_27852(class_2246.field_10382)) {
                    Icicle.place((class_1936)world, posDown, class_2350.field_11033, class_5691.field_28065, age);
                } else if (state.method_11654(THICKNESS) == class_5691.field_28068 && stateDown.method_27852(Resonance.ICICLE) && stateDown.method_11654(THICKNESS) == class_5691.field_28067) {
                    world.method_8652(pos, class_2246.field_10295.method_9564(), 3);
                    Icicle.place((class_1936)world, posDown, class_2350.field_11033, class_5691.field_28068, age);
                } else if (state.method_11654(THICKNESS) == class_5691.field_28068 && (Integer)state.method_11654((class_2769)AGE) == 2 && world.method_8320(posUp).method_27852(class_2246.field_10295)) {
                    world.method_8652(posUp, class_2246.field_10225.method_9564(), 3);
                }
            }
        }
    }

    public void freezeFloor(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        Optional<class_2338> optional = Icicle.getFloorPos((class_1937)world, pos, state, 11);
        if (optional.isPresent()) {
            BrittleBlock.makeBrittle(state, world, pos, random);
            for (class_2350 direction : class_2350.values()) {
                class_2338 pos3;
                class_2338 pos2 = optional.get().method_10093(direction);
                if (world.method_8320(pos2).method_27852(class_2246.field_10382)) {
                    class_2680 state2 = Resonance.ICE_FUR.method_9564();
                    for (class_2350 direction2 : class_2350.values()) {
                        state2 = (class_2680)state2.method_11657((class_2769)IceFur.method_33374((class_2350)direction2), (Comparable)Boolean.valueOf(world.method_8320(pos2.method_10093(direction2)).method_26206((class_1922)world, pos2, direction2.method_10153())));
                    }
                    if (IceFur.hasAnyDirection(state2)) {
                        world.method_8652(pos2, state2, 3);
                    }
                }
                if (!world.method_8320(pos3 = optional.get().method_10093(direction).method_10084()).method_27852(class_2246.field_10382)) continue;
                class_2680 state2 = (class_2680)Resonance.ICE_FUR.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(true));
                for (class_2350 direction2 : class_2350.values()) {
                    state2 = (class_2680)state2.method_11657((class_2769)IceFur.method_33374((class_2350)direction2), (Comparable)Boolean.valueOf(world.method_8320(pos3.method_10093(direction2)).method_26206((class_1922)world, pos3, direction2.method_10153())));
                }
                if (!IceFur.hasAnyDirection(state2)) continue;
                world.method_8652(pos3, state2, 3);
            }
        }
    }

    protected boolean isColdAndWet(class_2680 state, class_1937 world, class_2338 pos) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false && ((class_1959)world.method_23753(pos).comp_349()).method_33599(pos);
    }

    @VisibleForTesting
    public static void dripTick(class_2680 state, class_3218 world, class_2338 pos, float dripChance) {
        if (!(dripChance > 0.2f)) {
            class_2338 blockPos2;
            class_2338 pos2;
            class_2680 state2;
            Optional<class_2338> optional = Icicle.getSupportingPos((class_1937)world, pos, state, 11);
            if (optional.isPresent() && (state2 = world.method_8320(pos2 = optional.get().method_10084())).method_27852(class_2246.field_37576)) {
                class_2680 blockState = class_2246.field_10253.method_9564();
                world.method_8501(pos2, blockState);
                class_2248.method_9582((class_2680)state2, (class_2680)blockState, (class_1936)world, (class_2338)pos2);
                world.method_43276((class_6880)class_5712.field_28733, pos2, class_5712.class_7397.method_43287((class_2680)blockState));
                world.method_20290(1504, pos, 0);
            }
            if ((blockPos2 = Icicle.getCauldronPos((class_1937)world, pos)) != null) {
                int level;
                class_2680 blockState2 = world.method_8320(blockPos2);
                if (blockState2.method_27852(class_2246.field_10593)) {
                    world.method_8652(blockPos2, (class_2680)class_2246.field_27097.method_9564().method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(1)), 2);
                }
                if (blockState2.method_27852(class_2246.field_27097) && (level = ((Integer)blockState2.method_11654((class_2769)class_5556.field_27206)).intValue()) < 3) {
                    world.method_8652(blockPos2, (class_2680)blockState2.method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(level + 1)), 2);
                }
            }
        }
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2350 direction;
        class_2338 blockPos;
        class_1937 worldAccess = ctx.method_8045();
        class_2350 direction2 = Icicle.getDirectionToPlaceAt((class_4538)worldAccess, blockPos = ctx.method_8037(), direction = ctx.method_32760().method_10153());
        if (direction2 == null) {
            return null;
        }
        boolean bl = !ctx.method_8046();
        class_5691 thickness = Icicle.getThickness((class_4538)worldAccess, blockPos, direction2, bl);
        return thickness == null ? null : (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)VERTICAL_DIRECTION, (Comparable)direction2)).method_11657(THICKNESS, (Comparable)thickness)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(worldAccess.method_8316(blockPos).method_15772() == class_3612.field_15910));
    }

    protected boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return Icicle.canPlaceAtWithDirection(world, pos, (class_2350)state.method_11654((class_2769)VERTICAL_DIRECTION));
    }

    public class_1282 method_32898(class_1297 attacker) {
        return Utils.damageSource(attacker.method_37908(), Resonance.ICICLE_DAMAGE);
    }

    protected boolean method_9516(class_2680 state, class_10 type) {
        return false;
    }

    protected boolean method_37403(class_2680 state, class_1922 world, class_2338 pos) {
        return false;
    }

    protected float method_32913() {
        return 0.125f;
    }

    protected void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            entity.method_32319(true);
        }
    }

    protected boolean method_9542(class_2680 state) {
        return (Integer)state.method_11654((class_2769)AGE) < 5;
    }

    protected class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    protected class_265 method_9571(class_2680 state, class_1922 world, class_2338 pos) {
        return class_259.method_1073();
    }

    public void method_10129(class_1937 world, class_2338 pos, class_1540 fallingBlockEntity) {
        if (!fallingBlockEntity.method_5701()) {
            world.method_20290(1045, pos, 0);
        }
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_5691 thickness = (class_5691)state.method_11654(THICKNESS);
        class_265 voxelShape = thickness == class_5691.field_28064 ? TIP_MERGE_SHAPE : (thickness == class_5691.field_28065 ? (state.method_11654((class_2769)VERTICAL_DIRECTION) == class_2350.field_11033 ? DOWN_TIP_SHAPE : UP_TIP_SHAPE) : (thickness == class_5691.field_28066 ? BASE_SHAPE : (thickness == class_5691.field_28067 ? FRUSTUM_SHAPE : MIDDLE_SHAPE)));
        class_243 vec3d = state.method_26226(world, pos);
        return voxelShape.method_1096(vec3d.field_1352, 0.0, vec3d.field_1350);
    }

    private static void spawnFallingBlock(class_2680 state, class_3218 world, class_2338 pos) {
        class_2338.class_2339 mutable = pos.method_25503();
        class_2680 blockState = state;
        while (Icicle.isFacingDirection(blockState, class_2350.field_11033)) {
            class_1540 fallingBlockEntity = class_1540.method_40005((class_1937)world, (class_2338)mutable, (class_2680)blockState);
            if (Icicle.isTip(blockState, true)) {
                fallingBlockEntity.method_6965(1.0f * (float)Math.max(1 + pos.method_10264() - mutable.method_10264(), 6), 40);
                break;
            }
            mutable.method_10098(class_2350.field_11033);
            blockState = world.method_8320((class_2338)mutable);
        }
    }

    private static void place(class_1936 world, class_2338 pos, class_2350 direction, class_5691 thickness, int age) {
        world.method_8652(pos, (class_2680)((class_2680)((class_2680)((class_2680)Resonance.ICICLE.method_9564().method_11657((class_2769)VERTICAL_DIRECTION, (Comparable)direction)).method_11657(THICKNESS, (Comparable)thickness)).method_11657((class_2769)AGE, (Comparable)Integer.valueOf(age))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(world.method_8316(pos).method_15772() == class_3612.field_15910)), 3);
    }

    @Nullable
    private static class_2350 getDirectionToPlaceAt(class_4538 world, class_2338 pos, class_2350 direction) {
        class_2350 direction2;
        if (Icicle.canPlaceAtWithDirection(world, pos, direction)) {
            direction2 = direction;
        } else {
            if (!Icicle.canPlaceAtWithDirection(world, pos, direction.method_10153())) {
                return null;
            }
            direction2 = direction.method_10153();
        }
        return direction2;
    }

    private static class_5691 getThickness(class_4538 world, class_2338 pos, class_2350 direction, boolean tryMerge) {
        class_2350 direction2 = direction.method_10153();
        class_2680 blockState = world.method_8320(pos.method_10093(direction));
        if (Icicle.isFacingDirection(blockState, direction2)) {
            return !tryMerge && blockState.method_11654(THICKNESS) != class_5691.field_28064 ? class_5691.field_28065 : class_5691.field_28064;
        }
        if (blockState.method_26206((class_1922)world, pos.method_10093(direction), direction2)) {
            return !tryMerge ? class_5691.field_28065 : class_5691.field_28064;
        }
        if (!Icicle.isFacingDirection(blockState, direction)) {
            return class_5691.field_28065;
        }
        class_5691 thickness = (class_5691)blockState.method_11654(THICKNESS);
        if (thickness != class_5691.field_28065 && thickness != class_5691.field_28064) {
            class_2680 blockState2 = world.method_8320(pos.method_10093(direction2));
            return !Icicle.isFacingDirection(blockState2, direction) ? class_5691.field_28068 : class_5691.field_28067;
        }
        return class_5691.field_28066;
    }

    private static Optional<class_2338> getSupportingPos(class_1937 world, class_2338 pos, class_2680 state, int range) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)VERTICAL_DIRECTION);
        BiPredicate<class_2338, class_2680> biPredicate = (posx, statex) -> statex.method_27852(Resonance.ICICLE) && statex.method_11654((class_2769)VERTICAL_DIRECTION) == direction;
        return Icicle.searchInDirection((class_1936)world, pos, direction.method_10153().method_10171(), biPredicate, statex -> !statex.method_27852(Resonance.ICICLE), range);
    }

    private static Optional<class_2338> getFloorPos(class_1937 world, class_2338 pos, class_2680 state, int range) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)VERTICAL_DIRECTION);
        BiPredicate<class_2338, class_2680> biPredicate = (posx, statex) -> statex.method_27852(Resonance.ICICLE);
        return Icicle.searchInDirection((class_1936)world, pos, direction.method_10171(), biPredicate, statex -> !statex.method_27852(Resonance.ICICLE), range);
    }

    private static boolean canPlaceAtWithDirection(class_4538 world, class_2338 pos, class_2350 direction) {
        class_2338 blockPos = pos.method_10093(direction.method_10153());
        class_2680 blockState = world.method_8320(blockPos);
        return blockState.method_26206((class_1922)world, blockPos, direction) || Icicle.isFacingDirection(blockState, direction);
    }

    private static boolean isTip(class_2680 state, boolean allowMerged) {
        if (!state.method_27852(Resonance.ICICLE)) {
            return false;
        }
        class_5691 thickness = (class_5691)state.method_11654(THICKNESS);
        return thickness == class_5691.field_28065 || allowMerged && thickness == class_5691.field_28064;
    }

    private static boolean isFacingDirection(class_2680 state, class_2350 direction) {
        return state.method_27852(Resonance.ICICLE) && state.method_11654((class_2769)VERTICAL_DIRECTION) == direction;
    }

    @Nullable
    private static class_2338 getCauldronPos(class_1937 world, class_2338 pos) {
        Predicate<class_2680> predicate = state -> {
            class_2275 block;
            class_2248 patt0$temp = state.method_26204();
            return patt0$temp instanceof class_2275 && ((AbstractCauldronBlockAccessor)(block = (class_2275)patt0$temp)).canBeFilledByDripstone((class_3611)class_3612.field_15910);
        };
        BiPredicate<class_2338, class_2680> biPredicate = (posx, state) -> Icicle.canDripThrough((class_1922)world, posx, state);
        return Icicle.searchInDirection((class_1936)world, pos, class_2350.field_11033.method_10171(), biPredicate, predicate, 11).orElse(null);
    }

    private static Optional<class_2338> searchInDirection(class_1936 world, class_2338 pos, class_2350.class_2352 direction, BiPredicate<class_2338, class_2680> continuePredicate, Predicate<class_2680> stopPredicate, int range) {
        class_2350 direction2 = class_2350.method_10156((class_2350.class_2352)direction, (class_2350.class_2351)class_2350.class_2351.field_11052);
        class_2338.class_2339 mutable = pos.method_25503();
        for (int i = 1; i < range; ++i) {
            mutable.method_10098(direction2);
            class_2680 blockState = world.method_8320((class_2338)mutable);
            if (stopPredicate.test(blockState)) {
                return Optional.of(mutable.method_10062());
            }
            if (!world.method_31601(mutable.method_10264()) && continuePredicate.test((class_2338)mutable, blockState)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static boolean canDripThrough(class_1922 world, class_2338 pos, class_2680 state) {
        if (state.method_26215()) {
            return true;
        }
        if (state.method_26216(world, pos)) {
            return false;
        }
        if (!state.method_26227().method_15769()) {
            return false;
        }
        return !class_259.method_1074((class_265)DRIP_COLLISION_SHAPE, (class_265)state.method_26220(world, pos), (class_247)class_247.field_16896);
    }
}

