/*
 * Decompiled with CFR 0.152.
 */
package net.moss.resonance.block.entity;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7128;
import net.minecraft.class_7225;
import net.minecraft.class_9298;
import net.minecraft.class_9334;
import net.moss.resonance.Resonance;
import net.moss.resonance.block.BuddingPearlIce;
import net.moss.resonance.util.PearlNatures;
import net.moss.resonance.util.PearlStatsComponent;
import org.jetbrains.annotations.Nullable;

public class BuddingPearlIceBlockEntity
extends class_2586 {
    private final class_7128 spreadManager;
    class_1799 seed = class_1799.field_8037;
    class_1799 potion = class_1799.field_8037;
    class_1799 catalyst = class_1799.field_8037;
    class_1799 pearl = class_1799.field_8037;
    private int brushesCount;
    private long nextDustTime;
    private long nextBrushTime;
    @Nullable
    private class_2350 hitDirection;

    public BuddingPearlIceBlockEntity(class_2338 pos, class_2680 state) {
        super(Resonance.BUDDING_PEARL_ICE_BLOCK_ENTITY, pos, state);
        this.spreadManager = class_7128.method_41478();
    }

    public void craftPearl(class_2680 state, class_5819 random) {
        class_1799 stack = new class_1799((class_1935)Resonance.PEARL);
        class_1844 potionComponent = (class_1844)this.potion.method_57825(class_9334.field_49651, (Object)class_1844.field_49274);
        if (this.potion.method_57826(class_9334.field_50238)) {
            potionComponent = potionComponent.method_57398(new class_1293(class_1294.field_16595, 120000, ((Integer)stack.method_57825(class_9334.field_50238, (Object)0)).intValue()));
        }
        if (this.potion.method_57826(class_9334.field_49652)) {
            class_9298 stewEffect = (class_9298)this.potion.method_57824(class_9334.field_49652);
            for (class_9298.class_8751 effect : stewEffect.comp_2416()) {
                potionComponent = potionComponent.method_57398(new class_1293(effect.comp_1838(), effect.comp_1839(), 0));
            }
        }
        if (this.potion.method_31574(Resonance.BIFURCATED_PEARL) || this.seed.method_31574(Resonance.BIFURCATED_PEARL)) {
            stack = new class_1799((class_1935)Resonance.BIFURCATED_PEARL);
        } else if (this.potion.method_31574(Resonance.PEARL) && this.seed.method_31574(Resonance.PEARL)) {
            for (class_1293 effectInstance : ((class_1844)this.seed.method_57824(class_9334.field_49651)).method_57397()) {
                potionComponent = potionComponent.method_57398(effectInstance);
            }
            stack = new class_1799((class_1935)Resonance.BIFURCATED_PEARL);
        }
        PearlStatsComponent seedPearl = (PearlStatsComponent)this.seed.method_57825(Resonance.PEARL_STATS, (Object)PearlStatsComponent.DEFAULT);
        int duration = seedPearl.getDuration();
        int recupera = seedPearl.getRecuperation();
        int strength = seedPearl.getStrength();
        if (this.potion.method_57826(Resonance.PEARL_STATS)) {
            List<Integer> potionStats = ((PearlStatsComponent)this.potion.method_57824(Resonance.PEARL_STATS)).stats();
            duration = (duration + potionStats.get(0)) / 2;
            recupera = (recupera + potionStats.get(1)) / 2;
            strength = (strength + potionStats.get(2)) / 2;
        }
        System.out.println("potionComponent: " + String.valueOf(potionComponent));
        Iterator effects = potionComponent.method_57397().iterator();
        potionComponent = class_1844.field_49274;
        while (effects.hasNext()) {
            class_1293 effect = (class_1293)effects.next();
            if (effect.method_5579().method_40220(Resonance.PEARL_EFFECT_BLACKLIST_TAG)) {
                potionComponent = potionComponent.method_57398(new class_1293(class_1294.field_5908, effect.method_5584(), effect.method_5578(), effect.method_5591(), effect.method_5581(), effect.method_5592()));
                continue;
            }
            potionComponent = potionComponent.method_57398(effect);
        }
        PearlNatures nature = this.hasCatalyst() && this.getCatalyst().method_57826(Resonance.PEARL_NATURE) ? (PearlNatures)((Object)this.getCatalyst().method_57824(Resonance.PEARL_NATURE)) : ((PearlStatsComponent)this.seed.method_57825(Resonance.PEARL_STATS, (Object)PearlStatsComponent.DEFAULT)).nature();
        stack.method_57379(Resonance.PEARL_STATS, (Object)PearlStatsComponent.randomStats(random, duration, recupera, strength, seedPearl.shiny() ? 0 : 128, nature));
        stack.method_57379(class_9334.field_49651, (Object)potionComponent);
        this.clear();
        this.setPearl(stack);
        class_2680 blockState = (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)BuddingPearlIce.HAS_PEARL, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)BuddingPearlIce.HAS_POTION, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)BuddingPearlIce.HAS_SEED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)BuddingPearlIce.AGE, (Comparable)Integer.valueOf((Integer)state.method_11654((class_2769)BuddingPearlIce.AGE) + 1));
        this.field_11863.method_8501(this.field_11867, blockState);
        this.field_11863.method_43276((class_6880)class_5712.field_28733, this.field_11867, class_5712.class_7397.method_43286(null, (class_2680)blockState));
        this.field_11863.method_8452(this.field_11867, blockState.method_26204());
    }

    public void spreadSculk(class_2680 state, class_3218 world, class_5819 random) {
        class_2338 pos2 = this.field_11867.method_10069(random.method_39332(0, 6) - 3, random.method_39332(0, 6) - 3, random.method_39332(0, 6) - 3);
        int count = 3;
        if (this.seed.method_57826(Resonance.PEARL_STATS)) {
            count += 3;
        }
        if (this.potion.method_57826(Resonance.PEARL_STATS)) {
            count += 3;
        }
        this.spreadManager.method_41482(pos2, 21 + count);
        for (int i = 0; i < count; ++i) {
            this.spreadManager.method_41479((class_1936)world, pos2, random, true);
        }
    }

    public boolean brush(long worldTime, class_2350 hitDirection) {
        if (this.hitDirection == null) {
            this.hitDirection = hitDirection;
        }
        this.nextDustTime = worldTime + 40L;
        if (worldTime < this.nextBrushTime || this.field_11863.method_8608()) {
            return false;
        }
        this.nextBrushTime = worldTime + 10L;
        int i = this.getDustedLevel();
        if (++this.brushesCount >= 10) {
            this.finishBrushing();
            return true;
        }
        this.field_11863.method_39279(this.method_11016(), this.method_11010().method_26204(), 2);
        int j = this.getDustedLevel();
        if (i != j) {
            this.field_11863.method_8501(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)class_2741.field_42836, (Comparable)Integer.valueOf(j)));
        }
        return false;
    }

    public void scheduledTick() {
        if (this.field_11863 == null) {
            return;
        }
        if (this.brushesCount != 0 && this.field_11863.method_8510() >= this.nextDustTime) {
            int i = this.getDustedLevel();
            this.brushesCount = Math.max(0, this.brushesCount - 2);
            int j = this.getDustedLevel();
            if (i != j) {
                this.field_11863.method_8501(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)class_2741.field_42836, (Comparable)Integer.valueOf(j)));
            }
            this.nextDustTime = this.field_11863.method_8510() + 4L;
        }
        if (this.brushesCount == 0) {
            this.hitDirection = null;
            this.nextDustTime = 0L;
            this.nextBrushTime = 0L;
        } else {
            this.field_11863.method_39279(this.method_11016(), this.method_11010().method_26204(), 2);
        }
    }

    private void finishBrushing() {
        if (this.field_11863 == null || this.field_11863.method_8503() == null) {
            return;
        }
        if (this.hasPearl()) {
            double d = class_1299.field_6052.method_17685();
            double f = 0.5 * (1.0 - d) + d / 2.0;
            class_2338 blockPos = this.field_11867.method_10093(Objects.requireNonNullElse(this.hitDirection, class_2350.field_11036));
            double g = (double)blockPos.method_10263() + f;
            double h = (double)blockPos.method_10264() + 0.5 + (double)(class_1299.field_6052.method_17686() / 2.0f);
            double i = (double)blockPos.method_10260() + f;
            class_1542 itemEntity = new class_1542(this.field_11863, g, h, i, this.getPearl().method_51164());
            itemEntity.method_18799(class_243.field_1353);
            this.field_11863.method_8649((class_1297)itemEntity);
        }
        this.field_11863.method_8396(null, this.field_11867, (class_3414)Resonance.REVERBERATION_SOUND.comp_349(), class_3419.field_15248, 1.0f, 1.0f);
        this.field_11863.method_20290(3008, this.method_11016(), class_2248.method_9507((class_2680)this.method_11010()));
        this.field_11863.method_8501(this.field_11867, Resonance.PEARL_ICE.method_9564());
    }

    public boolean canCraftPearl() {
        return this.hasSeed() && this.hasPotion() && (this.potion.method_57826(class_9334.field_50238) || this.potion.method_57826(class_9334.field_49652) || this.potion.method_57826(class_9334.field_49651));
    }

    public boolean hasSeed() {
        return !this.seed.method_7960();
    }

    public boolean hasPotion() {
        return !this.potion.method_7960();
    }

    public boolean hasCatalyst() {
        return !this.catalyst.method_7960();
    }

    public boolean hasPearl() {
        return !this.pearl.method_7960();
    }

    public class_1799 getSeed() {
        return this.seed;
    }

    public class_1799 getPotion() {
        return this.potion;
    }

    public class_1799 getCatalyst() {
        return this.catalyst;
    }

    public class_1799 getPearl() {
        return this.pearl;
    }

    public void setSeed(class_1799 seed) {
        this.seed = seed;
    }

    public void setPotion(class_1799 potion) {
        this.potion = potion;
    }

    public void setCatalyst(class_1799 catalyst) {
        this.catalyst = catalyst;
    }

    public void setPearl(class_1799 pearl) {
        this.pearl = pearl;
    }

    public void clear() {
        this.setSeed(class_1799.field_8037);
        this.setPotion(class_1799.field_8037);
        this.setCatalyst(class_1799.field_8037);
        this.setPearl(class_1799.field_8037);
    }

    @Nullable
    public class_2350 getHitDirection() {
        return this.hitDirection;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.seed = nbt.method_10573("Seed", 10) ? class_1799.method_57360((class_7225.class_7874)registryLookup, (class_2520)nbt.method_10562("Seed")).orElse(class_1799.field_8037) : class_1799.field_8037;
        this.potion = nbt.method_10573("Potion", 10) ? class_1799.method_57360((class_7225.class_7874)registryLookup, (class_2520)nbt.method_10562("Potion")).orElse(class_1799.field_8037) : class_1799.field_8037;
        this.catalyst = nbt.method_10573("Catalyst", 10) ? class_1799.method_57360((class_7225.class_7874)registryLookup, (class_2520)nbt.method_10562("Catalyst")).orElse(class_1799.field_8037) : class_1799.field_8037;
        class_1799 class_17992 = this.pearl = nbt.method_10573("Pearl", 10) ? class_1799.method_57360((class_7225.class_7874)registryLookup, (class_2520)nbt.method_10562("Pearl")).orElse(class_1799.field_8037) : class_1799.field_8037;
        if (nbt.method_10545("hit_direction")) {
            this.hitDirection = class_2350.values()[nbt.method_10550("hit_direction")];
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        if (this.hasSeed()) {
            nbt.method_10566("Seed", this.getSeed().method_57358(registryLookup));
        }
        if (this.hasPotion()) {
            nbt.method_10566("Potion", this.getPotion().method_57358(registryLookup));
        }
        if (this.hasCatalyst()) {
            nbt.method_10566("Catalyst", this.getCatalyst().method_57358(registryLookup));
        }
        if (this.hasPearl()) {
            nbt.method_10566("Pearl", this.getPearl().method_57358(registryLookup));
        }
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbtCompound = this.method_38244(registryLookup);
        if (this.hitDirection != null) {
            nbtCompound.method_10569("hit_direction", this.hitDirection.ordinal());
        }
        return nbtCompound;
    }

    private int getDustedLevel() {
        if (this.brushesCount == 0) {
            return 0;
        }
        if (this.brushesCount < 3) {
            return 1;
        }
        if (this.brushesCount < 6) {
            return 2;
        }
        return 3;
    }
}

