/*
 * Decompiled with CFR 0.152.
 */
package net.moss.resonance.block.entity;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2580;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_9334;
import net.moss.resonance.AlternatePearl;
import net.moss.resonance.Resonance;
import net.moss.resonance.block.PearlHubBlock;
import net.moss.resonance.entity.BeaconedPearlEntity;
import net.moss.resonance.entity.ModEntities;
import net.moss.resonance.item.Pearl;
import net.moss.resonance.mixin.BeaconBlockEntityAccessor;
import net.moss.resonance.util.PearlStatsComponent;
import net.moss.resonance.util.abstracts.BlockEntityWithItemIntentory;

public class PearlHubBlockEntity
extends BlockEntityWithItemIntentory {
    protected int level;

    public PearlHubBlockEntity(class_2338 pos, class_2680 state) {
        super(Resonance.PEARL_HUB_BLOCK_ENTITY, pos, state);
    }

    public PearlHubBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, PearlHubBlockEntity entity) {
        boolean bl1 = world.method_8320(pos.method_10074()).method_27852(class_2246.field_10327);
        int i = bl1 ? BeaconBlockEntityAccessor.updateLevel(world, pos.method_10263(), pos.method_10264() - 1, pos.method_10260()) : 0;
        boolean bl2 = i > 0;
        boolean bl3 = (Boolean)state.method_11654((class_2769)PearlHubBlock.BEACON_POWERED);
        if (bl3 && world.method_8510() % 80L == 0L) {
            world.method_8396(null, pos, class_3417.field_15045, class_3419.field_15245, 0.3f, 1.0f);
        }
        if ((!bl1 || !bl2) && bl3 || bl1 && bl2 && !bl3) {
            class_2580.method_10938((class_1937)world, (class_2338)pos, (class_3414)class_3417.field_19344);
            class_2580.method_10938((class_1937)world, (class_2338)pos, (class_3414)((class_3414)Resonance.REVERBERATION_SOUND.comp_349()));
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)PearlHubBlock.BEACON_POWERED, (Comparable)Boolean.valueOf(!bl3)));
            if (!bl3 && entity.hasStack()) {
                BeaconedPearlEntity beaconedPearlEntity = new BeaconedPearlEntity(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 2.2, (double)pos.method_10260() + 0.5, entity.getStack());
                world.method_8649((class_1297)beaconedPearlEntity);
                for (class_3222 player : world.method_18467(class_3222.class, new class_238(pos).method_1014(12.0))) {
                    Resonance.PEARL_HUB_CRITERION.trigger(player, entity.getStack(), i);
                }
            } else {
                for (BeaconedPearlEntity beaconedPearlEntity : world.method_18023(ModEntities.BEACONED_PEARL, new class_238(pos.method_10086(2)), class_1297::method_5732)) {
                    beaconedPearlEntity.method_5650(class_1297.class_5529.field_26999);
                }
            }
            return;
        }
        entity.setLevel(i);
    }

    public int usePearl(class_1937 world, class_2338 pos, class_1657 player) {
        if (this.hasStack() && world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            world.method_33596(null, (class_6880)class_5712.field_28174, pos);
            Resonance.PEARL_HUB_CRITERION.trigger((class_3222)player, this.getStack(), 0);
            return this.affectEntities(serverWorld, pos, List.of(player));
        }
        return 3;
    }

    public int pulsePearl(class_1937 world, class_2338 pos) {
        if (this.hasStack() && world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            world.method_33596(null, (class_6880)class_5712.field_28174, pos);
            if (!((Boolean)this.method_11010().method_11654((class_2769)PearlHubBlock.WATERLOGGED)).booleanValue()) {
                world.method_8396(null, pos, class_3417.field_38060, class_3419.field_15245, 0.5f, 0.6f + world.field_9229.method_43057() * 0.4f);
            }
            return this.affectEntities(serverWorld, pos, world.method_18467(class_1309.class, new class_238(pos).method_1014(3.0)));
        }
        return 3;
    }

    public int affectEntities(class_3218 world, class_2338 pos, List<class_1309> entities) {
        List<Integer> pearlStats = ((PearlStatsComponent)this.getStack().method_57825(Resonance.PEARL_STATS, (Object)PearlStatsComponent.DEFAULT)).stats();
        int recuperation = pearlStats.get(1);
        if (this.getStack().method_57826(class_9334.field_49651)) {
            float duration = pearlStats.get(0).intValue();
            float strength = pearlStats.get(2).intValue();
            ((class_1844)this.getStack().method_57824(class_9334.field_49651)).method_57402(effect -> {
                class_1293 newEffect = new class_1293(effect.method_5579(), (int)(duration * (float)effect.method_5584() / 3.0f), (int)Math.max(0.0f, strength * (float)effect.method_5578() / 3.0f));
                for (class_1309 livingEntity : entities) {
                    livingEntity.method_6092(newEffect);
                }
            });
            world.method_45447(null, pos, (class_3414)Resonance.PEARL_HUB_USE_SOUND.comp_349(), class_3419.field_15245);
        } else {
            Optional<AlternatePearl> alternateOrb = world.method_8503().method_30611().method_30530(Resonance.ALTERNATE_PEARLS_REGISTRY_KEY).method_10220().filter(alternatePearl -> alternatePearl.matches(this.getStack())).findFirst();
            if (alternateOrb.isPresent()) {
                AlternatePearl orb = alternateOrb.get();
                orb.effects().forEach(effect -> {
                    class_1293 newEffect = new class_1293(effect.method_5579(), effect.method_5584(), effect.method_5578());
                    for (class_1309 livingEntity : entities) {
                        livingEntity.method_6092(newEffect);
                    }
                });
                world.method_45447(null, pos, orb.sound(), class_3419.field_15245);
                recuperation = orb.recuperation();
            }
        }
        if (this.getStack().method_31574(class_1802.field_8634)) {
            block0: for (class_1309 livingEntity : entities) {
                if (livingEntity.method_5765()) {
                    livingEntity.method_5848();
                }
                for (int i = 0; i < 16; ++i) {
                    double f;
                    double e;
                    double d = livingEntity.method_23317() + (world.method_8409().method_43058() - 0.5) * 16.0;
                    if (!livingEntity.method_6082(d, e = class_3532.method_15350((double)(livingEntity.method_23318() + (double)world.method_8409().method_43048(16) - 8.0), (double)world.method_31607(), (double)(world.method_31607() + world.method_32819() - 1)), f = livingEntity.method_23321() + (world.method_8409().method_43058() - 0.5) * 16.0, true)) continue;
                    world.method_32888((class_6880)class_5712.field_39446, livingEntity.method_19538(), class_5712.class_7397.method_43285((class_1297)livingEntity));
                    world.method_45447(null, livingEntity.method_24515(), class_3417.field_14890, class_3419.field_15245);
                    livingEntity.method_38785();
                    continue block0;
                }
            }
        }
        if (this.getStack().method_7909() instanceof Pearl) {
            class_1799 stack = this.getStack();
            int i = stack.method_7919() + 1;
            stack.method_57379(class_9334.field_49629, (Object)i);
            if (i == stack.method_7936()) {
                this.dropStack((class_1937)world, pos, 0.5, 0.6, 0.5);
                this.method_5448();
                world.method_8501(pos, (class_2680)this.method_11010().method_11657((class_2769)PearlHubBlock.HAS_PEARL, (Comparable)Boolean.valueOf(false)));
            } else {
                this.setStack(stack);
            }
        }
        return recuperation;
    }

    public class_1799 method_54078(int amount) {
        class_1799 stack = this.getStack();
        this.method_5448();
        this.method_10997().method_8501(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)PearlHubBlock.HAS_PEARL, (Comparable)Boolean.valueOf(false)));
        return stack;
    }

    public void method_5447(int slot, class_1799 stack) {
        this.setStack(stack);
        this.method_10997().method_8501(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)PearlHubBlock.HAS_PEARL, (Comparable)Boolean.valueOf(!stack.method_7960())));
    }

    @Override
    public boolean method_5437(int slot, class_1799 stack) {
        return super.method_5437(slot, stack) && (stack.method_31573(Resonance.PEARL_ITEMS_TAG) || stack.method_31574(Resonance.PEARL) || stack.method_31574(Resonance.BIFURCATED_PEARL));
    }
}

