/*
 * Decompiled with CFR 0.152.
 */
package net.moss.resonance.compat.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.moss.resonance.compat.emi.EmiCompat;
import net.moss.resonance.recipe.LightningStrikeRecipe;
import org.jetbrains.annotations.Nullable;

public class LightningStrikeEmiRecipe
implements EmiRecipe {
    private final class_2960 id;
    private final List<EmiIngredient> input;
    private final List<EmiStack> results;
    private final boolean resonates;
    private final boolean isMaterialConsumed;
    private final int explosionPower;
    private final EmiTexture explodeTexture = new EmiTexture(class_2960.method_60655((String)"resonance", (String)"textures/gui/emi_explodes.png"), 0, 0, 32, 27, 32, 27, 32, 27);
    private final EmiTexture resonateTexture = new EmiTexture(class_2960.method_60655((String)"resonance", (String)"textures/gui/emi_resonates.png"), 0, 0, 32, 27, 32, 27, 32, 27);

    public LightningStrikeEmiRecipe(LightningStrikeRecipe recipe, class_2960 id) {
        this.id = id;
        this.input = List.of(EmiIngredient.of((class_1856)((class_1856)recipe.method_8117().get(0))));
        this.results = recipe.getResults().stream().map(i -> EmiStack.of((class_1799)i)).toList();
        this.resonates = recipe.getResonates();
        this.isMaterialConsumed = recipe.getIsMaterialConsumed();
        this.explosionPower = recipe.getExplosionPower();
    }

    public EmiRecipeCategory getCategory() {
        return EmiCompat.LIGHTNING_STRIKE;
    }

    @Nullable
    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.results;
    }

    public int getDisplayWidth() {
        return 76;
    }

    public int getDisplayHeight() {
        return 32;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 20, 8);
        if (this.resonates) {
            widgets.addTexture(this.resonateTexture, 44, 0);
        }
        if (this.explosionPower > 0) {
            widgets.addTexture(this.explodeTexture, 44, 0);
        }
        widgets.addSlot(this.input.get(0), 0, 7);
        if (!this.isMaterialConsumed) {
            this.addOffsetWidget(widgets, this.input.get(0), 0, this.results.size() + 1);
        }
        if (this.results.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.results.size(); ++i) {
            if (!this.isMaterialConsumed) {
                this.addOffsetWidget(widgets, (EmiIngredient)this.results.get(i), i + 1, this.results.size() + 1);
                continue;
            }
            this.addOffsetWidget(widgets, (EmiIngredient)this.results.get(i), i, this.results.size());
        }
    }

    public void addOffsetWidget(WidgetHolder widgets, EmiIngredient ingredient, int index, int size) {
        int xOffset = 0;
        int yOffset = 0;
        if (size == 2) {
            xOffset = index == 0 ? -8 : 8;
        } else if (size == 3) {
            int n = yOffset = index > 1 ? 8 : -8;
            xOffset = index == 0 ? -8 : (index == 1 ? 8 : 0);
        } else if (size == 4) {
            xOffset = index == 0 ? -8 : 8;
            yOffset = index > 1 ? 8 : -8;
        }
        widgets.addSlot(ingredient, 51 + xOffset, 7 + yOffset).drawBack(false).recipeContext((EmiRecipe)this);
    }
}

