/*
 * Decompiled with CFR 0.152.
 */
package net.moss.resonance.compat.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.GeneratedSlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7917;
import net.minecraft.class_7923;
import net.minecraft.class_9298;
import net.minecraft.class_9334;
import net.moss.resonance.Resonance;
import net.moss.resonance.compat.emi.EmiCompat;
import net.moss.resonance.item.Pearl;
import org.jetbrains.annotations.Nullable;

public class PearlGestationEmiRecipe
implements EmiRecipe {
    private static final List<class_1842> POTIONS = class_7923.field_41179.method_10220().collect(Collectors.toList());
    private static final List<class_7917> STEW = class_7917.method_47379();
    private final class_2960 id;
    private final List<EmiIngredient> input;
    private final List<EmiStack> results;
    private final boolean override;

    public PearlGestationEmiRecipe(EmiIngredient input, class_1799 potion, class_1799 pearl, boolean override, class_2960 id) {
        this.id = id;
        this.override = override;
        this.input = List.of(EmiStack.of((class_1935)class_1802.field_8426), input, EmiStack.of((class_1799)potion));
        this.results = List.of(EmiStack.of((class_1799)pearl), EmiStack.of((class_1935)Resonance.PEARL_ICE));
    }

    public PearlGestationEmiRecipe(EmiIngredient input, class_1799 pearl, class_6880<class_1842> potion, class_2960 id) {
        this.id = id;
        this.override = false;
        this.input = List.of(EmiStack.of((class_1935)class_1802.field_8426), input, EmiStack.of((class_1799)PearlGestationEmiRecipe.setPotion(class_1802.field_8574.method_7854(), potion)));
        this.results = List.of(EmiStack.of((class_1799)PearlGestationEmiRecipe.setPotion(pearl, potion)), EmiStack.of((class_1935)Resonance.PEARL_ICE));
    }

    public PearlGestationEmiRecipe(EmiIngredient input, class_1799 pearl, int ominous, class_2960 id) {
        class_1799 potion = new class_1799((class_1935)class_1802.field_50140);
        potion.method_57379(class_9334.field_50238, (Object)ominous);
        class_1844 potionComponent = class_1844.field_49274.method_57398(new class_1293(class_1294.field_16595, 120000, ominous));
        pearl.method_57379(class_9334.field_49651, (Object)potionComponent);
        this.id = id;
        this.override = false;
        this.input = List.of(EmiStack.of((class_1935)class_1802.field_8426), input, EmiStack.of((class_1799)potion));
        this.results = List.of(EmiStack.of((class_1799)pearl), EmiStack.of((class_1935)Resonance.PEARL_ICE));
    }

    public PearlGestationEmiRecipe(class_2960 id) {
        this.id = id;
        this.override = true;
        this.input = List.of(EmiStack.of((class_1935)class_1802.field_8426), EmiStack.of((class_1935)Resonance.PEARL), EmiStack.of((class_1935)Resonance.PEARL));
        this.results = List.of(EmiStack.of((class_1935)Resonance.BIFURCATED_PEARL), EmiStack.of((class_1935)Resonance.PEARL_ICE));
    }

    public static class_1799 setPotion(class_1799 stack, class_6880<class_1842> potion) {
        stack.method_57367(class_9334.field_49651, (Object)class_1844.field_49274, potion, class_1844::method_57403);
        return stack;
    }

    public EmiRecipeCategory getCategory() {
        return EmiCompat.PEARL_GESTATION;
    }

    @Nullable
    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.results;
    }

    public int getDisplayWidth() {
        return 132;
    }

    public int getDisplayHeight() {
        return 22;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 16, 2);
        widgets.addSlot(this.input.get(0), 0, 2);
        if (this.override) {
            class_1799 stack1 = ((EmiStack)this.input.get(1).getEmiStacks().getFirst()).getItemStack();
            class_1799 stack2 = ((EmiStack)this.input.get(2).getEmiStacks().getFirst()).getItemStack();
            class_1799 result = this.results.get(0).getItemStack();
            if (stack1.method_7909() instanceof Pearl) {
                ((GeneratedSlotWidget)widgets.add((Widget)this.randomPotion(stack1, false, false, 36, 2))).recipeContext((EmiRecipe)this);
            } else {
                widgets.addSlot(this.input.get(1), 36, 2).recipeContext((EmiRecipe)this);
            }
            if (stack2.method_31574(Resonance.PEARL)) {
                ((GeneratedSlotWidget)widgets.add((Widget)this.randomPotion(stack2, true, false, 54, 2))).recipeContext((EmiRecipe)this);
            } else if (stack2.method_31574(Resonance.BIFURCATED_PEARL)) {
                ((GeneratedSlotWidget)widgets.add((Widget)this.randomBifurcated(stack2, 54, 2))).recipeContext((EmiRecipe)this);
            } else {
                widgets.addSlot(this.input.get(2), 54, 2).recipeContext((EmiRecipe)this);
            }
            if (result.method_31574(Resonance.PEARL)) {
                ((GeneratedSlotWidget)widgets.add((Widget)this.randomPotion(result, true, true, 90, 2))).recipeContext((EmiRecipe)this);
            } else if (result.method_31574(Resonance.BIFURCATED_PEARL)) {
                ((GeneratedSlotWidget)widgets.add((Widget)this.randomBifurcated(result, 90, 2))).recipeContext((EmiRecipe)this);
            } else {
                widgets.addSlot(this.input.get(2), 90, 2).recipeContext((EmiRecipe)this);
            }
        } else {
            widgets.addSlot(this.input.get(1), 36, 2);
            widgets.addSlot(this.input.get(2), 54, 2);
            class_1799 stack = ((EmiStack)this.input.get(2).getEmiStacks().getFirst()).getItemStack();
            if (stack.method_31574(class_1802.field_8766)) {
                ((GeneratedSlotWidget)widgets.add((Widget)this.randomStew(this.results.get(0).getItemStack(), 90, 2))).recipeContext((EmiRecipe)this);
            } else {
                widgets.addSlot((EmiIngredient)this.results.get(0), 90, 2).recipeContext((EmiRecipe)this);
            }
        }
        widgets.addSlot((EmiIngredient)this.results.get(1), 108, 2).recipeContext((EmiRecipe)this);
    }

    private GeneratedSlotWidget randomPotion(class_1799 stack, boolean second, boolean product, int x, int y) {
        return new GeneratedSlotWidget(random -> {
            class_6880 potion1 = class_7923.field_41179.method_47983((Object)POTIONS.get(random.nextInt(POTIONS.size())));
            class_6880 potion2 = class_7923.field_41179.method_47983((Object)POTIONS.get(random.nextInt(POTIONS.size())));
            stack.method_57379(class_9334.field_49651, (Object)new class_1844(second ? potion2 : potion1));
            return EmiStack.of((class_1799)stack);
        }, 0, x, y);
    }

    private GeneratedSlotWidget randomBifurcated(class_1799 stack, int x, int y) {
        return new GeneratedSlotWidget(random -> {
            class_1844 potionComponent = new class_1844(class_7923.field_41179.method_47983((Object)POTIONS.get(random.nextInt(POTIONS.size()))));
            for (class_1293 effectInstance : ((class_1842)class_7923.field_41179.method_47983((Object)POTIONS.get(random.nextInt(POTIONS.size()))).comp_349()).method_8049()) {
                potionComponent = potionComponent.method_57398(effectInstance);
            }
            stack.method_57379(class_9334.field_49651, (Object)potionComponent);
            return EmiStack.of((class_1799)stack);
        }, 0, x, y);
    }

    private GeneratedSlotWidget randomStew(class_1799 stack, int x, int y) {
        return new GeneratedSlotWidget(random -> {
            class_1844 potionComponent = class_1844.field_49274;
            for (class_9298.class_8751 effect : STEW.get(random.nextInt(STEW.size())).method_53233().comp_2416()) {
                potionComponent = potionComponent.method_57398(new class_1293(effect.comp_1838(), effect.comp_1839(), 0));
            }
            stack.method_57379(class_9334.field_49651, (Object)potionComponent);
            return EmiStack.of((class_1799)stack);
        }, 0, x, y);
    }
}

