/*
 * Decompiled with CFR 0.152.
 */
package net.moss.resonance.entity;

import java.util.EnumSet;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1322;
import net.minecraft.class_1352;
import net.minecraft.class_1367;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1393;
import net.minecraft.class_1480;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2715;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5761;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_8103;
import net.minecraft.class_8162;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.moss.resonance.Resonance;
import org.jetbrains.annotations.Nullable;

public class VolcanoSnailEntity
extends class_1480
implements class_5761 {
    private static final class_2940<Byte> SNAIL_FLAGS = class_2945.method_12791(VolcanoSnailEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<String> TYPE = class_2945.method_12791(VolcanoSnailEntity.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Boolean> HUNGRY = class_2945.method_12791(VolcanoSnailEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Byte> COLOR = class_2945.method_12791(VolcanoSnailEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Boolean> FROM_BUCKET = class_2945.method_12791(VolcanoSnailEntity.class, (class_2941)class_2943.field_13323);
    @Nullable
    private UUID lightningId;

    public VolcanoSnailEntity(class_1299<? extends class_1480> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 2;
    }

    public float method_6144(class_2338 pos, class_4538 world) {
        return world.method_8320(pos.method_10074()).method_26164(Resonance.VOLCANO_SNAIL_PREFERED_TAG) || world.method_8320(pos).method_26164(Resonance.VOLCANO_SNAIL_PREFERED_TAG) ? 15.0f : (world.method_23753(pos) == Resonance.BATHYAL_ZONE ? 10.0f : world.method_42309(pos));
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(1, (class_1352)new class_1393((class_1314)this));
        this.field_6201.method_6277(2, (class_1352)new class_1374((class_1314)this, (double)0.6f));
        this.field_6201.method_6277(3, (class_1352)new EatChemicalsGoal(this, 0.5, 16));
        this.field_6201.method_6277(3, (class_1352)new class_1379((class_1314)this, 0.5));
        this.field_6201.method_6277(4, (class_1352)new class_1376((class_1308)this));
    }

    public void setVariant(Type type) {
        this.field_6011.method_12778(TYPE, (Object)type.name);
    }

    public void setHungry(Boolean hungry) {
        this.field_6011.method_12778(HUNGRY, (Object)hungry);
    }

    public void setColor(class_1767 color) {
        this.field_6011.method_12778(COLOR, (Object)((byte)((Byte)this.field_6011.method_12789(COLOR) & 0xF0 | color.method_7789() & 0xF)));
    }

    public Type getVariant() {
        return Type.fromName((String)this.field_6011.method_12789(TYPE));
    }

    public Boolean getHungry() {
        return (Boolean)this.field_6011.method_12789(HUNGRY);
    }

    public class_1767 getColor() {
        return class_1767.method_7791((int)((Byte)this.field_6011.method_12789(COLOR) & 0xF));
    }

    public void method_6454(boolean fromBucket) {
        this.field_6011.method_12778(FROM_BUCKET, (Object)fromBucket);
    }

    public boolean method_6453() {
        return (Boolean)this.field_6011.method_12789(FROM_BUCKET);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10582("Type", this.getVariant().method_15434());
        nbt.method_10556("Hungry", ((Boolean)this.field_6011.method_12789(HUNGRY)).booleanValue());
        nbt.method_10556("FromBucket", this.method_6453());
        nbt.method_10567("Color", (byte)this.getColor().method_7789());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setVariant(Type.fromName(nbt.method_10558("Type")));
        this.setHungry(nbt.method_10577("Hungry"));
        this.method_6454(nbt.method_10577("FromBucket"));
        this.setColor(class_1767.method_7791((int)nbt.method_10571("Color")));
    }

    public boolean method_5679(class_1282 damageSource) {
        return super.method_5679(damageSource) || damageSource.method_48789(class_8103.field_42246);
    }

    public static class_1767 generateDefaultColor(class_5819 random) {
        int i = random.method_43048(10);
        if (i > 4) {
            return class_1767.field_7944;
        }
        if (i > 2) {
            return class_1767.field_7963;
        }
        return class_1767.field_7967;
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        class_5819 random = world.method_8409();
        this.setColor(VolcanoSnailEntity.generateDefaultColor(random));
        this.method_5996(class_5134.field_47760).method_26837(new class_1322(field_51997, (double)(random.method_43057() * 0.3f - 0.15f), class_1322.class_1323.field_6330));
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
    }

    public boolean method_37222(class_1293 effect, class_1297 source) {
        this.method_6025(effect.method_5578() + 1);
        return false;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        class_1792 item = itemStack.method_7909();
        if (item instanceof class_8162 && !player.method_7357().method_7904(item) && !this.getHungry().booleanValue()) {
            this.field_6011.method_12778(HUNGRY, (Object)true);
            this.method_5775(this.getVariant().getMetalState().method_7972());
            this.method_32876((class_6880)class_5712.field_28725);
            itemStack.method_7970(4, (class_1309)player, VolcanoSnailEntity.method_56079((class_1268)hand));
        } else if (item instanceof class_1769) {
            class_1769 dyeItem = (class_1769)item;
            this.setColor(dyeItem.method_7802());
            this.method_32876((class_6880)class_5712.field_28725);
            itemStack.method_57008(1, (class_1309)player);
            this.method_5783(class_3417.field_28391, 1.0f, 1.0f);
        } else {
            return class_5761.method_35169((class_1657)player, (class_1268)hand, (class_1309)this).orElse(super.method_5992(player, hand));
        }
        return class_1269.method_29236((boolean)this.method_37908().method_8608());
    }

    public void method_5800(class_3218 world, class_1538 lightning) {
        UUID uUID = lightning.method_5667();
        if (!uUID.equals(this.lightningId)) {
            this.setVariant(this.getVariant() == Type.IRON ? Type.COPPER : Type.IRON);
            this.lightningId = uUID;
        }
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().method_8608()) {
            this.setClimbingWall(this.field_5976);
        }
    }

    public boolean method_6101() {
        return this.isClimbingWall();
    }

    public boolean isClimbingWall() {
        return ((Byte)this.field_6011.method_12789(SNAIL_FLAGS) & 1) != 0;
    }

    public void setClimbingWall(boolean climbing) {
        byte b = (Byte)this.field_6011.method_12789(SNAIL_FLAGS);
        b = climbing ? (byte)(b | 1) : (byte)(b & 0xFFFFFFFE);
        this.field_6011.method_12778(SNAIL_FLAGS, (Object)b);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(TYPE, (Object)Type.IRON.name);
        builder.method_56912(HUNGRY, (Object)false);
        builder.method_56912(FROM_BUCKET, (Object)false);
        builder.method_56912(COLOR, (Object)0);
        builder.method_56912(SNAIL_FLAGS, (Object)0);
    }

    public static class_5132.class_5133 createVolcanoSnailAttributes() {
        return class_1314.method_26827().method_26868(class_5134.field_23716, 2.0).method_26868(class_5134.field_23719, (double)0.2f).method_26868(class_5134.field_51578, 2.0).method_26868(class_5134.field_23717, 32.0).method_26868(class_5134.field_23724, 10.0).method_26868(class_5134.field_47761, 1.0);
    }

    public void method_6455(class_1799 stack) {
        class_5761.method_35167((class_1308)this, (class_1799)stack);
        class_9279.method_57452((class_9331)class_9334.field_49610, (class_1799)stack, nbtCompound -> nbtCompound.method_10582("Type", this.getVariant().method_15434()));
        class_9279.method_57452((class_9331)class_9334.field_49610, (class_1799)stack, nbtCompound -> nbtCompound.method_10556("Hungry", ((Boolean)this.field_6011.method_12789(HUNGRY)).booleanValue()));
        class_9279.method_57452((class_9331)class_9334.field_49610, (class_1799)stack, nbtCompound -> nbtCompound.method_10567("Color", (byte)this.getColor().method_7789()));
        class_9279.method_57452((class_9331)class_9334.field_49610, (class_1799)stack, nbtCompound -> nbtCompound.method_10556("FromBucket", this.method_6453()));
    }

    public void method_35170(class_2487 nbt) {
        class_5761.method_35168((class_1308)this, (class_2487)nbt);
        this.setVariant(Type.fromName(nbt.method_10558("Type")));
        this.setHungry(nbt.method_10577("Hungry"));
        this.setColor(class_1767.method_7791((int)nbt.method_10571("Color")));
        this.method_6454(nbt.method_10577("FromBucket"));
    }

    public class_1799 method_6452() {
        return new class_1799((class_1935)Resonance.VOLCANO_SNAIL_BUCKET);
    }

    public class_3414 method_35171() {
        return class_3417.field_15126;
    }

    public class EatChemicalsGoal
    extends class_1367 {
        private static final Predicate<class_2680> VENT_FLUID_PREDICATE = class_2715.method_11758((class_2248)Resonance.VENT_FLUID);
        private final VolcanoSnailEntity entity;

        public EatChemicalsGoal(VolcanoSnailEntity entity, double speed, int range) {
            super((class_1314)entity, speed, range, 2);
            this.entity = entity;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18407, class_1352.class_4134.field_18405));
        }

        public double method_6291() {
            return 4.0;
        }

        protected boolean method_6296(class_4538 world, class_2338 pos) {
            return VENT_FLUID_PREDICATE.test(world.method_8320(pos));
        }

        public boolean method_6264() {
            return this.entity.getHungry() != false && this.field_6516.method_59922().method_43048(1000) == 0 && super.method_6264();
        }

        public void method_6268() {
            super.method_6268();
            if (this.method_6295()) {
                this.entity.setHungry(false);
                this.entity.method_6104(VolcanoSnailEntity.this.field_6266);
            }
        }
    }

    public static enum Type implements class_3542
    {
        IRON("iron", class_1802.field_33400.method_7854()),
        COPPER("copper", class_1802.field_33401.method_7854());

        public static final class_3542.class_7292<Type> CODEC;
        final String name;
        final class_1799 metal;

        private Type(String name, class_1799 metal) {
            this.name = name;
            this.metal = metal;
        }

        public class_1799 getMetalState() {
            return this.metal;
        }

        public String method_15434() {
            return this.name;
        }

        static Type fromName(String name) {
            return (Type)CODEC.method_47920(name, (Enum)IRON);
        }

        static {
            CODEC = class_3542.method_28140(Type::values);
        }
    }
}

