/*
 * Decompiled with CFR 0.152.
 */
package net.moss.resonance.mixin;

import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5321;
import net.minecraft.class_8110;
import net.minecraft.class_8111;
import net.moss.resonance.Resonance;
import net.moss.resonance.ResonanceEvents;
import net.moss.resonance.util.EnchantUtils;
import net.moss.resonance.util.GroundPoundType;
import net.moss.resonance.util.Utils;
import net.moss.resonance.util.interfaces.PlayerEntityInterface;
import net.moss.resonance.util.interfaces.ShieldInterface;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1657.class})
public class PlayerEntityMixin
implements PlayerEntityInterface {
    @Unique
    private int critCount = 0;
    @Unique
    private int critTimer = 0;
    @Unique
    private boolean isGroundPounding = false;
    @Unique
    private GroundPoundType groundPoundType = null;

    @Inject(at={@At(value="HEAD")}, method={"damageShield(F)V"}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void damageShield(float amount, CallbackInfo callBackInfo) {
        class_1657 player = (class_1657)this;
        class_1268 hand = player.method_6058();
        class_1799 activeItem = player.method_6030();
        ((ResonanceEvents.ShieldBlock)ResonanceEvents.SHIELD_BLOCK.invoker()).block((class_1309)player, amount, player.method_6058(), activeItem);
        if (activeItem.method_7909() instanceof ShieldInterface && amount >= 3.0f) {
            int i = 1 + class_3532.method_15375((float)amount);
            activeItem.method_7970(i, (class_1309)player, class_1657.method_56079((class_1268)player.method_6058()));
            if (activeItem.method_7960()) {
                if (hand == class_1268.field_5808) {
                    player.method_5673(class_1304.field_6173, class_1799.field_8037);
                } else {
                    player.method_5673(class_1304.field_6171, class_1799.field_8037);
                }
                activeItem = class_1799.field_8037;
                player.method_5783(class_3417.field_15239, 0.8f, 0.8f + player.method_59922().method_43057() * 0.4f);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"disableShield()V"}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void disableShieldHead(CallbackInfo callbackInfo) {
        class_1657 player = (class_1657)this;
        class_1799 activeItemStack = player.method_6030();
        ((ResonanceEvents.ShieldDisable)ResonanceEvents.SHIELD_DISABLE.invoker()).disable(player, player.method_6058(), activeItemStack);
        class_1792 class_17922 = activeItemStack.method_7909();
        if (class_17922 instanceof ShieldInterface) {
            ShieldInterface shield = (ShieldInterface)class_17922;
            float f = 0.25f;
            if (player.method_5624()) {
                f += 0.75f;
            }
            if (player.method_59922().method_43057() < f) {
                EnchantUtils.setCooldownTime(activeItemStack, player, shield.getCoolDownTicks());
                player.method_6021();
                player.method_37908().method_8421((class_1297)player, (byte)30);
                callbackInfo.cancel();
            }
        }
    }

    @Inject(method={"createPlayerAttributes"}, at={@At(value="RETURN")})
    private static void addAttributes(CallbackInfoReturnable<class_5132.class_5133> info) {
        ((class_5132.class_5133)info.getReturnValue()).method_26867(Resonance.DOUBLE_JUMPS).method_26867(Resonance.WALL_JUMPS);
    }

    @Inject(at={@At(value="HEAD")}, method={"attack"}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void attack(class_1297 target, CallbackInfo callbackInfo) {
        class_1657 player = (class_1657)this;
        class_1937 world = player.method_37908();
        if (world.field_9236) {
            return;
        }
        EnchantUtils.recoilCheck((class_1309)player, null, player.method_6047(), 0.5f, Float.valueOf(1.0f), false);
        if (Utils.isAttackCritical(player, target) && (this.critTimer > 0 || this.critCount == 0) && world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            ++this.critCount;
            this.critTimer = 60;
            EnchantUtils.onTargetCritDamaged(serverWorld, target, Utils.damageSource((class_1937)serverWorld, (class_5321<class_8110>)class_8111.field_42320, (class_1297)player), player.method_6047());
            ((ResonanceEvents.PlayerCritStreak)ResonanceEvents.CRIT_EVENT.invoker()).critStreak(player, target, this.critCount, player.method_6058(), player.method_6047());
        } else {
            ((ResonanceEvents.PlayerCritDeath)ResonanceEvents.CRIT_DEATH_EVENT.invoker()).critDeath(player, target, this.critCount, player.method_6058(), player.method_6047());
            this.critCount = 0;
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void tick(CallbackInfo callbackInfo) {
        class_1937 class_19372;
        class_1657 player = (class_1657)this;
        if (this.critTimer == 1) {
            this.critCount = 0;
        } else if (this.critTimer > 0) {
            --this.critTimer;
        }
        if (this.isGroundPounding && this.groundPoundType != null && (class_19372 = player.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            if (player.method_6128() || player.method_6101() || player.method_5765() || player.method_5799() || player.method_31549().field_7479) {
                ((PlayerEntityInterface)player).cancelGroundPound(player);
            } else {
                this.groundPoundType.tick(serverWorld, player);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"collideWithEntity"}, cancellable=true)
    private void collideWithEntity(class_1297 entity, CallbackInfo callbackInfo) {
        class_1657 player = (class_1657)this;
        class_1937 class_19372 = player.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            if (this.isGroundPounding && this.groundPoundType != null) {
                ((PlayerEntityInterface)player).endGroundPound(serverWorld, player, entity);
            }
        }
    }

    @Override
    public int getCritCount() {
        return this.critCount;
    }

    @Override
    public int getCritTimer() {
        return this.critTimer;
    }

    @Override
    public void setCritCount(int value) {
        this.critCount = value;
    }

    @Override
    public void setCritTimer(int value) {
        this.critTimer = value;
    }

    @Override
    public boolean isGroundPounding() {
        return this.isGroundPounding;
    }

    @Override
    public GroundPoundType getGroundPoundType() {
        return this.groundPoundType;
    }

    @Override
    public void startGroundPound(class_3218 world, class_1657 user, GroundPoundType type) {
        this.isGroundPounding = true;
        this.groundPoundType = type;
    }

    @Override
    public void endGroundPound(class_3218 world, class_1657 user, @Nullable class_1297 target) {
        if (this.groundPoundType != null) {
            this.groundPoundType.end(world, user, target);
        }
        this.groundPoundType = null;
        this.isGroundPounding = false;
    }

    @Override
    public void cancelGroundPound(class_1657 user) {
        if (this.groundPoundType != null) {
            this.groundPoundType.cancel(user);
        }
        this.groundPoundType = null;
        this.isGroundPounding = false;
    }
}

