/*
 * Decompiled with CFR 0.152.
 */
package net.moss.resonance.util;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_3542;
import net.minecraft.class_5547;
import net.moss.resonance.Resonance;

public interface Dischargable
extends class_5547<ChargeLevel> {
    public static final Supplier<BiMap<class_2248, class_2248>> CHARGE_DECREASES = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)Resonance.CHARGED_AMETHYST_CLUSTER, (Object)Resonance.LARGE_CHARGED_AMETHYST_BUD).put((Object)Resonance.LARGE_CHARGED_AMETHYST_BUD, (Object)Resonance.MEDIUM_CHARGED_AMETHYST_BUD).put((Object)Resonance.MEDIUM_CHARGED_AMETHYST_BUD, (Object)Resonance.SMALL_CHARGED_AMETHYST_BUD).put((Object)Resonance.SMALL_CHARGED_AMETHYST_BUD, (Object)class_2246.field_27164).build());
    public static final Supplier<BiMap<class_2248, class_2248>> CHARGE_INCREASES = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)class_2246.field_27161, (Object)Resonance.CHARGED_AMETHYST_CLUSTER).put((Object)class_2246.field_27162, (Object)Resonance.LARGE_CHARGED_AMETHYST_BUD).put((Object)class_2246.field_27163, (Object)Resonance.MEDIUM_CHARGED_AMETHYST_BUD).put((Object)class_2246.field_27164, (Object)Resonance.SMALL_CHARGED_AMETHYST_BUD).build());

    public static class_2248 getMaxChargedBlock(class_2248 block) {
        class_2248 block2 = block;
        class_2248 block3 = (class_2248)CHARGE_INCREASES.get().get((Object)block);
        while (block3 != null) {
            block2 = block3;
            block3 = (class_2248)CHARGE_INCREASES.get().get((Object)block3);
        }
        return block2;
    }

    public static Optional<class_2248> getIncreasedChargeBlock(class_2248 block) {
        return Optional.ofNullable((class_2248)CHARGE_INCREASES.get().get((Object)block));
    }

    public static Optional<class_2680> getIncreasedChargeState(class_2680 state) {
        return Dischargable.getIncreasedChargeBlock(state.method_26204()).map(block -> block.method_34725(state));
    }

    public static Optional<class_2248> getDecreasedChargeBlock(class_2248 block) {
        return Optional.ofNullable((class_2248)CHARGE_DECREASES.get().get((Object)block));
    }

    public static class_2680 getMaxChargedState(class_2680 state) {
        return Dischargable.getMaxChargedBlock(state.method_26204()).method_34725(state);
    }

    default public Optional<class_2680> method_31639(class_2680 state) {
        return Dischargable.getDecreasedChargeBlock(state.method_26204()).map(block -> block.method_34725(state));
    }

    default public float method_33620() {
        return 1.0f;
    }

    public static enum ChargeLevel implements class_3542
    {
        OVERCHARGED(0, "overcharged"),
        STRONG(1, "strong"),
        MEDIUM(2, "medium"),
        WEAK(3, "weak");

        public static final Codec<ChargeLevel> CODEC;
        private final int number;
        private final String id;

        private ChargeLevel(int number, String id) {
            this.number = number;
            this.id = id;
        }

        public int getNumber() {
            return this.number;
        }

        public String method_15434() {
            return this.id;
        }

        static {
            CODEC = class_3542.method_28140(ChargeLevel::values);
        }
    }
}

