/*
 * Decompiled with CFR 0.152.
 */
package net.moss.resonance.util;

import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2743;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import net.moss.resonance.Resonance;
import net.moss.resonance.util.Utils;
import net.moss.resonance.util.interfaces.PlayerEntityInterface;
import org.jetbrains.annotations.Nullable;

public class GroundPoundType {
    private final class_1322 gravity;
    private final float baseDamage;
    private final float baseRange;
    private final float baseKnockback;
    private final float damageMultiplier;
    private final float rangeMultiplier;
    private final float knockbackMultiplier;
    private final float damageCap;
    private final float rangeCap;
    private final float knockbackCap;

    public GroundPoundType(double gravity, float baseDamage, float baseRange, float baseKnockback, float damageMultiplier, float rangeMultiplier, float knockbackMultiplier, float damageCap, float rangeCap, float knockbackCap) {
        this.gravity = new class_1322(class_2960.method_60655((String)"resonance", (String)"generic_ground_pound"), gravity, class_1322.class_1323.field_6328);
        this.baseDamage = baseDamage;
        this.baseRange = baseRange;
        this.baseKnockback = baseKnockback;
        this.damageMultiplier = damageMultiplier;
        this.rangeMultiplier = rangeMultiplier;
        this.knockbackMultiplier = knockbackMultiplier;
        this.damageCap = damageCap;
        this.rangeCap = rangeCap;
        this.knockbackCap = knockbackCap;
    }

    public GroundPoundType(double gravity) {
        this(gravity, 0.0f, 1.0f, 0.1f, 1.0f, 0.3f, 0.1f, 20.0f, 4.0f, 0.7f);
    }

    public void start(class_3218 world, class_1657 user) {
        user.method_5996(class_5134.field_49078).method_6200(this.gravity.comp_2447());
        user.method_5996(class_5134.field_49078).method_26835(this.gravity);
        PlayerEntityInterface player = (PlayerEntityInterface)user;
        player.cancelGroundPound(user);
        player.startGroundPound(world, user, this);
    }

    public void tick(class_3218 world, class_1657 user) {
    }

    public void end(class_3218 world, class_1657 user, @Nullable class_1297 target) {
        user.method_5996(class_5134.field_49078).method_6200(this.gravity.comp_2447());
        float fallDistance = user.field_6017 + 2.0f;
        float damageCalc = this.calculateDamage(fallDistance);
        float rangeCalc = this.calculateRange(fallDistance);
        float knockbackCalc = this.calculateKnockback(fallDistance);
        world.method_8390(class_1309.class, user.method_5829().method_1014((double)rangeCalc), class_1297::method_5732).forEach(entity -> {
            if (entity == user) {
                return;
            }
            this.indirectHitEntity(world, user, (class_1309)entity, damageCalc, rangeCalc, knockbackCalc, fallDistance);
        });
        if (target != null) {
            this.directHitEntity(world, user, (class_1309)user, damageCalc, rangeCalc, knockbackCalc, fallDistance);
        }
        this.endEffects(world, user, damageCalc, rangeCalc, knockbackCalc, fallDistance);
    }

    public void cancel(class_1657 user) {
        class_1324 entityAttributeInstance = user.method_5996(class_5134.field_49078);
        entityAttributeInstance.method_6200(this.gravity.comp_2447());
    }

    public float calculateDamage(float fallDistance) {
        return Math.min(this.baseDamage + this.damageMultiplier * fallDistance, this.damageCap);
    }

    public float calculateRange(float fallDistance) {
        return Math.min(this.baseRange + this.rangeMultiplier * fallDistance, this.rangeCap);
    }

    public float calculateKnockback(float fallDistance) {
        return Math.min(this.baseKnockback + this.knockbackMultiplier * fallDistance, this.knockbackCap);
    }

    public void directHitEntity(class_3218 world, class_1657 user, class_1309 target, float damage, float range, float knockback, float fallDistance) {
        user.field_6017 = 0.0f;
    }

    public void indirectHitEntity(class_3218 world, class_1657 user, class_1309 target, float damage, float range, float knockback, float fallDistance) {
        class_243 vec3d = target.method_19538().method_1020(user.method_19538());
        double k = ((double)range - vec3d.method_1033()) * (double)knockback * (1.0 - target.method_45325(class_5134.field_23718));
        float d = (float)((double)damage - vec3d.method_1033());
        if (d >= 0.0f) {
            target.method_5643(Utils.damageSource((class_1937)world, Resonance.GROUND_POUND_DAMAGE, (class_1297)user), d);
        }
        if (k > 0.0) {
            class_243 vec3d2 = vec3d.method_1029().method_1021(k);
            target.method_5762(vec3d2.field_1352, (double)0.7f, vec3d2.field_1350);
            if (target instanceof class_3222) {
                class_3222 serverPlayerEntity = (class_3222)target;
                serverPlayerEntity.field_13987.method_14364((class_2596)new class_2743((class_1297)serverPlayerEntity));
            }
        }
    }

    public void endEffects(class_3218 world, class_1657 user, float damage, float range, float knockback, float fallDistance) {
        user.field_6017 = fallDistance / 4.0f;
        int count = Math.min((int)Math.ceil(fallDistance) / 6, 15);
        class_243 vec3d = user.method_19538();
        world.method_14199((class_2394)class_2398.field_49139, vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, count, 0.5, 0.0, 0.5, (double)fallDistance);
        user.method_37908().method_45447(null, user.method_24515(), class_3417.field_14840, class_3419.field_15248);
    }
}

