/*
 * Decompiled with CFR 0.152.
 */
package net.moss.resonance.util;

import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketItem;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_117;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_141;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1887;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_219;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2743;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3545;
import net.minecraft.class_3610;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_44;
import net.minecraft.class_5134;
import net.minecraft.class_5151;
import net.minecraft.class_5321;
import net.minecraft.class_5362;
import net.minecraft.class_55;
import net.minecraft.class_5642;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_6662;
import net.minecraft.class_6880;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.moss.resonance.Resonance;
import net.moss.resonance.util.SetPearlStatsLootFunction;
import org.jetbrains.annotations.Nullable;

public class Utils {
    public static class_1282 damageSource(class_1937 world, class_5321<class_8110> key) {
        return new class_1282((class_6880)world.method_30349().method_30530(class_7924.field_42534).method_40290(key));
    }

    public static class_1282 damageSource(class_1937 world, class_5321<class_8110> key, @Nullable class_1297 attacker) {
        return new class_1282((class_6880)world.method_30349().method_30530(class_7924.field_42534).method_40290(key), attacker);
    }

    public static class_1282 damageSource(class_1937 world, class_5321<class_8110> key, @Nullable class_243 position) {
        return new class_1282((class_6880)world.method_30349().method_30530(class_7924.field_42534).method_40290(key), position);
    }

    public static class_55.class_56 lootPoolBuilder(float rolls, float conditionally, class_1792 item, float countMin, float countMax) {
        return class_55.method_347().method_352((class_5658)class_44.method_32448((float)rolls)).method_356(class_219.method_932((float)conditionally)).method_351((class_79.class_80)class_77.method_411((class_1935)item)).method_353((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)countMin, (float)countMax)));
    }

    public static class_55.class_56 enchantLootPoolBuilder(float rolls, float conditionally, class_1792 item, class_6880<class_1887> enchant, int level) {
        return class_55.method_347().method_352((class_5658)class_44.method_32448((float)rolls)).method_356(class_219.method_932((float)conditionally)).method_351((class_79.class_80)class_77.method_411((class_1935)item)).method_353((class_117.class_118)new class_5642.class_6158().method_35539(enchant, (class_5658)class_44.method_32448((float)level)));
    }

    public static class_55.class_56 pearlLootPoolBuilder(float rolls, float conditionally, class_1792 item, float countMin, float countMax, class_6880<class_1842> potion, int duration, int recuperation, int strength, int shinyBound) {
        return class_55.method_347().method_352((class_5658)class_44.method_32448((float)rolls)).method_356(class_219.method_932((float)conditionally)).method_351((class_79.class_80)class_77.method_411((class_1935)item)).method_353((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)countMin, (float)countMax))).method_353((class_117.class_118)class_6662.method_38927(potion)).method_353(SetPearlStatsLootFunction.builder(duration, recuperation, strength, shinyBound));
    }

    public static boolean isItemEquipped(class_1309 entity, class_1792 item, boolean checkHands) {
        Optional optional;
        for (class_1304 slot : class_1304.values()) {
            if (!slot.method_46643() && !checkHands || entity.method_6118(slot).method_7909() != item) continue;
            return true;
        }
        return Resonance.isTrinketsInstalled && (optional = TrinketsApi.getTrinketComponent((class_1309)entity)).isPresent() && ((TrinketComponent)optional.get()).isEquipped(item);
    }

    public static class_1271<class_1799> trinketHotswap(class_1937 world, class_1657 user, class_1268 hand, class_1792 item) {
        class_1799 stack;
        if (Resonance.isTrinketsInstalled && TrinketItem.equipItem((class_1657)user, (class_1799)(stack = user.method_5998(hand)))) {
            class_1271.method_29237((Object)stack, (boolean)world.method_8608());
        }
        if (item instanceof class_5151) {
            class_5151 equipment = (class_5151)item;
            return equipment.method_48576(item, world, user, hand);
        }
        return null;
    }

    public static List<class_1799> getAllEquipped(class_1309 entity, boolean checkHands) {
        Optional optional;
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        if (!checkHands) {
            entity.method_56674().forEach(item -> items.add((class_1799)item));
        } else {
            entity.method_56675().forEach(item -> items.add((class_1799)item));
        }
        if (Resonance.isTrinketsInstalled && (optional = TrinketsApi.getTrinketComponent((class_1309)entity)).isPresent()) {
            List equipped = ((TrinketComponent)optional.get()).getAllEquipped();
            for (class_3545 pair : equipped) {
                items.add((class_1799)pair.method_15441());
            }
        }
        return items;
    }

    public static void sumStatusEffectAmplifiers(class_1309 entity, class_1293 additionalEffect, int cap) {
        class_6880 effectType = additionalEffect.method_5579();
        if (entity.method_6059(effectType)) {
            int newAmplifier = entity.method_6112(effectType).method_5578() + additionalEffect.method_5578() + 1;
            if (newAmplifier <= cap) {
                class_1293 resultEffect = new class_1293(effectType, additionalEffect.method_5584(), newAmplifier);
                entity.method_6092(resultEffect);
            }
        } else {
            entity.method_6092(additionalEffect);
        }
    }

    public static void decrementStatusEffectAmplifiers(class_1309 entity, class_6880<class_1291> effectType, @Nullable Integer duration) {
        if (entity.method_6059(effectType)) {
            class_1293 effectInstance = entity.method_6112(effectType);
            int newAmplifier = effectInstance.method_5578() - 1;
            entity.method_6016(effectType);
            if (newAmplifier >= 0 && newAmplifier < 256) {
                if (duration == null) {
                    duration = effectInstance.method_5584();
                }
                class_1293 resultEffect = new class_1293(effectType, duration.intValue(), newAmplifier, effectInstance.method_5591(), effectInstance.method_5581(), effectInstance.method_5592());
                entity.method_6092(resultEffect);
            }
        }
    }

    public static boolean isAttackCritical(class_1657 player, class_1297 target) {
        return player.method_7261(0.5f) > 0.9f && player.field_6017 > 0.0f && !player.method_24828() && !player.method_6101() && !player.method_5799() && !player.method_6059(class_1294.field_5919) && !player.method_5765() && target instanceof class_1309 && !player.method_5624();
    }

    public static void customKnockback(class_1309 entity, class_243 source, float strength, class_243 plus, class_243 dampenMultipliers, @Nullable Float clamp) {
        if ((double)(strength = (float)((double)strength * (1.0 - entity.method_45325(class_5134.field_23718)))) <= 0.0) {
            return;
        }
        entity.field_6007 = true;
        class_243 vec3d = entity.method_19538().method_1031(0.0, (double)(entity.method_17682() / 2.0f), 0.0).method_1020(source).method_1029().method_1021((double)strength).method_1019(plus).method_18806(dampenMultipliers).method_1019(entity.method_18798());
        if (clamp != null && vec3d.method_1033() > (double)clamp.floatValue()) {
            vec3d = vec3d.method_1029().method_1021((double)clamp.floatValue());
        }
        entity.field_6017 = (float)((double)entity.field_6017 / Math.max(entity.method_18798().method_10214() / vec3d.method_10214(), 1.0));
        entity.method_18799(vec3d);
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            player.field_13987.method_14364((class_2596)new class_2743((class_1297)player));
        }
    }

    public static void customKnockback(class_1309 entity, class_243 source, float strength) {
        Utils.customKnockback(entity, source, strength, new class_243(0.0, 0.0, 0.0), new class_243(1.0, 1.0, 1.0), null);
    }

    public static void customKnockbackPlus(class_1309 entity, class_243 source, float strength, class_243 plus) {
        Utils.customKnockback(entity, source, strength, plus, new class_243(1.0, 1.0, 1.0), null);
    }

    public static void customKnockbackClamp(class_1309 entity, class_243 source, float strength, @Nullable Float clamp) {
        Utils.customKnockback(entity, source, strength, new class_243(0.0, 0.0, 0.0), new class_243(1.0, 1.0, 1.0), clamp);
    }

    public static void customKnockbackDampen(class_1309 entity, class_243 source, float strength, class_243 dampenMultipliers) {
        Utils.customKnockback(entity, source, strength, new class_243(0.0, 0.0, 0.0), dampenMultipliers, null);
    }

    public static class_3966 entityRaycast(class_1657 player, float distance) {
        class_243 vec3d = player.method_33571();
        class_243 vec3d2 = vec3d.method_1019(player.method_5631(player.method_36455(), player.method_36454()).method_1021((double)distance));
        return class_1675.method_18075((class_1297)player, (class_243)vec3d, (class_243)vec3d2, (class_238)new class_238(vec3d, vec3d2), entity -> !entity.method_7325() && entity.method_5863(), (double)(distance * 10.0f));
    }

    public static class_3965 blockRaycast(class_1937 world, class_1657 player, float distance, class_3959.class_242 fluidHandling) {
        class_243 vec3d = player.method_33571();
        class_243 vec3d2 = vec3d.method_1019(player.method_5631(player.method_36455(), player.method_36454()).method_1021((double)distance));
        return world.method_17742(new class_3959(vec3d, vec3d2, class_3959.class_3960.field_17559, fluidHandling, (class_1297)player));
    }

    public static class_239 raycast(class_1937 world, class_1657 player, float distance, class_3959.class_242 fluidHandling) {
        class_3966 entityHitResult = Utils.entityRaycast(player, distance);
        if (entityHitResult != null && entityHitResult.method_17782() != null) {
            return entityHitResult;
        }
        class_3965 blockHitResult = Utils.blockRaycast(world, player, distance, fluidHandling);
        return blockHitResult;
    }

    public static class_239 raycast(class_1937 world, class_1657 player, class_3959.class_242 fluidHandling) {
        return Utils.raycast(world, player, (float)player.method_55754(), fluidHandling);
    }

    public static class_239 raycast(class_1937 world, class_1657 player, float distance) {
        return Utils.raycast(world, player, distance, class_3959.class_242.field_1347);
    }

    public static class_239 raycast(class_1937 world, class_1657 player) {
        return Utils.raycast(world, player, (float)player.method_55754(), class_3959.class_242.field_1347);
    }

    public static List<class_1297> entitiesInRadius(class_1937 world, class_243 pos, @Nullable class_1297 except, float searchRadius, float searchHeight, Predicate<? super class_1297> predicate) {
        return world.method_8333(except, new class_238(pos.method_10216() - (double)searchRadius, pos.method_10214() - (double)searchHeight, pos.method_10215() - (double)searchRadius, pos.method_10216() + (double)searchRadius, pos.method_10214() + (double)searchHeight, pos.method_10215() + (double)searchRadius), predicate);
    }

    public static boolean canMobSpawn(class_1937 world, class_2338 pos) {
        if (!world.method_8320(pos.method_10074()).method_26206((class_1922)world, pos.method_10074(), class_2350.field_11036)) {
            return false;
        }
        int i = world.method_8597().method_44223();
        return world.method_8314(class_1944.field_9282, pos) <= i;
    }

    public static final class CustomWindChargeBehavior
    extends class_5362 {
        private final Float knockback;

        public CustomWindChargeBehavior(Float knockback) {
            this.knockback = knockback;
        }

        public float method_57007(class_1297 entity) {
            return this.knockback.floatValue();
        }

        public boolean method_55504(class_1927 explosion, class_1297 entity) {
            return false;
        }

        public Optional<Float> method_29555(class_1927 explosion, class_1922 world, class_2338 pos, class_2680 blockState, class_3610 fluidState) {
            if (blockState.method_26164(class_3481.field_49051)) {
                return Optional.of(Float.valueOf(3600000.0f));
            }
            return Optional.empty();
        }
    }
}

