/*
 * Decompiled with CFR 0.152.
 */
package net.moss.resonance.world;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_3777;
import net.minecraft.class_3778;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_5434;
import net.minecraft.class_5455;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_5868;
import net.minecraft.class_6122;
import net.minecraft.class_6626;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.class_7151;
import net.minecraft.class_7924;
import net.minecraft.class_8889;
import net.minecraft.class_8891;
import net.minecraft.class_9778;
import net.minecraft.class_9822;
import net.moss.resonance.Resonance;

public class FixedStructureType
extends class_3195 {
    public static final MapCodec<FixedStructureType> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FixedStructureType.method_42697((RecordCodecBuilder.Instance)instance), (App)class_3785.field_24954.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)class_2960.field_25139.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)20).fieldOf("size").forGetter(structure -> structure.size), (App)Codec.INT.fieldOf("x").forGetter(structure -> structure.x), (App)class_6122.field_31540.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Codec.INT.fieldOf("z").forGetter(structure -> structure.z), (App)Codec.INT.optionalFieldOf("grid_offset", (Object)0).forGetter(structure -> structure.gridOffset), (App)Codec.BOOL.optionalFieldOf("multiple_of_coords", (Object)false).forGetter(structure -> structure.multipleOf), (App)class_2470.field_39313.optionalFieldOf("fixed_rotation").forGetter(structure -> structure.fixedRotation), (App)Codec.BOOL.fieldOf("use_expansion_hack").forGetter(structure -> structure.useExpansionHack), (App)class_2902.class_2903.field_24772.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.list((Codec)class_8889.field_46825).optionalFieldOf("pool_aliases", List.of()).forGetter(structure -> structure.poolAliasBindings), (App)class_9778.field_51952.optionalFieldOf("dimension_padding", (Object)class_5434.field_51911).forGetter(structure -> structure.dimensionPadding), (App)class_9822.field_52239.optionalFieldOf("liquid_settings", (Object)class_5434.field_52235).forGetter(structure -> structure.liquidSettings)).apply((Applicative)instance, FixedStructureType::new));
    private final class_6880<class_3785> startPool;
    private final Optional<class_2960> startJigsawName;
    private final int size;
    public final int x;
    private final class_6122 startHeight;
    public final int z;
    public final int gridOffset;
    public final boolean multipleOf;
    public final Optional<class_2470> fixedRotation;
    private final boolean useExpansionHack;
    private final Optional<class_2902.class_2903> projectStartToHeightmap;
    private final int maxDistanceFromCenter;
    private final List<class_8889> poolAliasBindings;
    private final class_9778 dimensionPadding;
    private final class_9822 liquidSettings;

    public FixedStructureType(class_3195.class_7302 config, class_6880<class_3785> startPool, Optional<class_2960> startJigsawName, int size, int x, class_6122 startHeight, int z, int gridOffset, boolean multipleOf, Optional<class_2470> fixedRotation, boolean useExpansionHack, Optional<class_2902.class_2903> projectStartToHeightmap, int maxDistanceFromCenter, List<class_8889> poolAliasBindings, class_9778 dimensionPadding, class_9822 liquidSettings) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.x = x;
        this.startHeight = startHeight;
        this.z = z;
        this.gridOffset = gridOffset;
        this.multipleOf = multipleOf;
        this.fixedRotation = fixedRotation;
        this.useExpansionHack = useExpansionHack;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.poolAliasBindings = poolAliasBindings;
        this.dimensionPadding = dimensionPadding;
        this.liquidSettings = liquidSettings;
    }

    public FixedStructureType(class_3195.class_7302 config, class_6880<class_3785> startPool, int size, int x, class_6122 startHeight, int z, boolean useExpansionHack, class_2902.class_2903 projectStartToHeightmap) {
        this(config, startPool, Optional.empty(), size, x, startHeight, z, 0, false, Optional.empty(), useExpansionHack, Optional.of(projectStartToHeightmap), 80, List.of(), class_5434.field_51911, class_5434.field_52235);
    }

    public FixedStructureType(class_3195.class_7302 config, class_6880<class_3785> startPool, int size, int x, class_6122 startHeight, int z, boolean useExpansionHack) {
        this(config, startPool, Optional.empty(), size, x, startHeight, z, 0, false, Optional.empty(), useExpansionHack, Optional.empty(), 80, List.of(), class_5434.field_51911, class_5434.field_52235);
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        class_2338 blockPos;
        if (this.multipleOf) {
            class_1923 chunkPos = context.comp_568();
            blockPos = new class_2338(chunkPos.method_8326() / this.x * this.x + this.gridOffset, this.startHeight.method_35391((class_5819)context.comp_566(), new class_5868(context.comp_562(), context.comp_569())), chunkPos.method_8328() / this.z * this.z + this.gridOffset);
        } else {
            blockPos = new class_2338(this.x, this.startHeight.method_35391((class_5819)context.comp_566(), new class_5868(context.comp_562(), context.comp_569())), this.z);
        }
        if (this.fixedRotation.isPresent()) {
            return FixedStructureType.generate(context, this.fixedRotation.get(), this.startPool, this.startJigsawName, this.size, blockPos, this.maxDistanceFromCenter, this.liquidSettings);
        }
        return class_3778.method_30419((class_3195.class_7149)context, this.startPool, this.startJigsawName, (int)this.size, (class_2338)blockPos, (boolean)this.useExpansionHack, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter, (class_8891)class_8891.create(this.poolAliasBindings, (class_2338)blockPos, (long)context.comp_567()), (class_9778)this.dimensionPadding, (class_9822)this.liquidSettings);
    }

    public class_7151<?> method_41618() {
        return Resonance.FIXED_STRUCTURE_TYPE;
    }

    public static Optional<class_3195.class_7150> generate(class_3195.class_7149 context, class_2470 blockRotation, class_6880<class_3785> structurePool, Optional<class_2960> id, int size, class_2338 pos, int maxDistanceFromCenter, class_9822 liquidSettings) {
        class_2338 blockPos;
        class_5455 dynamicRegistryManager = context.comp_561();
        class_2794 chunkGenerator = context.comp_562();
        class_3485 structureTemplateManager = context.comp_565();
        class_5539 heightLimitView = context.comp_569();
        class_2919 chunkRandom = context.comp_566();
        class_2378 registry = dynamicRegistryManager.method_30530(class_7924.field_41249);
        class_3784 structurePoolElement = ((class_3785)structurePool.comp_349()).method_16631((class_5819)chunkRandom);
        if (structurePoolElement == class_3777.field_16663) {
            return Optional.empty();
        }
        if (id.isPresent()) {
            class_2960 identifier = id.get();
            Optional<class_2338> optional = FixedStructureType.findStartingJigsawPos(structurePoolElement, identifier, pos, blockRotation, structureTemplateManager, chunkRandom);
            if (optional.isEmpty()) {
                Resonance.LOGGER.error("No starting jigsaw {} found in start pool {}", (Object)identifier, (Object)structurePool.method_40230().map(key -> key.method_29177().toString()).orElse("<unregistered>"));
                return Optional.empty();
            }
            blockPos = optional.get();
        } else {
            blockPos = pos;
        }
        class_2338 vec3i = blockPos.method_10059((class_2382)pos);
        class_2338 blockPos2 = pos.method_10059((class_2382)vec3i);
        class_3790 poolStructurePiece = new class_3790(structureTemplateManager, structurePoolElement, blockPos2, structurePoolElement.method_19308(), blockRotation, structurePoolElement.method_16628(structureTemplateManager, blockPos2, blockRotation), liquidSettings);
        class_3341 blockBox = poolStructurePiece.method_14935();
        int i = (blockBox.method_35418() + blockBox.method_35415()) / 2;
        int j = (blockBox.method_35420() + blockBox.method_35417()) / 2;
        int k = blockPos2.method_10264();
        int l = blockBox.method_35416() + poolStructurePiece.method_16646();
        poolStructurePiece.method_14922(0, k - l, 0);
        int m = k + vec3i.method_10264();
        return Optional.of(new class_3195.class_7150(new class_2338(i, m, j), collector -> {
            ArrayList list = Lists.newArrayList();
            list.add(poolStructurePiece);
            if (size > 0) {
                class_238 box = new class_238((double)(i - maxDistanceFromCenter), (double)Math.max(m - maxDistanceFromCenter, heightLimitView.method_31607()), (double)(j - maxDistanceFromCenter), (double)(i + maxDistanceFromCenter + 1), (double)Math.min(m + maxDistanceFromCenter + 1, heightLimitView.method_31600()), (double)(j + maxDistanceFromCenter + 1));
                class_265 voxelShape = class_259.method_1072((class_265)class_259.method_1078((class_238)box), (class_265)class_259.method_1078((class_238)class_238.method_19316((class_3341)blockBox)), (class_247)class_247.field_16886);
                class_3778.method_27230((class_7138)context.comp_564(), (int)size, (boolean)true, (class_2794)chunkGenerator, (class_3485)structureTemplateManager, (class_5539)heightLimitView, (class_5819)chunkRandom, (class_2378)registry, (class_3790)poolStructurePiece, (List)list, (class_265)voxelShape, (class_8891)class_8891.field_46826, (class_9822)liquidSettings);
                list.forEach(arg_0 -> ((class_6626)collector).method_35462(arg_0));
            }
        }));
    }

    private static Optional<class_2338> findStartingJigsawPos(class_3784 pool, class_2960 id, class_2338 pos, class_2470 rotation, class_3485 structureManager, class_2919 random) {
        List list = pool.method_16627(structureManager, pos, rotation, (class_5819)random);
        for (class_3499.class_3501 structureBlockInfo : list) {
            class_2960 identifier = class_2960.method_12829((String)Objects.requireNonNull(structureBlockInfo.comp_1343(), () -> String.valueOf(structureBlockInfo) + " nbt was null").method_10558("name"));
            if (!id.equals((Object)identifier)) continue;
            return Optional.of(structureBlockInfo.comp_1341());
        }
        return Optional.empty();
    }
}

