/*
 * Decompiled with CFR 0.152.
 */
package yuuki1293.ae2peat.parts;

import appeng.api.config.Settings;
import appeng.api.config.ShowPatternProviders;
import appeng.api.networking.IGrid;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.storage.MEStorage;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.helpers.IPatternTerminalLogicHost;
import appeng.helpers.IPatternTerminalMenuHost;
import appeng.items.parts.PartModels;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import appeng.parts.encoding.PatternEncodingLogic;
import appeng.parts.reporting.AbstractDisplayPart;
import appeng.util.ConfigManager;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import yuuki1293.ae2peat.AE2PEAT;
import yuuki1293.ae2peat.api.config.AccessSearchMode;
import yuuki1293.ae2peat.api.config.PEATSettings;
import yuuki1293.ae2peat.definisions.PEATMenus;

public class PatternEncodingAccessTerminalPart
extends AbstractDisplayPart
implements IConfigurableObject,
IPatternTerminalLogicHost,
IPatternTerminalMenuHost {
    private final IConfigManager cm = new ConfigManager(this::saveChanges);
    @PartModels
    public static final ResourceLocation MODEL_OFF = AE2PEAT.makeId("part/pattern_encoding_access_terminal_off");
    @PartModels
    public static final ResourceLocation MODEL_ON = AE2PEAT.makeId("part/pattern_encoding_access_terminal_on");
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_OFF, MODEL_STATUS_OFF});
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_ON, MODEL_STATUS_ON});
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_ON, MODEL_STATUS_HAS_CHANNEL});
    private final PatternEncodingLogic logic = new PatternEncodingLogic((IPatternTerminalLogicHost)this);

    public PatternEncodingAccessTerminalPart(IPartItem<?> partItem) {
        super(partItem, true);
        this.cm.registerSetting(Settings.TERMINAL_SHOW_PATTERN_PROVIDERS, (Enum)ShowPatternProviders.VISIBLE);
        this.cm.registerSetting(PEATSettings.ACCESS_SEARCH_MODE, (Enum)AccessSearchMode.BOTH);
    }

    public IPartModel getStaticModels() {
        return this.selectModel(MODELS_OFF, MODELS_ON, MODELS_HAS_CHANNEL);
    }

    public IConfigManager getConfigManager() {
        return this.cm;
    }

    public void saveChanges() {
        this.getHost().markForSave();
    }

    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        this.cm.writeToNBT(tag);
        this.logic.writeToNBT(tag);
    }

    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.cm.readFromNBT(tag);
        this.logic.readFromNBT(tag);
    }

    public void addAdditionalDrops(List<ItemStack> drops, boolean wrenched) {
        super.addAdditionalDrops(drops, wrenched);
        for (ItemStack is : this.logic.getBlankPatternInv()) {
            drops.add(is);
        }
        for (ItemStack is : this.logic.getEncodedPatternInv()) {
            drops.add(is);
        }
    }

    public boolean onPartActivate(Player player, InteractionHand hand, Vec3 pos) {
        if (!super.onPartActivate(player, hand, pos) && !this.isClientSide()) {
            MenuOpener.open(PEATMenus.PATTERN_ENCODING_ACCESS_TERMINAL.get(), (Player)player, (MenuLocator)MenuLocators.forPart((AEBasePart)this));
        }
        return true;
    }

    public void m_6211_() {
        super.m_6211_();
        this.logic.getBlankPatternInv().clear();
        this.logic.getEncodedPatternInv().clear();
    }

    public PatternEncodingLogic getLogic() {
        return this.logic;
    }

    public void markForSave() {
        this.getHost().markForSave();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> this.logic.getBlankPatternInv().toItemHandler()).cast();
        }
        return super.getCapability(cap);
    }

    public void returnToMainMenu(Player player, ISubMenu subMenu) {
        MenuOpener.open(PEATMenus.PATTERN_ENCODING_ACCESS_TERMINAL.get(), (Player)player, (MenuLocator)subMenu.getLocator(), (boolean)true);
    }

    public ItemStack getMainMenuIcon() {
        return new ItemStack((ItemLike)this.getPartItem());
    }

    public MEStorage getInventory() {
        IGrid grid = this.getMainNode().getGrid();
        if (grid != null) {
            return grid.getStorageService().getInventory();
        }
        return null;
    }
}

