/*
 * Decompiled with CFR 0.152.
 */
package yuuki1293.ae2peat.menu;

import appeng.api.config.Setting;
import appeng.api.config.Settings;
import appeng.api.config.ShowPatternProviders;
import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.implementations.blockentities.PatternContainerGroup;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.ILinkStatus;
import appeng.api.storage.IPatternAccessTermMenuHost;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.MEStorage;
import appeng.api.storage.cells.IBasicCellItem;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigManagerListener;
import appeng.api.util.IConfigurableObject;
import appeng.api.util.KeyTypeSelectionHost;
import appeng.blockentity.crafting.IMolecularAssemblerSupportedPattern;
import appeng.client.gui.Icon;
import appeng.core.AELog;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.network.ClientboundPacket;
import appeng.core.network.bidirectional.ConfigValuePacket;
import appeng.core.network.clientbound.ClearPatternAccessTerminalPacket;
import appeng.core.network.clientbound.MEInventoryUpdatePacket;
import appeng.core.network.clientbound.PatternAccessTerminalPacket;
import appeng.core.network.clientbound.SetLinkStatusPacket;
import appeng.core.network.serverbound.MEInteractionPacket;
import appeng.crafting.pattern.AECraftingPattern;
import appeng.helpers.InventoryAction;
import appeng.helpers.patternprovider.PatternContainer;
import appeng.me.helpers.ActionHostEnergySource;
import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.guisync.LinkStatusAwareMenu;
import appeng.menu.interfaces.KeyTypeSelectionMenu;
import appeng.menu.me.common.GridInventoryEntry;
import appeng.menu.me.common.IClientRepo;
import appeng.menu.me.common.IMEInteractionHandler;
import appeng.menu.me.common.IncrementalUpdateHelper;
import appeng.menu.slot.FakeSlot;
import appeng.menu.slot.PatternTermSlot;
import appeng.menu.slot.RestrictedInputSlot;
import appeng.parts.encoding.EncodingMode;
import appeng.parts.encoding.PatternEncodingLogic;
import appeng.util.ConfigInventory;
import appeng.util.ConfigMenuInventory;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.filter.IAEItemFilter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yuuki1293.ae2peat.api.config.AccessSearchMode;
import yuuki1293.ae2peat.api.config.AutoFilter;
import yuuki1293.ae2peat.api.config.PEATSettings;
import yuuki1293.ae2peat.definisions.PEATMenus;
import yuuki1293.ae2peat.menu.IPEATMenuHost;
import yuuki1293.ae2peat.parts.PatternEncodingAccessTerminalPart;

public class PatternEncodingAccessTermMenu
extends AEBaseMenu
implements IConfigManagerListener,
IConfigurableObject,
IMEInteractionHandler,
LinkStatusAwareMenu {
    private final IConfigManager clientCM;
    private final ITerminalHost termHost;
    @GuiSync(value=100)
    public int activeCraftingJobs = -1;
    private static final short SEARCH_KEY_TYPES_ID = 101;
    @GuiSync(value=101)
    public KeyTypeSelectionMenu.SyncedKeyTypes searchKeyTypes = new KeyTypeSelectionMenu.SyncedKeyTypes();
    private ILinkStatus linkStatus = ILinkStatus.ofDisconnected(null);
    @Nullable
    private Runnable gui;
    private IConfigManager serverCM;
    protected final MEStorage storage;
    protected final IEnergySource energySource;
    private final IncrementalUpdateHelper updateHelper = new IncrementalUpdateHelper();
    @Nullable
    private IClientRepo clientRepo;
    private Set<AEKey> previousCraftables = Collections.emptySet();
    private KeyCounter previousAvailableStacks = new KeyCounter();
    private IPatternAccessTermMenuHost accessHost;
    @GuiSync(value=1)
    public ShowPatternProviders showPatternProviders = ShowPatternProviders.VISIBLE;
    @GuiSync(value=2)
    public AccessSearchMode accessSearchMode = AccessSearchMode.BOTH;
    @GuiSync(value=3)
    public AutoFilter autoFilter = AutoFilter.DISABLED;
    private static long inventorySerial = Long.MIN_VALUE;
    private final Map<PatternContainer, ContainerTracker> diList = new IdentityHashMap<PatternContainer, ContainerTracker>();
    private final Long2ObjectOpenHashMap<ContainerTracker> byId = new Long2ObjectOpenHashMap();
    private final Set<PatternContainer> pinnedHosts = Collections.newSetFromMap(new IdentityHashMap());
    private static final int CRAFTING_GRID_WIDTH = 3;
    private static final int CRAFTING_GRID_HEIGHT = 3;
    private static final int CRAFTING_GRID_SLOTS = 9;
    private static final String ACTION_SET_MODE = "setMode";
    private static final String ACTION_ENCODE = "encode";
    private static final String ACTION_CLEAR = "clear";
    private static final String ACTION_SET_SUBSTITUTION = "setSubstitution";
    private static final String ACTION_SET_FLUID_SUBSTITUTION = "setFluidSubstitution";
    private static final String ACTION_SET_STONECUTTING_RECIPE_ID = "setStonecuttingRecipeId";
    private static final String ACTION_CYCLE_PROCESSING_OUTPUT = "cycleProcessingOutput";
    private final PatternEncodingLogic encodingLogic;
    private final FakeSlot[] craftingGridSlots = new FakeSlot[9];
    private final FakeSlot[] processingInputSlots = new FakeSlot[81];
    private final FakeSlot[] processingOutputSlots = new FakeSlot[27];
    private final FakeSlot stonecuttingInputSlot;
    private final FakeSlot smithingTableTemplateSlot;
    private final FakeSlot smithingTableBaseSlot;
    private final FakeSlot smithingTableAdditionSlot;
    private final PatternTermSlot craftOutputSlot;
    private final RestrictedInputSlot blankPatternSlot;
    private final RestrictedInputSlot encodedPatternSlot;
    private final ConfigInventory encodedInputsInv;
    private final ConfigInventory encodedOutputsInv;
    private RecipeHolder<CraftingRecipe> currentRecipe;
    private EncodingMode currentMode;
    @GuiSync(value=97)
    public EncodingMode mode = EncodingMode.CRAFTING;
    @GuiSync(value=96)
    public boolean substitute = false;
    @GuiSync(value=95)
    public boolean substituteFluids = true;
    @GuiSync(value=94)
    @Nullable
    public ResourceLocation stonecuttingRecipeId;
    private final List<RecipeHolder<StonecutterRecipe>> stonecuttingRecipes = new ArrayList<RecipeHolder<StonecutterRecipe>>();
    public IntSet slotsSupportingFluidSubstitution = new IntArraySet();
    private Consumer<ResourceLocation> setSearchAsRecipe;

    public ShowPatternProviders getShownProviders() {
        return this.showPatternProviders;
    }

    public AccessSearchMode getAccessSearchMode() {
        return this.accessSearchMode;
    }

    public AutoFilter getAutoFilter() {
        return this.autoFilter;
    }

    public PatternEncodingAccessTermMenu(int id, Inventory ip, PatternEncodingAccessTerminalPart anchor) {
        this(PEATMenus.PATTERN_ENCODING_ACCESS_TERMINAL.get(), id, ip, anchor, true);
    }

    public PatternEncodingAccessTermMenu(MenuType<?> menuType, int id, Inventory ip, IPEATMenuHost host, boolean bindInventory) {
        super(menuType, id, ip, (Object)host);
        int i;
        this.termHost = host;
        this.accessHost = host;
        if (host instanceof IEnergySource) {
            IEnergySource hostEnergySource;
            this.energySource = hostEnergySource = (IEnergySource)host;
        } else if (host instanceof IActionHost) {
            IActionHost actionHost = (IActionHost)host;
            this.energySource = new ActionHostEnergySource(actionHost);
        } else {
            this.energySource = IEnergySource.empty();
        }
        this.storage = Objects.requireNonNull(host.getInventory(), "host inventory is null");
        this.clientCM = IConfigManager.builder(this::onSettingChanged).registerSetting(Settings.TERMINAL_SHOW_PATTERN_PROVIDERS, (Enum)ShowPatternProviders.VISIBLE).registerSetting(PEATSettings.ACCESS_SEARCH_MODE, (Enum)AccessSearchMode.BOTH).registerSetting(PEATSettings.AUTO_FILTER, (Enum)AutoFilter.DISABLED).build();
        if (this.isServerSide()) {
            this.serverCM = host.getConfigManager();
        }
        if (bindInventory) {
            this.createPlayerInventorySlots(ip);
        }
        this.encodingLogic = host.getLogic();
        this.encodedInputsInv = this.encodingLogic.getEncodedInputInv();
        this.encodedOutputsInv = this.encodingLogic.getEncodedOutputInv();
        ConfigMenuInventory encodedInputs = this.encodedInputsInv.createMenuWrapper();
        ConfigMenuInventory encodedOutputs = this.encodedOutputsInv.createMenuWrapper();
        for (i = 0; i < 9; ++i) {
            FakeSlot slot = new FakeSlot((InternalInventory)encodedInputs, i);
            slot.setHideAmount(true);
            this.craftingGridSlots[i] = slot;
            this.addSlot((Slot)this.craftingGridSlots[i], SlotSemantics.CRAFTING_GRID);
        }
        this.craftOutputSlot = new PatternTermSlot();
        this.addSlot((Slot)this.craftOutputSlot, SlotSemantics.CRAFTING_RESULT);
        for (i = 0; i < this.processingInputSlots.length; ++i) {
            this.processingInputSlots[i] = new FakeSlot((InternalInventory)encodedInputs, i);
            this.addSlot((Slot)this.processingInputSlots[i], SlotSemantics.PROCESSING_INPUTS);
        }
        for (i = 0; i < this.processingOutputSlots.length; ++i) {
            this.processingOutputSlots[i] = new FakeSlot((InternalInventory)encodedOutputs, i);
            this.addSlot((Slot)this.processingOutputSlots[i], SlotSemantics.PROCESSING_OUTPUTS);
        }
        this.processingOutputSlots[0].setIcon(Icon.BACKGROUND_PRIMARY_OUTPUT);
        this.stonecuttingInputSlot = new FakeSlot((InternalInventory)encodedInputs, 0);
        this.addSlot((Slot)this.stonecuttingInputSlot, SlotSemantics.STONECUTTING_INPUT);
        this.stonecuttingInputSlot.setHideAmount(true);
        this.smithingTableTemplateSlot = new FakeSlot((InternalInventory)encodedInputs, 0);
        this.addSlot((Slot)this.smithingTableTemplateSlot, SlotSemantics.SMITHING_TABLE_TEMPLATE);
        this.smithingTableTemplateSlot.setHideAmount(true);
        this.smithingTableBaseSlot = new FakeSlot((InternalInventory)encodedInputs, 1);
        this.addSlot((Slot)this.smithingTableBaseSlot, SlotSemantics.SMITHING_TABLE_BASE);
        this.smithingTableBaseSlot.setHideAmount(true);
        this.smithingTableAdditionSlot = new FakeSlot((InternalInventory)encodedInputs, 2);
        this.addSlot((Slot)this.smithingTableAdditionSlot, SlotSemantics.SMITHING_TABLE_ADDITION);
        this.smithingTableAdditionSlot.setHideAmount(true);
        this.blankPatternSlot = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.BLANK_PATTERN, this.encodingLogic.getBlankPatternInv(), 0);
        this.addSlot((Slot)this.blankPatternSlot, SlotSemantics.BLANK_PATTERN);
        this.encodedPatternSlot = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.ENCODED_PATTERN, this.encodingLogic.getEncodedPatternInv(), 0);
        this.addSlot((Slot)this.encodedPatternSlot, SlotSemantics.ENCODED_PATTERN);
        this.encodedPatternSlot.setStackLimit(1);
        this.registerClientAction(ACTION_ENCODE, this::encode);
        this.registerClientAction(ACTION_SET_STONECUTTING_RECIPE_ID, ResourceLocation.class, arg_0 -> ((PatternEncodingLogic)this.encodingLogic).setStonecuttingRecipeId(arg_0));
        this.registerClientAction(ACTION_CLEAR, this::clear);
        this.registerClientAction(ACTION_SET_MODE, EncodingMode.class, arg_0 -> ((PatternEncodingLogic)this.encodingLogic).setMode(arg_0));
        this.registerClientAction(ACTION_SET_SUBSTITUTION, Boolean.class, arg_0 -> ((PatternEncodingLogic)this.encodingLogic).setSubstitution(arg_0));
        this.registerClientAction(ACTION_SET_FLUID_SUBSTITUTION, Boolean.class, arg_0 -> ((PatternEncodingLogic)this.encodingLogic).setFluidSubstitution(arg_0));
        this.registerClientAction(ACTION_CYCLE_PROCESSING_OUTPUT, this::cycleProcessingOutput);
        this.updateStonecuttingRecipes();
    }

    @Nullable
    public IGridNode getGridNode() {
        ITerminalHost iTerminalHost = this.termHost;
        if (iTerminalHost instanceof IActionHost) {
            IActionHost actionHost = (IActionHost)iTerminalHost;
            return actionHost.getActionableNode();
        }
        return null;
    }

    public boolean isKeyVisible(AEKey key) {
        Item item;
        if (this.itemMenuHost != null && (item = this.itemMenuHost.getItem()) instanceof IBasicCellItem) {
            IBasicCellItem basicCellItem = (IBasicCellItem)item;
            return basicCellItem.getKeyType().contains(key);
        }
        return true;
    }

    public void broadcastChanges() {
        if (this.isServerSide()) {
            ITerminalHost set2;
            this.updateLinkStatus();
            this.updateActiveCraftingJobs();
            for (ITerminalHost set2 : this.serverCM.getSettings()) {
                Enum sideRemote;
                Enum sideLocal = this.serverCM.getSetting((Setting)set2);
                if (sideLocal == (sideRemote = this.clientCM.getSetting((Setting)set2))) continue;
                set2.copy(this.serverCM, this.clientCM);
                this.sendPacketToClient((ClientboundPacket)new ConfigValuePacket((Setting)set2, this.serverCM));
            }
            set2 = this.termHost;
            if (set2 instanceof KeyTypeSelectionHost) {
                KeyTypeSelectionHost keyTypeSelectionHost = (KeyTypeSelectionHost)set2;
                this.searchKeyTypes = new KeyTypeSelectionMenu.SyncedKeyTypes(keyTypeSelectionHost.getKeyTypeSelection().enabled());
            }
            Set<AEKey> craftables = this.getCraftablesFromGrid();
            KeyCounter availableStacks = this.storage.getAvailableStacks();
            KeyCounter requestables = new KeyCounter();
            try {
                Sets.difference(this.previousCraftables, craftables).forEach(arg_0 -> ((IncrementalUpdateHelper)this.updateHelper).addChange(arg_0));
                Sets.difference(craftables, this.previousCraftables).forEach(arg_0 -> ((IncrementalUpdateHelper)this.updateHelper).addChange(arg_0));
                this.previousAvailableStacks.removeAll(availableStacks);
                this.previousAvailableStacks.removeZeros();
                this.previousAvailableStacks.keySet().forEach(arg_0 -> ((IncrementalUpdateHelper)this.updateHelper).addChange(arg_0));
                if (this.updateHelper.hasChanges()) {
                    MEInventoryUpdatePacket.Builder builder = MEInventoryUpdatePacket.builder((int)this.containerId, (boolean)this.updateHelper.isFullUpdate(), (RegistryAccess)this.getPlayer().registryAccess());
                    builder.setFilter(this::isKeyVisible);
                    builder.addChanges(this.updateHelper, availableStacks, craftables, requestables);
                    builder.buildAndSend(x$0 -> this.sendPacketToClient((ClientboundPacket)x$0));
                    this.updateHelper.commitChanges();
                }
            }
            catch (Exception e) {
                AELog.warn((Throwable)e, (String)"Failed to send incremental inventory update to client");
            }
            this.previousCraftables = ImmutableSet.copyOf(craftables);
            this.previousAvailableStacks = availableStacks;
            if (this.mode != this.encodingLogic.getMode()) {
                this.setMode(this.encodingLogic.getMode());
            }
            this.substitute = this.encodingLogic.isSubstitution();
            this.substituteFluids = this.encodingLogic.isFluidSubstitution();
            this.stonecuttingRecipeId = this.encodingLogic.getStonecuttingRecipeId();
            this.showPatternProviders = (ShowPatternProviders)this.termHost.getConfigManager().getSetting(Settings.TERMINAL_SHOW_PATTERN_PROVIDERS);
            this.accessSearchMode = (AccessSearchMode)this.termHost.getConfigManager().getSetting(PEATSettings.ACCESS_SEARCH_MODE);
            this.autoFilter = (AutoFilter)this.termHost.getConfigManager().getSetting(PEATSettings.AUTO_FILTER);
            super.broadcastChanges();
            this.updateLinkStatus();
            if (this.showPatternProviders != ShowPatternProviders.NOT_FULL) {
                this.pinnedHosts.clear();
            }
            IGrid grid = this.getGrid();
            VisitorState state = new VisitorState();
            if (grid != null) {
                for (Class machineClass : grid.getMachineClasses()) {
                    if (!PatternContainer.class.isAssignableFrom(machineClass)) continue;
                    this.visitPatternProviderHosts(grid, machineClass, state);
                }
                this.pinnedHosts.removeIf(host -> host.getGrid() != grid);
            } else {
                this.pinnedHosts.clear();
            }
            if (state.total != this.diList.size() || state.forceFullUpdate) {
                this.sendFullUpdate(grid);
            } else {
                this.sendIncrementalUpdate();
            }
        }
    }

    public void onServerDataSync(ShortSet updatedFields) {
        super.onServerDataSync(updatedFields);
        if (updatedFields.contains((short)101) && this.getGui() != null) {
            this.getGui().run();
        }
        for (FakeSlot slot : this.craftingGridSlots) {
            slot.setActive(this.mode == EncodingMode.CRAFTING);
        }
        this.craftOutputSlot.setActive(this.mode == EncodingMode.CRAFTING);
        for (FakeSlot slot : this.processingInputSlots) {
            slot.setActive(this.mode == EncodingMode.PROCESSING);
        }
        for (FakeSlot slot : this.processingOutputSlots) {
            slot.setActive(this.mode == EncodingMode.PROCESSING);
        }
        if (this.currentMode != this.mode) {
            this.encodingLogic.setMode(this.mode);
            this.getAndUpdateOutput();
            this.updateStonecuttingRecipes();
        }
    }

    protected boolean showsCraftables() {
        return true;
    }

    private Set<AEKey> getCraftablesFromGrid() {
        ITerminalHost iTerminalHost;
        IGridNode hostNode = this.getGridNode();
        if (hostNode == null && (iTerminalHost = this.termHost) instanceof IActionHost) {
            IActionHost actionHost = (IActionHost)iTerminalHost;
            hostNode = actionHost.getActionableNode();
        }
        if (!this.showsCraftables()) {
            return Collections.emptySet();
        }
        if (hostNode != null && hostNode.isActive()) {
            return hostNode.getGrid().getCraftingService().getCraftables(this::isKeyVisible);
        }
        return Collections.emptySet();
    }

    private void updateActiveCraftingJobs() {
        IGridNode hostNode = this.getGridNode();
        IGrid grid = null;
        if (hostNode != null) {
            grid = hostNode.getGrid();
        }
        if (grid == null) {
            this.activeCraftingJobs = -1;
            return;
        }
        int activeJobs = 0;
        for (ICraftingCPU cpus : grid.getCraftingService().getCpus()) {
            if (!cpus.isBusy()) continue;
            ++activeJobs;
        }
        this.activeCraftingJobs = activeJobs;
    }

    public void onSettingChanged(IConfigManager manager, Setting<?> setting) {
        if (this.getGui() != null) {
            this.getGui().run();
        }
    }

    public IConfigManager getConfigManager() {
        if (this.isServerSide()) {
            return this.serverCM;
        }
        return this.clientCM;
    }

    public final void handleInteraction(long serial, InventoryAction action) {
        if (this.isClientSide()) {
            MEInteractionPacket message = new MEInteractionPacket(this.containerId, serial, action);
            PacketDistributor.sendToServer((CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public ILinkStatus getLinkStatus() {
        return this.linkStatus;
    }

    @Nullable
    private Runnable getGui() {
        return this.gui;
    }

    public void setGui(@Nullable Runnable gui) {
        this.gui = gui;
    }

    @Nullable
    public IClientRepo getClientRepo() {
        return this.clientRepo;
    }

    public void setClientRepo(@Nullable IClientRepo clientRepo) {
        this.clientRepo = clientRepo;
    }

    public void setTransferAction(Consumer<ResourceLocation> c) {
        this.setSearchAsRecipe = c;
    }

    public boolean hasIngredient(Ingredient ingredient, Object2IntOpenHashMap<Object> reservedAmounts) {
        IClientRepo clientRepo = this.getClientRepo();
        if (clientRepo != null && this.getLinkStatus().connected()) {
            for (GridInventoryEntry stack : clientRepo.getByIngredient(ingredient)) {
                int reservedAmount = reservedAmounts.getOrDefault((Object)stack, 0);
                if (stack.getStoredAmount() - (long)reservedAmount < 1L) continue;
                reservedAmounts.merge((Object)stack, 1, Integer::sum);
                return true;
            }
        }
        return false;
    }

    public ITerminalHost getHost() {
        return this.termHost;
    }

    protected void updateLinkStatus() {
        ILinkStatus linkStatus = this.termHost.getLinkStatus();
        if (!Objects.equals(this.linkStatus, linkStatus)) {
            this.linkStatus = linkStatus;
            this.sendPacketToClient((ClientboundPacket)new SetLinkStatusPacket(linkStatus));
        }
    }

    public void setLinkStatus(ILinkStatus linkStatus) {
        this.linkStatus = linkStatus;
    }

    public void setItem(int slotID, int stateId, @NotNull ItemStack stack) {
        super.setItem(slotID, stateId, stack);
        this.getAndUpdateOutput();
    }

    public void initializeContents(int stateId, List<ItemStack> items, ItemStack carried) {
        super.initializeContents(stateId, items, carried);
        this.getAndUpdateOutput();
    }

    private ItemStack getAndUpdateOutput() {
        Level level = this.getPlayerInventory().player.level();
        NonNullList items = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
        boolean invalidIngredients = false;
        for (int x = 0; x < items.size(); ++x) {
            ItemStack stack = this.getEncodedCraftingIngredient(x);
            if (stack != null) {
                items.set(x, (Object)stack);
                continue;
            }
            invalidIngredients = true;
        }
        CraftingInput input = CraftingInput.of((int)3, (int)3, (List)items);
        if (this.currentRecipe == null || !((CraftingRecipe)this.currentRecipe.value()).matches((RecipeInput)input, level)) {
            this.currentRecipe = invalidIngredients ? null : (RecipeHolder)level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)input, level).orElse(null);
            this.currentMode = this.mode;
            this.checkFluidSubstitutionSupport();
        }
        ItemStack is = this.currentRecipe == null ? ItemStack.EMPTY : ((CraftingRecipe)this.currentRecipe.value()).assemble((RecipeInput)input, (HolderLookup.Provider)level.registryAccess());
        this.craftOutputSlot.setResultItem(is);
        return is;
    }

    private void checkFluidSubstitutionSupport() {
        IPatternDetails decodedPattern;
        this.slotsSupportingFluidSubstitution.clear();
        if (this.currentRecipe == null) {
            return;
        }
        ItemStack encodedPattern = this.encodePattern();
        if (encodedPattern != null && (decodedPattern = PatternDetailsHelper.decodePattern((ItemStack)encodedPattern, (Level)this.getPlayerInventory().player.level())) instanceof AECraftingPattern) {
            AECraftingPattern craftingPattern = (AECraftingPattern)decodedPattern;
            for (int i = 0; i < craftingPattern.getSparseInputs().size(); ++i) {
                if (craftingPattern.getValidFluid(i) == null) continue;
                this.slotsSupportingFluidSubstitution.add(i);
            }
        }
    }

    public void encode() {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_ENCODE);
            return;
        }
        ItemStack encodedPattern = this.encodePattern();
        if (encodedPattern != null) {
            ItemStack encodeOutput = this.encodedPatternSlot.getItem();
            if (!(encodeOutput.isEmpty() || PatternDetailsHelper.isEncodedPattern((ItemStack)encodeOutput) || AEItems.BLANK_PATTERN.is(encodeOutput))) {
                return;
            }
            if (encodeOutput.isEmpty()) {
                ItemStack blankPattern = this.blankPatternSlot.getItem();
                if (!this.isPattern(blankPattern)) {
                    return;
                }
                blankPattern.shrink(1);
                if (blankPattern.getCount() <= 0) {
                    this.blankPatternSlot.set(ItemStack.EMPTY);
                }
            }
            this.encodedPatternSlot.set(encodedPattern);
        } else {
            this.clearPattern();
        }
    }

    private void clearPattern() {
        ItemStack encodedPattern = this.encodedPatternSlot.getItem();
        if (PatternDetailsHelper.isEncodedPattern((ItemStack)encodedPattern)) {
            this.encodedPatternSlot.set(AEItems.BLANK_PATTERN.stack(encodedPattern.getCount()));
        }
    }

    @Nullable
    private ItemStack encodePattern() {
        return switch (this.mode) {
            default -> throw new MatchException(null, null);
            case EncodingMode.CRAFTING -> this.encodeCraftingPattern();
            case EncodingMode.PROCESSING -> this.encodeProcessingPattern();
            case EncodingMode.SMITHING_TABLE -> this.encodeSmithingTablePattern();
            case EncodingMode.STONECUTTING -> this.encodeStonecuttingPattern();
        };
    }

    @Nullable
    private ItemStack encodeCraftingPattern() {
        ItemStack[] ingredients = new ItemStack[9];
        boolean valid = false;
        for (int x = 0; x < ingredients.length; ++x) {
            ingredients[x] = this.getEncodedCraftingIngredient(x);
            if (ingredients[x] == null) {
                return null;
            }
            if (ingredients[x].isEmpty()) continue;
            valid = true;
        }
        if (!valid) {
            return null;
        }
        ItemStack result = this.getAndUpdateOutput();
        if (result.isEmpty() || this.currentRecipe == null) {
            return null;
        }
        return PatternDetailsHelper.encodeCraftingPattern(this.currentRecipe, (ItemStack[])ingredients, (ItemStack)result, (boolean)this.isSubstitute(), (boolean)this.isSubstituteFluids());
    }

    @Nullable
    private ItemStack encodeProcessingPattern() {
        GenericStack[] inputs = new GenericStack[this.encodedInputsInv.size()];
        boolean valid = false;
        for (int slot = 0; slot < this.encodedInputsInv.size(); ++slot) {
            inputs[slot] = this.encodedInputsInv.getStack(slot);
            if (inputs[slot] == null) continue;
            valid = true;
        }
        if (!valid) {
            return null;
        }
        GenericStack[] outputs = new GenericStack[this.encodedOutputsInv.size()];
        for (int slot = 0; slot < this.encodedOutputsInv.size(); ++slot) {
            outputs[slot] = this.encodedOutputsInv.getStack(slot);
        }
        if (outputs[0] == null) {
            return null;
        }
        return PatternDetailsHelper.encodeProcessingPattern(Arrays.asList(inputs), Arrays.asList(outputs));
    }

    @Nullable
    private ItemStack encodeSmithingTablePattern() {
        AEItemKey base;
        AEItemKey template;
        AEKey aEKey;
        block5: {
            block4: {
                aEKey = this.encodedInputsInv.getKey(0);
                if (!(aEKey instanceof AEItemKey)) break block4;
                template = (AEItemKey)aEKey;
                aEKey = this.encodedInputsInv.getKey(1);
                if (!(aEKey instanceof AEItemKey)) break block4;
                base = (AEItemKey)aEKey;
                aEKey = this.encodedInputsInv.getKey(2);
                if (aEKey instanceof AEItemKey) break block5;
            }
            return null;
        }
        AEItemKey addition = (AEItemKey)aEKey;
        SmithingRecipeInput input = new SmithingRecipeInput(template.toStack(), base.toStack(), addition.toStack());
        Level level = this.getPlayer().level();
        RecipeHolder recipe = level.getRecipeManager().getRecipeFor(RecipeType.SMITHING, (RecipeInput)input, level).orElse(null);
        if (recipe == null) {
            return null;
        }
        AEItemKey output = AEItemKey.of((ItemStack)((SmithingRecipe)recipe.value()).assemble((RecipeInput)input, (HolderLookup.Provider)level.registryAccess()));
        return PatternDetailsHelper.encodeSmithingTablePattern((RecipeHolder)recipe, (AEItemKey)template, (AEItemKey)base, (AEItemKey)addition, (AEItemKey)output, (boolean)this.encodingLogic.isSubstitution());
    }

    @Nullable
    private ItemStack encodeStonecuttingPattern() {
        if (this.stonecuttingRecipeId == null) {
            return null;
        }
        AEKey aEKey = this.encodedInputsInv.getKey(0);
        if (!(aEKey instanceof AEItemKey)) {
            return null;
        }
        AEItemKey input = (AEItemKey)aEKey;
        SingleRecipeInput recipeInput = new SingleRecipeInput(input.toStack());
        Level level = this.getPlayer().level();
        RecipeHolder recipe = level.getRecipeManager().getRecipeFor(RecipeType.STONECUTTING, (RecipeInput)recipeInput, level, this.stonecuttingRecipeId).orElse(null);
        if (recipe == null) {
            return null;
        }
        AEItemKey output = AEItemKey.of((ItemStack)((StonecutterRecipe)recipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess()));
        return PatternDetailsHelper.encodeStonecuttingPattern((RecipeHolder)recipe, (AEItemKey)input, (AEItemKey)output, (boolean)this.encodingLogic.isSubstitution());
    }

    @Nullable
    private ItemStack getEncodedCraftingIngredient(int slot) {
        AEKey what = this.encodedInputsInv.getKey(slot);
        if (what == null) {
            return ItemStack.EMPTY;
        }
        if (what instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)what;
            return itemKey.toStack(1);
        }
        return null;
    }

    private boolean isPattern(ItemStack output) {
        if (output.isEmpty()) {
            return false;
        }
        return AEItems.BLANK_PATTERN.is(output);
    }

    public void onSlotChange(Slot s) {
        if (s == this.encodedPatternSlot && this.isServerSide()) {
            this.broadcastChanges();
        }
        if (s == this.stonecuttingInputSlot) {
            this.updateStonecuttingRecipes();
        }
    }

    private void updateStonecuttingRecipes() {
        this.stonecuttingRecipes.clear();
        AEKey aEKey = this.encodedInputsInv.getKey(0);
        if (aEKey instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)aEKey;
            Level level = this.getPlayer().level();
            RecipeManager recipeManager = level.getRecipeManager();
            SingleRecipeInput recipeInput = new SingleRecipeInput(itemKey.toStack());
            this.stonecuttingRecipes.addAll(recipeManager.getRecipesFor(RecipeType.STONECUTTING, (RecipeInput)recipeInput, level));
        }
        if (this.stonecuttingRecipeId != null && this.stonecuttingRecipes.stream().noneMatch(r -> r.id().equals((Object)this.stonecuttingRecipeId))) {
            this.stonecuttingRecipeId = null;
        }
    }

    public void clear() {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_CLEAR);
            return;
        }
        this.encodedInputsInv.clear();
        this.encodedOutputsInv.clear();
        this.broadcastChanges();
        this.getAndUpdateOutput();
    }

    public EncodingMode getMode() {
        return this.mode;
    }

    public void setMode(EncodingMode mode) {
        if (this.mode != mode && mode == EncodingMode.STONECUTTING) {
            this.updateStonecuttingRecipes();
        }
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_SET_MODE, mode);
        } else {
            this.mode = mode;
        }
    }

    public boolean isSubstitute() {
        return this.substitute;
    }

    public void setSubstitute(boolean substitute) {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_SET_SUBSTITUTION, substitute);
        } else {
            this.substitute = substitute;
        }
    }

    public boolean isSubstituteFluids() {
        return this.substituteFluids;
    }

    public void setSubstituteFluids(boolean substituteFluids) {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_SET_FLUID_SUBSTITUTION, substituteFluids);
        } else {
            this.substituteFluids = substituteFluids;
        }
    }

    @Nullable
    public ResourceLocation getStonecuttingRecipeId() {
        return this.stonecuttingRecipeId;
    }

    public void setStonecuttingRecipeId(ResourceLocation id) {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_SET_STONECUTTING_RECIPE_ID, id);
        } else {
            this.encodingLogic.setStonecuttingRecipeId(id);
        }
    }

    protected int transferStackToMenu(ItemStack input) {
        int initialCount = input.getCount();
        if (this.blankPatternSlot.mayPlace(input) && (input = this.blankPatternSlot.safeInsert(input)).isEmpty()) {
            return initialCount;
        }
        if (this.encodedPatternSlot.mayPlace(input) && (input = this.encodedPatternSlot.safeInsert(input)).isEmpty()) {
            return initialCount;
        }
        int transferred = initialCount - input.getCount();
        return transferred + super.transferStackToMenu(input);
    }

    @Contract(value="null -> false")
    public boolean canModifyAmountForSlot(@Nullable Slot slot) {
        return this.isProcessingPatternSlot(slot) && slot.hasItem();
    }

    @Contract(value="null -> false")
    public boolean isProcessingPatternSlot(@Nullable Slot slot) {
        if (slot == null || this.mode != EncodingMode.PROCESSING) {
            return false;
        }
        for (FakeSlot processingOutputSlot : this.processingOutputSlots) {
            if (processingOutputSlot != slot) continue;
            return true;
        }
        for (FakeSlot craftingSlot : this.processingInputSlots) {
            if (craftingSlot != slot) continue;
            return true;
        }
        return false;
    }

    @Contract(value="null -> false")
    public boolean isPatternOutputSlot(@Nullable Slot slot) {
        if (slot == null) {
            return false;
        }
        return this.encodedPatternSlot == slot;
    }

    public FakeSlot[] getCraftingGridSlots() {
        return this.craftingGridSlots;
    }

    public FakeSlot[] getProcessingInputSlots() {
        return this.processingInputSlots;
    }

    public FakeSlot[] getProcessingOutputSlots() {
        return this.processingOutputSlots;
    }

    public FakeSlot getSmithingTableTemplateSlot() {
        return this.smithingTableTemplateSlot;
    }

    public FakeSlot getSmithingTableBaseSlot() {
        return this.smithingTableBaseSlot;
    }

    public FakeSlot getSmithingTableAdditionSlot() {
        return this.smithingTableAdditionSlot;
    }

    public void cycleProcessingOutput() {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_CYCLE_PROCESSING_OUTPUT);
        } else {
            int i;
            if (this.mode != EncodingMode.PROCESSING) {
                return;
            }
            ItemStack[] newOutputs = new ItemStack[this.getProcessingOutputSlots().length];
            block0: for (i = 0; i < this.processingOutputSlots.length; ++i) {
                newOutputs[i] = ItemStack.EMPTY;
                if (this.processingOutputSlots[i].getItem().isEmpty()) continue;
                for (int j = 1; j < this.processingOutputSlots.length; ++j) {
                    ItemStack nextItem = this.processingOutputSlots[(i + j) % this.processingOutputSlots.length].getItem();
                    if (nextItem.isEmpty()) continue;
                    newOutputs[i] = nextItem;
                    continue block0;
                }
            }
            for (i = 0; i < newOutputs.length; ++i) {
                this.processingOutputSlots[i].set(newOutputs[i]);
            }
        }
    }

    public boolean canCycleProcessingOutputs() {
        return this.mode == EncodingMode.PROCESSING && Arrays.stream(this.processingOutputSlots).filter(s -> !s.getItem().isEmpty()).count() > 1L;
    }

    public List<RecipeHolder<StonecutterRecipe>> getStonecuttingRecipes() {
        return this.stonecuttingRecipes;
    }

    @Nullable
    private IGrid getGrid() {
        IGridNode agn = this.accessHost.getGridNode();
        if (agn != null && agn.isActive()) {
            return agn.getGrid();
        }
        return null;
    }

    private boolean isFull(PatternContainer logic) {
        for (int i = 0; i < logic.getTerminalPatternInventory().size(); ++i) {
            if (!logic.getTerminalPatternInventory().getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private boolean isVisible(PatternContainer container) {
        boolean isVisible = container.isVisibleInTerminal();
        return switch (this.getShownProviders()) {
            default -> throw new MatchException(null, null);
            case ShowPatternProviders.VISIBLE -> isVisible;
            case ShowPatternProviders.NOT_FULL -> {
                if (isVisible && (this.pinnedHosts.contains(container) || !this.isFull(container))) {
                    yield true;
                }
                yield false;
            }
            case ShowPatternProviders.ALL -> true;
        };
    }

    private <T extends PatternContainer> void visitPatternProviderHosts(IGrid grid, Class<T> machineClass, VisitorState state) {
        for (PatternContainer container : grid.getActiveMachines(machineClass)) {
            ContainerTracker t;
            if (!this.isVisible(container)) continue;
            if (this.getShownProviders() == ShowPatternProviders.NOT_FULL) {
                this.pinnedHosts.add(container);
            }
            if ((t = this.diList.get(container)) == null || !t.group.equals((Object)container.getTerminalGroup())) {
                state.forceFullUpdate = true;
            }
            ++state.total;
        }
    }

    public void doAction(ServerPlayer player, InventoryAction action, int slot, long id) {
        ContainerTracker inv = (ContainerTracker)this.byId.get(id);
        if (inv == null) {
            super.doAction(player, action, slot, id);
            return;
        }
        if (slot < 0 || slot >= inv.server.size()) {
            AELog.warn((String)"Client refers to invalid slot %d of inventory %s", (Object[])new Object[]{slot, inv.container});
            return;
        }
        ItemStack is = inv.server.getStackInSlot(slot);
        FilteredInternalInventory patternSlot = new FilteredInternalInventory(inv.server.getSlotInv(slot), (IAEItemFilter)new PatternSlotFilter());
        ItemStack carried = this.getCarried();
        switch (action) {
            case PICKUP_OR_SET_DOWN: {
                if (!carried.isEmpty()) {
                    ItemStack inSlot = patternSlot.getStackInSlot(0);
                    if (inSlot.isEmpty()) {
                        this.setCarried(patternSlot.addItems(carried));
                        break;
                    }
                    inSlot = inSlot.copy();
                    ItemStack inHand = carried.copy();
                    patternSlot.setItemDirect(0, ItemStack.EMPTY);
                    this.setCarried(ItemStack.EMPTY);
                    this.setCarried(patternSlot.addItems(inHand.copy()));
                    if (this.getCarried().isEmpty()) {
                        this.setCarried(inSlot);
                        break;
                    }
                    this.setCarried(inHand);
                    patternSlot.setItemDirect(0, inSlot);
                    break;
                }
                this.setCarried(patternSlot.getStackInSlot(0));
                patternSlot.setItemDirect(0, ItemStack.EMPTY);
                break;
            }
            case SPLIT_OR_PLACE_SINGLE: {
                if (!carried.isEmpty()) {
                    ItemStack extra = carried.split(1);
                    if (!extra.isEmpty()) {
                        extra = patternSlot.addItems(extra);
                    }
                    if (extra.isEmpty()) break;
                    carried.grow(extra.getCount());
                    break;
                }
                if (is.isEmpty()) break;
                this.setCarried(patternSlot.extractItem(0, (is.getCount() + 1) / 2, false));
                break;
            }
            case SHIFT_CLICK: {
                ItemStack stack = patternSlot.getStackInSlot(0).copy();
                if (!player.getInventory().add(stack)) {
                    patternSlot.setItemDirect(0, stack);
                    break;
                }
                patternSlot.setItemDirect(0, ItemStack.EMPTY);
                break;
            }
            case MOVE_REGION: {
                for (int x = 0; x < inv.server.size(); ++x) {
                    ItemStack stack = inv.server.getStackInSlot(x);
                    if (!player.getInventory().add(stack)) {
                        patternSlot.setItemDirect(0, stack);
                        continue;
                    }
                    patternSlot.setItemDirect(0, ItemStack.EMPTY);
                }
                break;
            }
            case CREATIVE_DUPLICATE: {
                if (!player.getAbilities().instabuild || !carried.isEmpty()) break;
                this.setCarried(is.isEmpty() ? ItemStack.EMPTY : is.copy());
            }
        }
    }

    public void quickMovePattern(ServerPlayer player, int slotIdx, List<Long> allowedPatternContainers) {
        if (slotIdx < 0 || slotIdx >= this.slots.size()) {
            return;
        }
        Slot sourceSlot = this.getSlot(slotIdx);
        if (!this.isPlayerSideSlot(sourceSlot) && !this.isPatternOutputSlot(sourceSlot)) {
            return;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        if (sourceStack.getCount() != 1) {
            return;
        }
        IPatternDetails pattern = PatternDetailsHelper.decodePattern((ItemStack)sourceStack, (Level)player.level());
        if (pattern == null) {
            return;
        }
        boolean molecularAssemblerPattern = pattern instanceof IMolecularAssemblerSupportedPattern;
        ArrayList<ContainerTracker> targets = new ArrayList<ContainerTracker>();
        for (Long id : allowedPatternContainers) {
            AEItemKey icon;
            boolean molecularAssembler;
            ContainerTracker inv = (ContainerTracker)this.byId.get(id.longValue());
            if (inv == null || !this.isVisible(inv.container) || molecularAssemblerPattern != (molecularAssembler = (icon = inv.group.icon()) != null && icon.is((ItemLike)AEBlocks.MOLECULAR_ASSEMBLER))) continue;
            targets.add(inv);
        }
        if (targets.stream().map(t -> t.group).distinct().count() != 1L) {
            return;
        }
        for (ContainerTracker target : targets) {
            FilteredInternalInventory targetContainer = new FilteredInternalInventory(target.server, (IAEItemFilter)new PatternSlotFilter());
            if (!targetContainer.addItems(sourceStack).isEmpty()) continue;
            sourceSlot.set(ItemStack.EMPTY);
            return;
        }
    }

    private void sendFullUpdate(@Nullable IGrid grid) {
        this.byId.clear();
        this.diList.clear();
        this.sendPacketToClient((ClientboundPacket)new ClearPatternAccessTerminalPacket());
        if (grid == null) {
            return;
        }
        for (Class machineClass : grid.getMachineClasses()) {
            Class<? extends PatternContainer> containerClass = PatternEncodingAccessTermMenu.tryCastMachineToContainer(machineClass);
            if (containerClass == null) continue;
            for (PatternContainer container : grid.getActiveMachines(containerClass)) {
                if (!this.isVisible(container)) continue;
                this.diList.put(container, new ContainerTracker(container, container.getTerminalPatternInventory(), container.getTerminalGroup()));
            }
        }
        for (ContainerTracker inv : this.diList.values()) {
            this.byId.put(inv.serverId, (Object)inv);
            this.sendPacketToClient((ClientboundPacket)inv.createFullPacket());
        }
    }

    private void sendIncrementalUpdate() {
        for (ContainerTracker inv : this.diList.values()) {
            PatternAccessTerminalPacket packet = inv.createUpdatePacket();
            if (packet == null) continue;
            this.sendPacketToClient((ClientboundPacket)packet);
        }
    }

    public void setSearch(@Nullable ResourceLocation recipeId) {
        this.setSearchAsRecipe.accept(recipeId);
    }

    private static Class<? extends PatternContainer> tryCastMachineToContainer(Class<?> machineClass) {
        if (PatternContainer.class.isAssignableFrom(machineClass)) {
            return machineClass.asSubclass(PatternContainer.class);
        }
        return null;
    }

    private static class VisitorState {
        int total;
        boolean forceFullUpdate;

        private VisitorState() {
        }
    }

    private static class ContainerTracker {
        private final PatternContainer container;
        private final long sortBy;
        private final long serverId = inventorySerial++;
        private final PatternContainerGroup group;
        private final InternalInventory client;
        private final InternalInventory server;

        public ContainerTracker(PatternContainer container, InternalInventory patterns, PatternContainerGroup group) {
            this.container = container;
            this.server = patterns;
            this.client = new AppEngInternalInventory(this.server.size());
            this.group = group;
            this.sortBy = container.getTerminalSortOrder();
        }

        public PatternAccessTerminalPacket createFullPacket() {
            Int2ObjectArrayMap slots = new Int2ObjectArrayMap(this.server.size());
            for (int i = 0; i < this.server.size(); ++i) {
                ItemStack stack = this.server.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                slots.put(i, (Object)stack);
            }
            return PatternAccessTerminalPacket.fullUpdate((long)this.serverId, (int)this.server.size(), (long)this.sortBy, (PatternContainerGroup)this.group, (Int2ObjectMap)slots);
        }

        @Nullable
        public PatternAccessTerminalPacket createUpdatePacket() {
            IntList changedSlots = this.detectChangedSlots();
            if (changedSlots == null) {
                return null;
            }
            Int2ObjectArrayMap slots = new Int2ObjectArrayMap(changedSlots.size());
            for (int i = 0; i < changedSlots.size(); ++i) {
                int slot;
                ItemStack stack = this.server.getStackInSlot(slot = changedSlots.getInt(i));
                this.client.setItemDirect(slot, stack.isEmpty() ? ItemStack.EMPTY : stack.copy());
                slots.put(slot, (Object)stack);
            }
            return PatternAccessTerminalPacket.incrementalUpdate((long)this.serverId, (Int2ObjectMap)slots);
        }

        @Nullable
        private IntList detectChangedSlots() {
            IntArrayList changedSlots = null;
            for (int x = 0; x < this.server.size(); ++x) {
                if (!ContainerTracker.isDifferent(this.server.getStackInSlot(x), this.client.getStackInSlot(x))) continue;
                if (changedSlots == null) {
                    changedSlots = new IntArrayList();
                }
                changedSlots.add(x);
            }
            return changedSlots;
        }

        private static boolean isDifferent(ItemStack a, ItemStack b) {
            if (a.isEmpty() && b.isEmpty()) {
                return false;
            }
            if (a.isEmpty() || b.isEmpty()) {
                return true;
            }
            return !ItemStack.matches((ItemStack)a, (ItemStack)b);
        }
    }

    private static class PatternSlotFilter
    implements IAEItemFilter {
        private PatternSlotFilter() {
        }

        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return true;
        }

        public boolean allowInsert(InternalInventory inv, int slot, ItemStack stack) {
            return !stack.isEmpty() && PatternDetailsHelper.isEncodedPattern((ItemStack)stack);
        }
    }
}

