/*
 * Decompiled with CFR 0.152.
 */
package yuuki1293.ae2peat.gui;

import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.AESubScreen;
import appeng.client.gui.NumberEntryType;
import appeng.client.gui.me.common.ClientDisplaySlot;
import appeng.client.gui.widgets.NumberEntryWidget;
import appeng.client.gui.widgets.TabButton;
import appeng.core.localization.GuiText;
import appeng.menu.SlotSemantics;
import com.google.common.primitives.Longs;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import yuuki1293.ae2peat.gui.PatternEncodingAccessTermScreen;
import yuuki1293.ae2peat.menu.PatternEncodingAccessTermMenu;

public class SetProcessingPatternAmountScreen<C extends PatternEncodingAccessTermMenu>
extends AESubScreen<C, PatternEncodingAccessTermScreen<C>> {
    private final NumberEntryWidget amount;
    private final GenericStack currentStack;
    private final Consumer<GenericStack> setter;

    public SetProcessingPatternAmountScreen(PatternEncodingAccessTermScreen<C> parentScreen, GenericStack currentStack, Consumer<GenericStack> setter) {
        super(parentScreen, "/screens/set_processing_pattern_amount.json");
        this.currentStack = currentStack;
        this.setter = setter;
        this.widgets.addButton("save", (Component)GuiText.Set.text(), this::confirm);
        ItemStack icon = ((PatternEncodingAccessTermMenu)this.m_6262_()).getHost().getMainMenuIcon();
        TabButton button = new TabButton(icon, icon.m_41786_(), btn -> this.returnToParent());
        this.widgets.add("back", (AbstractWidget)button);
        this.amount = this.widgets.addNumberEntryWidget("amountToStock", NumberEntryType.of((AEKey)currentStack.what()));
        this.amount.setLongValue(currentStack.amount());
        this.amount.setMaxValue(this.getMaxAmount());
        this.amount.setTextFieldStyle(this.style.getWidget("amountToStockInput"));
        this.amount.setMinValue(0L);
        this.amount.setHideValidationIcon(true);
        this.amount.setOnConfirm(this::confirm);
        this.addClientSideSlot((Slot)new ClientDisplaySlot(currentStack), SlotSemantics.MACHINE_OUTPUT);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.setSlotsHidden(SlotSemantics.TOOLBOX, true);
    }

    private void confirm() {
        this.amount.getLongValue().ifPresent(newAmount -> {
            if ((newAmount = Longs.constrainToRange((long)newAmount, (long)0L, (long)this.getMaxAmount())) <= 0L) {
                this.setter.accept(null);
            } else {
                this.setter.accept(new GenericStack(this.currentStack.what(), newAmount));
            }
            this.returnToParent();
        });
    }

    private long getMaxAmount() {
        return 999999L * (long)this.currentStack.what().getAmountPerUnit();
    }
}

