/*
 * Decompiled with CFR 0.152.
 */
package yuuki1293.ae2peat.integration.modules.emi;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.core.localization.ItemModText;
import appeng.integration.modules.emi.EmiStackHelper;
import appeng.menu.me.common.GridInventoryEntry;
import appeng.menu.me.common.IClientRepo;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.Recipe;
import org.jetbrains.annotations.Nullable;
import yuuki1293.ae2peat.integration.modules.emi.AbstractRecipeHandler;
import yuuki1293.ae2peat.integration.modules.jeirei.EncodingHelper;
import yuuki1293.ae2peat.menu.PatternEncodingAccessTermMenu;

public class EmiEncodePatternHandler<T extends PatternEncodingAccessTermMenu>
extends AbstractRecipeHandler<T> {
    public EmiEncodePatternHandler(Class<T> containerClass) {
        super(containerClass);
    }

    @Override
    public boolean canCraft(EmiRecipe recipe, EmiCraftContext<T> context) {
        if (context.getType() == EmiCraftContext.Type.FILL_BUTTON) {
            return this.transferRecipe(recipe, context, false).canCraft();
        }
        return false;
    }

    @Override
    protected AbstractRecipeHandler.Result transferRecipe(T menu, @Nullable Recipe<?> recipeBase, EmiRecipe emiRecipe, boolean doTransfer) {
        boolean craftingRecipe;
        Recipe<?> recipe = null;
        if (recipeBase instanceof Recipe) {
            recipe = recipeBase;
        }
        if ((craftingRecipe = this.isCraftingRecipe(recipe, emiRecipe)) && !this.fitsIn3x3Grid(recipe)) {
            return AbstractRecipeHandler.Result.createFailed((Component)ItemModText.RECIPE_TOO_LARGE.text());
        }
        if (doTransfer) {
            if (craftingRecipe) {
                EncodingHelper.encodeCraftingRecipe(menu, recipe, this.getGuiIngredientsForCrafting(emiRecipe), stack -> true);
            } else {
                EncodingHelper.encodeProcessingRecipe(menu, EmiStackHelper.ofInputs((EmiRecipe)emiRecipe), EmiStackHelper.ofOutputs((EmiRecipe)emiRecipe));
            }
        } else {
            IClientRepo repo = ((PatternEncodingAccessTermMenu)((Object)menu)).getClientRepo();
            Set<AEKey> craftableKeys = repo != null ? repo.getAllEntries().stream().filter(GridInventoryEntry::isCraftable).map(GridInventoryEntry::getWhat).collect(Collectors.toSet()) : Set.of();
            return new AbstractRecipeHandler.Result.EncodeWithCraftables(craftableKeys);
        }
        return AbstractRecipeHandler.Result.createSuccessful();
    }

    private List<List<GenericStack>> getGuiIngredientsForCrafting(EmiRecipe emiRecipe) {
        ArrayList<List<GenericStack>> result = new ArrayList<List<GenericStack>>(9);
        for (int i = 0; i < 9; ++i) {
            ArrayList<GenericStack> stacks = new ArrayList<GenericStack>();
            if (i < emiRecipe.getInputs().size()) {
                for (EmiStack emiStack : ((EmiIngredient)emiRecipe.getInputs().get(i)).getEmiStacks()) {
                    GenericStack genericStack = EmiStackHelper.toGenericStack((EmiStack)emiStack);
                    if (genericStack == null || !(genericStack.what() instanceof AEItemKey)) continue;
                    stacks.add(genericStack);
                }
            }
            result.add(stacks);
        }
        return result;
    }
}

