/*
 * Decompiled with CFR 0.152.
 */
package yuuki1293.ae2peat.menu;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.Setting;
import appeng.api.config.Settings;
import appeng.api.config.ShowPatternProviders;
import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.implementations.blockentities.IMEChest;
import appeng.api.implementations.blockentities.PatternContainerGroup;
import appeng.api.implementations.menuobjects.IPortableTerminal;
import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.MEStorage;
import appeng.api.storage.cells.IBasicCellItem;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.client.gui.Icon;
import appeng.core.AELog;
import appeng.core.definitions.AEItems;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ClearPatternAccessTerminalPacket;
import appeng.core.sync.packets.ConfigValuePacket;
import appeng.core.sync.packets.MEInteractionPacket;
import appeng.core.sync.packets.MEInventoryUpdatePacket;
import appeng.core.sync.packets.PatternAccessTerminalPacket;
import appeng.crafting.pattern.AECraftingPattern;
import appeng.helpers.IMenuCraftingPacket;
import appeng.helpers.IPatternTerminalMenuHost;
import appeng.helpers.InventoryAction;
import appeng.helpers.patternprovider.PatternContainer;
import appeng.me.helpers.ChannelPowerSrc;
import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.me.common.IClientRepo;
import appeng.menu.me.common.IMEInteractionHandler;
import appeng.menu.me.common.IncrementalUpdateHelper;
import appeng.menu.slot.FakeSlot;
import appeng.menu.slot.PatternTermSlot;
import appeng.menu.slot.RestrictedInputSlot;
import appeng.parts.encoding.EncodingMode;
import appeng.parts.encoding.PatternEncodingLogic;
import appeng.util.ConfigInventory;
import appeng.util.ConfigManager;
import appeng.util.ConfigMenuInventory;
import appeng.util.IConfigManagerListener;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.filter.IAEItemFilter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import yuuki1293.ae2peat.definisions.PEATMenus;
import yuuki1293.ae2peat.parts.PatternEncodingAccessTerminalPart;

public class PatternEncodingAccessTermMenu
extends AEBaseMenu
implements IMenuCraftingPacket,
IConfigManagerListener,
IConfigurableObject,
IMEInteractionHandler {
    private final IConfigManager clientCM;
    private final ITerminalHost host;
    @GuiSync(value=98)
    public boolean hasPower = false;
    private IConfigManagerListener gui;
    private IConfigManager serverCM;
    @Nullable
    protected final MEStorage storage;
    @Nullable
    protected final IEnergySource powerSource;
    private final IncrementalUpdateHelper updateHelper = new IncrementalUpdateHelper();
    @Nullable
    private IGridNode networkNode;
    @Nullable
    private IClientRepo clientRepo;
    private Set<AEKey> previousCraftables = Collections.emptySet();
    private KeyCounter previousAvailableStacks = new KeyCounter();
    @GuiSync(value=1)
    public ShowPatternProviders showPatternProviders = ShowPatternProviders.VISIBLE;
    private static long inventorySerial = Long.MIN_VALUE;
    private final Map<PatternContainer, ContainerTracker> diList = new IdentityHashMap<PatternContainer, ContainerTracker>();
    private final Long2ObjectOpenHashMap<ContainerTracker> byId = new Long2ObjectOpenHashMap();
    private final Set<PatternContainer> pinnedHosts = Collections.newSetFromMap(new IdentityHashMap());
    private static final int CRAFTING_GRID_WIDTH = 3;
    private static final int CRAFTING_GRID_HEIGHT = 3;
    private static final int CRAFTING_GRID_SLOTS = 9;
    private static final String ACTION_SET_MODE = "setMode";
    private static final String ACTION_ENCODE = "encode";
    private static final String ACTION_CLEAR = "clear";
    private static final String ACTION_SET_SUBSTITUTION = "setSubstitution";
    private static final String ACTION_SET_FLUID_SUBSTITUTION = "setFluidSubstitution";
    private static final String ACTION_SET_STONECUTTING_RECIPE_ID = "setStonecuttingRecipeId";
    private static final String ACTION_CYCLE_PROCESSING_OUTPUT = "cycleProcessingOutput";
    private final PatternEncodingLogic encodingLogic;
    private final FakeSlot[] craftingGridSlots = new FakeSlot[9];
    private final FakeSlot[] processingInputSlots = new FakeSlot[81];
    private final FakeSlot[] processingOutputSlots = new FakeSlot[27];
    private final FakeSlot stonecuttingInputSlot;
    private final FakeSlot smithingTableTemplateSlot;
    private final FakeSlot smithingTableBaseSlot;
    private final FakeSlot smithingTableAdditionSlot;
    private final PatternTermSlot craftOutputSlot;
    private final RestrictedInputSlot blankPatternSlot;
    private final RestrictedInputSlot encodedPatternSlot;
    private final ConfigInventory encodedInputsInv;
    private final ConfigInventory encodedOutputsInv;
    private CraftingRecipe currentRecipe;
    private EncodingMode currentMode;
    @GuiSync(value=97)
    public EncodingMode mode = EncodingMode.CRAFTING;
    @GuiSync(value=96)
    public boolean substitute = false;
    @GuiSync(value=95)
    public boolean substituteFluids = true;
    @GuiSync(value=94)
    @Nullable
    public ResourceLocation stonecuttingRecipeId;
    private final List<StonecutterRecipe> stonecuttingRecipes = new ArrayList<StonecutterRecipe>();
    public IntSet slotsSupportingFluidSubstitution = new IntArraySet();

    public ShowPatternProviders getShownProviders() {
        return this.showPatternProviders;
    }

    public PatternEncodingAccessTermMenu(int id, Inventory ip, PatternEncodingAccessTerminalPart anchor) {
        this(PEATMenus.PATTERN_ENCODING_ACCESS_TERMINAL.get(), id, ip, anchor, true);
    }

    public <T extends IConfigurableObject & IPatternTerminalMenuHost> PatternEncodingAccessTermMenu(MenuType<?> menuType, int id, Inventory ip, T host, boolean bindInventory) {
        super(menuType, id, ip, host);
        int i;
        this.host = (ITerminalHost)host;
        this.clientCM = new ConfigManager((IConfigManagerListener)this);
        this.clientCM.registerSetting(Settings.TERMINAL_SHOW_PATTERN_PROVIDERS, (Enum)ShowPatternProviders.VISIBLE);
        IEnergySource powerSource = null;
        if (this.isServerSide()) {
            this.serverCM = host.getConfigManager();
            this.storage = ((ITerminalHost)host).getInventory();
            if (this.storage != null) {
                IActionHost actionHost;
                IGridNode node;
                if (host instanceof IPortableTerminal || host instanceof IMEChest) {
                    powerSource = (IEnergySource)host;
                } else if (host instanceof IActionHost && (node = (actionHost = (IActionHost)host).getActionableNode()) != null) {
                    this.networkNode = node;
                    IGrid g = node.getGrid();
                    powerSource = new ChannelPowerSrc(this.networkNode, (IEnergySource)g.getEnergyService());
                }
            } else {
                this.setValidMenu(false);
            }
        } else {
            this.storage = null;
        }
        this.powerSource = powerSource;
        if (bindInventory) {
            this.createPlayerInventorySlots(ip);
        }
        this.encodingLogic = ((IPatternTerminalMenuHost)host).getLogic();
        this.encodedInputsInv = this.encodingLogic.getEncodedInputInv();
        this.encodedOutputsInv = this.encodingLogic.getEncodedOutputInv();
        ConfigMenuInventory encodedInputs = this.encodedInputsInv.createMenuWrapper();
        ConfigMenuInventory encodedOutputs = this.encodedOutputsInv.createMenuWrapper();
        for (i = 0; i < 9; ++i) {
            FakeSlot slot = new FakeSlot((InternalInventory)encodedInputs, i);
            slot.setHideAmount(true);
            this.craftingGridSlots[i] = slot;
            this.addSlot((Slot)this.craftingGridSlots[i], SlotSemantics.CRAFTING_GRID);
        }
        this.craftOutputSlot = new PatternTermSlot(ip.f_35978_, this.getActionSource(), this.powerSource, ((ITerminalHost)host).getInventory(), (InternalInventory)encodedInputs, (IMenuCraftingPacket)this);
        this.addSlot((Slot)this.craftOutputSlot, SlotSemantics.CRAFTING_RESULT);
        this.craftOutputSlot.setIcon(null);
        for (i = 0; i < this.processingInputSlots.length; ++i) {
            this.processingInputSlots[i] = new FakeSlot((InternalInventory)encodedInputs, i);
            this.addSlot((Slot)this.processingInputSlots[i], SlotSemantics.PROCESSING_INPUTS);
        }
        for (i = 0; i < this.processingOutputSlots.length; ++i) {
            this.processingOutputSlots[i] = new FakeSlot((InternalInventory)encodedOutputs, i);
            this.addSlot((Slot)this.processingOutputSlots[i], SlotSemantics.PROCESSING_OUTPUTS);
        }
        this.processingOutputSlots[0].setIcon(Icon.BACKGROUND_PRIMARY_OUTPUT);
        this.stonecuttingInputSlot = new FakeSlot((InternalInventory)encodedInputs, 0);
        this.addSlot((Slot)this.stonecuttingInputSlot, SlotSemantics.STONECUTTING_INPUT);
        this.stonecuttingInputSlot.setHideAmount(true);
        this.smithingTableTemplateSlot = new FakeSlot((InternalInventory)encodedInputs, 0);
        this.addSlot((Slot)this.smithingTableTemplateSlot, SlotSemantics.SMITHING_TABLE_TEMPLATE);
        this.smithingTableTemplateSlot.setHideAmount(true);
        this.smithingTableBaseSlot = new FakeSlot((InternalInventory)encodedInputs, 1);
        this.addSlot((Slot)this.smithingTableBaseSlot, SlotSemantics.SMITHING_TABLE_BASE);
        this.smithingTableBaseSlot.setHideAmount(true);
        this.smithingTableAdditionSlot = new FakeSlot((InternalInventory)encodedInputs, 2);
        this.addSlot((Slot)this.smithingTableAdditionSlot, SlotSemantics.SMITHING_TABLE_ADDITION);
        this.smithingTableAdditionSlot.setHideAmount(true);
        this.blankPatternSlot = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.BLANK_PATTERN, this.encodingLogic.getBlankPatternInv(), 0);
        this.addSlot((Slot)this.blankPatternSlot, SlotSemantics.BLANK_PATTERN);
        this.encodedPatternSlot = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.ENCODED_PATTERN, this.encodingLogic.getEncodedPatternInv(), 0);
        this.addSlot((Slot)this.encodedPatternSlot, SlotSemantics.ENCODED_PATTERN);
        this.encodedPatternSlot.setStackLimit(1);
        this.registerClientAction(ACTION_ENCODE, this::encode);
        this.registerClientAction(ACTION_SET_STONECUTTING_RECIPE_ID, ResourceLocation.class, arg_0 -> ((PatternEncodingLogic)this.encodingLogic).setStonecuttingRecipeId(arg_0));
        this.registerClientAction(ACTION_CLEAR, this::clear);
        this.registerClientAction(ACTION_SET_MODE, EncodingMode.class, arg_0 -> ((PatternEncodingLogic)this.encodingLogic).setMode(arg_0));
        this.registerClientAction(ACTION_SET_SUBSTITUTION, Boolean.class, arg_0 -> ((PatternEncodingLogic)this.encodingLogic).setSubstitution(arg_0));
        this.registerClientAction(ACTION_SET_FLUID_SUBSTITUTION, Boolean.class, arg_0 -> ((PatternEncodingLogic)this.encodingLogic).setFluidSubstitution(arg_0));
        this.registerClientAction(ACTION_CYCLE_PROCESSING_OUTPUT, this::cycleProcessingOutput);
        this.updateStonecuttingRecipes();
    }

    @Nullable
    public IGridNode getNetworkNode() {
        return this.networkNode;
    }

    public boolean isKeyVisible(AEKey key) {
        ItemMenuHost itemMenuHost;
        Item item;
        ITerminalHost iTerminalHost = this.host;
        if (iTerminalHost instanceof ItemMenuHost && (item = (itemMenuHost = (ItemMenuHost)iTerminalHost).getItemStack().m_41720_()) instanceof IBasicCellItem) {
            IBasicCellItem basicCellItem = (IBasicCellItem)item;
            return basicCellItem.getKeyType().contains(key);
        }
        return true;
    }

    public void m_38946_() {
        if (this.isClientSide()) {
            return;
        }
        if (this.storage != this.host.getInventory()) {
            this.setValidMenu(false);
            return;
        }
        for (Setting set : this.serverCM.getSettings()) {
            Enum sideRemote;
            Enum sideLocal = this.serverCM.getSetting(set);
            if (sideLocal == (sideRemote = this.clientCM.getSetting(set))) continue;
            set.copy(this.serverCM, this.clientCM);
            this.sendPacketToClient((BasePacket)new ConfigValuePacket(set, this.serverCM));
        }
        Set<AEKey> craftables = this.getCraftablesFromGrid();
        KeyCounter availableStacks = this.storage == null ? new KeyCounter() : this.storage.getAvailableStacks();
        KeyCounter requestables = new KeyCounter();
        try {
            Sets.difference(this.previousCraftables, craftables).forEach(arg_0 -> ((IncrementalUpdateHelper)this.updateHelper).addChange(arg_0));
            Sets.difference(craftables, this.previousCraftables).forEach(arg_0 -> ((IncrementalUpdateHelper)this.updateHelper).addChange(arg_0));
            this.previousAvailableStacks.removeAll(availableStacks);
            this.previousAvailableStacks.removeZeros();
            this.previousAvailableStacks.keySet().forEach(arg_0 -> ((IncrementalUpdateHelper)this.updateHelper).addChange(arg_0));
            if (this.updateHelper.hasChanges()) {
                MEInventoryUpdatePacket.Builder builder = MEInventoryUpdatePacket.builder((int)this.f_38840_, (boolean)this.updateHelper.isFullUpdate());
                builder.setFilter(this::isKeyVisible);
                builder.addChanges(this.updateHelper, availableStacks, craftables, requestables);
                builder.buildAndSend(x$0 -> this.sendPacketToClient((BasePacket)x$0));
                this.updateHelper.commitChanges();
            }
        }
        catch (Exception e) {
            AELog.warn((Throwable)e, (String)"Failed to send incremental inventory update to client");
        }
        this.previousCraftables = ImmutableSet.copyOf(craftables);
        this.previousAvailableStacks = availableStacks;
        this.updatePowerStatus();
        this.showPatternProviders = (ShowPatternProviders)this.getHost().getConfigManager().getSetting(Settings.TERMINAL_SHOW_PATTERN_PROVIDERS);
        if (this.showPatternProviders != ShowPatternProviders.NOT_FULL) {
            this.pinnedHosts.clear();
        }
        IGrid grid = this.getGrid();
        VisitorState state = new VisitorState();
        if (grid != null) {
            for (Class machineClass : grid.getMachineClasses()) {
                if (!PatternContainer.class.isAssignableFrom(machineClass)) continue;
                this.visitPatternProviderHosts(grid, machineClass, state);
            }
            this.pinnedHosts.removeIf(host -> host.getGrid() != grid);
        } else {
            this.pinnedHosts.clear();
        }
        if (state.total != this.diList.size() || state.forceFullUpdate) {
            this.sendFullUpdate(grid);
        } else {
            this.sendIncrementalUpdate();
        }
        if (this.mode != this.encodingLogic.getMode()) {
            this.setMode(this.encodingLogic.getMode());
        }
        this.substitute = this.encodingLogic.isSubstitution();
        this.substituteFluids = this.encodingLogic.isFluidSubstitution();
        this.stonecuttingRecipeId = this.encodingLogic.getStonecuttingRecipeId();
        super.m_38946_();
    }

    protected boolean showsCraftables() {
        return true;
    }

    private Set<AEKey> getCraftablesFromGrid() {
        ITerminalHost iTerminalHost;
        IGridNode hostNode = this.networkNode;
        if (hostNode == null && (iTerminalHost = this.host) instanceof IActionHost) {
            IActionHost actionHost = (IActionHost)iTerminalHost;
            hostNode = actionHost.getActionableNode();
        }
        if (!this.showsCraftables()) {
            return Collections.emptySet();
        }
        if (hostNode != null && hostNode.isActive()) {
            return hostNode.getGrid().getCraftingService().getCraftables(this::isKeyVisible);
        }
        return Collections.emptySet();
    }

    protected void updatePowerStatus() {
        if (this.networkNode != null) {
            this.hasPower = this.networkNode.isActive();
        } else {
            IEnergySource iEnergySource = this.powerSource;
            if (iEnergySource instanceof IEnergyService) {
                IEnergyService energyService = (IEnergyService)iEnergySource;
                this.hasPower = energyService.isNetworkPowered();
            } else {
                this.hasPower = this.powerSource != null ? this.powerSource.extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 0.8 : false;
            }
        }
    }

    public void onSettingChanged(IConfigManager manager, Setting<?> setting) {
        if (this.getGui() != null) {
            this.getGui().onSettingChanged(manager, setting);
        }
    }

    public IConfigManager getConfigManager() {
        if (this.isServerSide()) {
            return this.serverCM;
        }
        return this.clientCM;
    }

    private IConfigManagerListener getGui() {
        return this.gui;
    }

    public void setGui(IConfigManagerListener gui) {
        this.gui = gui;
    }

    @Nullable
    public IClientRepo getClientRepo() {
        return this.clientRepo;
    }

    public void setClientRepo(@Nullable IClientRepo clientRepo) {
        this.clientRepo = clientRepo;
    }

    public ITerminalHost getHost() {
        return this.host;
    }

    @Nullable
    private IGrid getGrid() {
        IGridNode agn;
        IActionHost host = this.getActionHost();
        if (host != null && (agn = host.getActionableNode()) != null && agn.isActive()) {
            return agn.getGrid();
        }
        return null;
    }

    public void handleInteraction(long serial, InventoryAction action) {
        if (this.isClientSide()) {
            NetworkHandler.instance().sendToServer((BasePacket)new MEInteractionPacket(this.f_38840_, serial, action));
        }
    }

    private boolean isFull(PatternContainer logic) {
        for (int i = 0; i < logic.getTerminalPatternInventory().size(); ++i) {
            if (!logic.getTerminalPatternInventory().getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    private boolean isVisible(PatternContainer container) {
        boolean isVisible = container.isVisibleInTerminal();
        return switch (this.getShownProviders()) {
            default -> throw new IncompatibleClassChangeError();
            case ShowPatternProviders.VISIBLE -> isVisible;
            case ShowPatternProviders.NOT_FULL -> {
                if (isVisible && (this.pinnedHosts.contains(container) || !this.isFull(container))) {
                    yield true;
                }
                yield false;
            }
            case ShowPatternProviders.ALL -> true;
        };
    }

    private <T extends PatternContainer> void visitPatternProviderHosts(IGrid grid, Class<T> machineClass, VisitorState state) {
        for (PatternContainer container : grid.getActiveMachines(machineClass)) {
            ContainerTracker t;
            if (!this.isVisible(container)) continue;
            if (this.getShownProviders() == ShowPatternProviders.NOT_FULL) {
                this.pinnedHosts.add(container);
            }
            if ((t = this.diList.get(container)) == null || !t.group.equals((Object)container.getTerminalGroup())) {
                state.forceFullUpdate = true;
            }
            ++state.total;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doAction(ServerPlayer player, InventoryAction action, int slot, long id) {
        ContainerTracker inv = (ContainerTracker)this.byId.get(id);
        if (inv != null) {
            if (slot < 0 || slot >= inv.server.size()) {
                AELog.warn((String)"Client refers to invalid slot %d of inventory %s", (Object[])new Object[]{slot, inv.container});
                return;
            }
            ItemStack is = inv.server.getStackInSlot(slot);
            FilteredInternalInventory patternSlot = new FilteredInternalInventory(inv.server.getSlotInv(slot), (IAEItemFilter)new PatternSlotFilter());
            ItemStack carried = this.m_142621_();
            switch (action) {
                case PICKUP_OR_SET_DOWN: {
                    if (!carried.m_41619_()) {
                        ItemStack inSlot = patternSlot.getStackInSlot(0);
                        if (inSlot.m_41619_()) {
                            this.m_142503_(patternSlot.addItems(carried));
                            return;
                        }
                        inSlot = inSlot.m_41777_();
                        ItemStack inHand = carried.m_41777_();
                        patternSlot.setItemDirect(0, ItemStack.f_41583_);
                        this.m_142503_(ItemStack.f_41583_);
                        this.m_142503_(patternSlot.addItems(inHand.m_41777_()));
                        if (this.m_142621_().m_41619_()) {
                            this.m_142503_(inSlot);
                            return;
                        }
                        this.m_142503_(inHand);
                        patternSlot.setItemDirect(0, inSlot);
                        return;
                    }
                    this.m_142503_(patternSlot.getStackInSlot(0));
                    patternSlot.setItemDirect(0, ItemStack.f_41583_);
                    return;
                }
                case SPLIT_OR_PLACE_SINGLE: {
                    if (!carried.m_41619_()) {
                        ItemStack extra = carried.m_41620_(1);
                        if (!extra.m_41619_()) {
                            extra = patternSlot.addItems(extra);
                        }
                        if (extra.m_41619_()) return;
                        carried.m_41769_(extra.m_41613_());
                        return;
                    }
                    if (is.m_41619_()) return;
                    this.m_142503_(patternSlot.extractItem(0, (is.m_41613_() + 1) / 2, false));
                    return;
                }
                case SHIFT_CLICK: {
                    ItemStack stack = patternSlot.getStackInSlot(0).m_41777_();
                    if (!player.m_150109_().m_36054_(stack)) {
                        patternSlot.setItemDirect(0, stack);
                        return;
                    }
                    patternSlot.setItemDirect(0, ItemStack.f_41583_);
                    return;
                }
                case MOVE_REGION: {
                    for (int x = 0; x < inv.server.size(); ++x) {
                        ItemStack stack = inv.server.getStackInSlot(x);
                        if (!player.m_150109_().m_36054_(stack)) {
                            patternSlot.setItemDirect(0, stack);
                            continue;
                        }
                        patternSlot.setItemDirect(0, ItemStack.f_41583_);
                    }
                    return;
                }
                case CREATIVE_DUPLICATE: {
                    if (!player.m_150110_().f_35937_ || !carried.m_41619_()) return;
                    this.m_142503_(is.m_41619_() ? ItemStack.f_41583_ : is.m_41777_());
                }
            }
            return;
        }
        super.doAction(player, action, slot, id);
    }

    private void sendFullUpdate(@Nullable IGrid grid) {
        this.byId.clear();
        this.diList.clear();
        this.sendPacketToClient((BasePacket)new ClearPatternAccessTerminalPacket());
        if (grid == null) {
            return;
        }
        for (Class machineClass : grid.getMachineClasses()) {
            Class<? extends PatternContainer> containerClass = PatternEncodingAccessTermMenu.tryCastMachineToContainer(machineClass);
            if (containerClass == null) continue;
            for (PatternContainer container : grid.getActiveMachines(containerClass)) {
                if (!this.isVisible(container)) continue;
                this.diList.put(container, new ContainerTracker(container, container.getTerminalPatternInventory(), container.getTerminalGroup()));
            }
        }
        for (ContainerTracker inv : this.diList.values()) {
            this.byId.put(inv.serverId, (Object)inv);
            this.sendPacketToClient((BasePacket)inv.createFullPacket());
        }
    }

    private void sendIncrementalUpdate() {
        for (ContainerTracker inv : this.diList.values()) {
            PatternAccessTerminalPacket packet = inv.createUpdatePacket();
            if (packet == null) continue;
            this.sendPacketToClient((BasePacket)packet);
        }
    }

    private static Class<? extends PatternContainer> tryCastMachineToContainer(Class<?> machineClass) {
        if (PatternContainer.class.isAssignableFrom(machineClass)) {
            return machineClass.asSubclass(PatternContainer.class);
        }
        return null;
    }

    public void m_182406_(int slotID, int stateId, ItemStack stack) {
        super.m_182406_(slotID, stateId, stack);
        this.getAndUpdateOutput();
    }

    private ItemStack getAndUpdateOutput() {
        Level level = this.getPlayerInventory().f_35978_.m_9236_();
        TransientCraftingContainer ic = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3);
        boolean invalidIngredients = false;
        for (int x = 0; x < ic.m_6643_(); ++x) {
            ItemStack stack = this.getEncodedCraftingIngredient(x);
            if (stack != null) {
                ic.m_6836_(x, stack);
                continue;
            }
            invalidIngredients = true;
        }
        if (this.currentRecipe == null || !this.currentRecipe.m_5818_((Container)ic, level)) {
            this.currentRecipe = invalidIngredients ? null : (CraftingRecipe)level.m_7465_().m_44015_(RecipeType.f_44107_, (Container)ic, level).orElse(null);
            this.currentMode = this.mode;
            this.checkFluidSubstitutionSupport();
        }
        ItemStack is = this.currentRecipe == null ? ItemStack.f_41583_ : this.currentRecipe.m_5874_((Container)ic, level.m_9598_());
        this.craftOutputSlot.setDisplayedCraftingOutput(is);
        return is;
    }

    private void checkFluidSubstitutionSupport() {
        IPatternDetails decodedPattern;
        this.slotsSupportingFluidSubstitution.clear();
        if (this.currentRecipe == null) {
            return;
        }
        ItemStack encodedPattern = this.encodePattern();
        if (encodedPattern != null && (decodedPattern = PatternDetailsHelper.decodePattern((ItemStack)encodedPattern, (Level)this.getPlayerInventory().f_35978_.m_9236_())) instanceof AECraftingPattern) {
            AECraftingPattern craftingPattern = (AECraftingPattern)decodedPattern;
            for (int i = 0; i < craftingPattern.getSparseInputs().length; ++i) {
                if (craftingPattern.getValidFluid(i) == null) continue;
                this.slotsSupportingFluidSubstitution.add(i);
            }
        }
    }

    public void encode() {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_ENCODE);
            return;
        }
        ItemStack encodedPattern = this.encodePattern();
        if (encodedPattern != null) {
            ItemStack encodeOutput = this.encodedPatternSlot.m_7993_();
            if (!(encodeOutput.m_41619_() || PatternDetailsHelper.isEncodedPattern((ItemStack)encodeOutput) || AEItems.BLANK_PATTERN.isSameAs(encodeOutput))) {
                return;
            }
            if (encodeOutput.m_41619_()) {
                ItemStack blankPattern = this.blankPatternSlot.m_7993_();
                if (!this.isPattern(blankPattern)) {
                    return;
                }
                blankPattern.m_41774_(1);
                if (blankPattern.m_41613_() <= 0) {
                    this.blankPatternSlot.m_5852_(ItemStack.f_41583_);
                }
            }
            this.encodedPatternSlot.m_5852_(encodedPattern);
        } else {
            this.clearPattern();
        }
    }

    private void clearPattern() {
        ItemStack encodedPattern = this.encodedPatternSlot.m_7993_();
        if (PatternDetailsHelper.isEncodedPattern((ItemStack)encodedPattern)) {
            this.encodedPatternSlot.m_5852_(AEItems.BLANK_PATTERN.stack(encodedPattern.m_41613_()));
        }
    }

    @Nullable
    private ItemStack encodePattern() {
        return switch (this.mode) {
            default -> throw new IncompatibleClassChangeError();
            case EncodingMode.CRAFTING -> this.encodeCraftingPattern();
            case EncodingMode.PROCESSING -> this.encodeProcessingPattern();
            case EncodingMode.SMITHING_TABLE -> this.encodeSmithingTablePattern();
            case EncodingMode.STONECUTTING -> this.encodeStonecuttingPattern();
        };
    }

    @Nullable
    private ItemStack encodeCraftingPattern() {
        ItemStack[] ingredients = new ItemStack[9];
        boolean valid = false;
        for (int x = 0; x < ingredients.length; ++x) {
            ingredients[x] = this.getEncodedCraftingIngredient(x);
            if (ingredients[x] == null) {
                return null;
            }
            if (ingredients[x].m_41619_()) continue;
            valid = true;
        }
        if (!valid) {
            return null;
        }
        ItemStack result = this.getAndUpdateOutput();
        if (result.m_41619_() || this.currentRecipe == null) {
            return null;
        }
        return PatternDetailsHelper.encodeCraftingPattern((CraftingRecipe)this.currentRecipe, (ItemStack[])ingredients, (ItemStack)result, (boolean)this.isSubstitute(), (boolean)this.isSubstituteFluids());
    }

    @Nullable
    private ItemStack encodeProcessingPattern() {
        GenericStack[] inputs = new GenericStack[this.encodedInputsInv.size()];
        boolean valid = false;
        for (int slot = 0; slot < this.encodedInputsInv.size(); ++slot) {
            inputs[slot] = this.encodedInputsInv.getStack(slot);
            if (inputs[slot] == null) continue;
            valid = true;
        }
        if (!valid) {
            return null;
        }
        GenericStack[] outputs = new GenericStack[this.encodedOutputsInv.size()];
        for (int slot = 0; slot < this.encodedOutputsInv.size(); ++slot) {
            outputs[slot] = this.encodedOutputsInv.getStack(slot);
        }
        if (outputs[0] == null) {
            return null;
        }
        return PatternDetailsHelper.encodeProcessingPattern((GenericStack[])inputs, (GenericStack[])outputs);
    }

    @Nullable
    private ItemStack encodeSmithingTablePattern() {
        AEItemKey base;
        AEItemKey template;
        AEKey aEKey;
        block5: {
            block4: {
                aEKey = this.encodedInputsInv.getKey(0);
                if (!(aEKey instanceof AEItemKey)) break block4;
                template = (AEItemKey)aEKey;
                aEKey = this.encodedInputsInv.getKey(1);
                if (!(aEKey instanceof AEItemKey)) break block4;
                base = (AEItemKey)aEKey;
                aEKey = this.encodedInputsInv.getKey(2);
                if (aEKey instanceof AEItemKey) break block5;
            }
            return null;
        }
        AEItemKey addition = (AEItemKey)aEKey;
        SimpleContainer container = new SimpleContainer(3);
        container.m_6836_(0, template.toStack());
        container.m_6836_(1, base.toStack());
        container.m_6836_(2, addition.toStack());
        Level level = this.getPlayer().m_9236_();
        SmithingRecipe recipe = level.m_7465_().m_44015_(RecipeType.f_44113_, (Container)container, level).orElse(null);
        if (recipe == null) {
            return null;
        }
        AEItemKey output = AEItemKey.of((ItemStack)recipe.m_5874_((Container)container, level.m_9598_()));
        return PatternDetailsHelper.encodeSmithingTablePattern((SmithingRecipe)recipe, (AEItemKey)template, (AEItemKey)base, (AEItemKey)addition, (AEItemKey)output, (boolean)this.encodingLogic.isSubstitution());
    }

    @Nullable
    private ItemStack encodeStonecuttingPattern() {
        if (this.stonecuttingRecipeId == null) {
            return null;
        }
        AEKey aEKey = this.encodedInputsInv.getKey(0);
        if (!(aEKey instanceof AEItemKey)) {
            return null;
        }
        AEItemKey input = (AEItemKey)aEKey;
        SimpleContainer container = new SimpleContainer(1);
        container.m_6836_(0, input.toStack());
        Level level = this.getPlayer().m_9236_();
        StonecutterRecipe recipe = level.m_7465_().m_220248_(RecipeType.f_44112_, (Container)container, level, this.stonecuttingRecipeId).map(Pair::getSecond).orElse(null);
        if (recipe == null) {
            return null;
        }
        AEItemKey output = AEItemKey.of((ItemStack)recipe.m_8043_(level.m_9598_()));
        return PatternDetailsHelper.encodeStonecuttingPattern((StonecutterRecipe)recipe, (AEItemKey)input, (AEItemKey)output, (boolean)this.encodingLogic.isSubstitution());
    }

    @Nullable
    private ItemStack getEncodedCraftingIngredient(int slot) {
        AEKey what = this.encodedInputsInv.getKey(slot);
        if (what == null) {
            return ItemStack.f_41583_;
        }
        if (what instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)what;
            return itemKey.toStack(1);
        }
        return null;
    }

    private boolean isPattern(ItemStack output) {
        if (output.m_41619_()) {
            return false;
        }
        return AEItems.BLANK_PATTERN.isSameAs(output);
    }

    public void onServerDataSync() {
        super.onServerDataSync();
        for (FakeSlot slot : this.craftingGridSlots) {
            slot.setActive(this.mode == EncodingMode.CRAFTING);
        }
        this.craftOutputSlot.setActive(this.mode == EncodingMode.CRAFTING);
        for (FakeSlot slot : this.processingInputSlots) {
            slot.setActive(this.mode == EncodingMode.PROCESSING);
        }
        for (FakeSlot slot : this.processingOutputSlots) {
            slot.setActive(this.mode == EncodingMode.PROCESSING);
        }
        if (this.currentMode != this.mode) {
            this.encodingLogic.setMode(this.mode);
            this.getAndUpdateOutput();
            this.updateStonecuttingRecipes();
        }
    }

    public void onSlotChange(Slot s) {
        if (s == this.encodedPatternSlot && this.isServerSide()) {
            this.m_38946_();
        }
        if (s == this.craftOutputSlot && this.isClientSide()) {
            this.getAndUpdateOutput();
        }
        if (s == this.stonecuttingInputSlot) {
            this.updateStonecuttingRecipes();
        }
    }

    private void updateStonecuttingRecipes() {
        this.stonecuttingRecipes.clear();
        AEKey aEKey = this.encodedInputsInv.getKey(0);
        if (aEKey instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)aEKey;
            Level level = this.getPlayer().m_9236_();
            RecipeManager recipeManager = level.m_7465_();
            SimpleContainer inventory = new SimpleContainer(1);
            inventory.m_6836_(0, itemKey.toStack());
            this.stonecuttingRecipes.addAll(recipeManager.m_44056_(RecipeType.f_44112_, (Container)inventory, level));
        }
        if (this.stonecuttingRecipeId != null && this.stonecuttingRecipes.stream().noneMatch(r -> r.m_6423_().equals((Object)this.stonecuttingRecipeId))) {
            this.stonecuttingRecipeId = null;
        }
    }

    public void clear() {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_CLEAR);
            return;
        }
        this.encodedInputsInv.clear();
        this.encodedOutputsInv.clear();
        this.m_38946_();
        this.getAndUpdateOutput();
    }

    public InternalInventory getCraftingMatrix() {
        return this.encodedInputsInv.createMenuWrapper().getSubInventory(0, 9);
    }

    public boolean useRealItems() {
        return false;
    }

    public List<ItemStack> getViewCells() {
        return List.of();
    }

    public EncodingMode getMode() {
        return this.mode;
    }

    public void setMode(EncodingMode mode) {
        if (this.mode != mode && mode == EncodingMode.STONECUTTING) {
            this.updateStonecuttingRecipes();
        }
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_SET_MODE, mode);
        } else {
            this.mode = mode;
        }
    }

    public boolean isSubstitute() {
        return this.substitute;
    }

    public void setSubstitute(boolean substitute) {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_SET_SUBSTITUTION, substitute);
        } else {
            this.substitute = substitute;
        }
    }

    public boolean isSubstituteFluids() {
        return this.substituteFluids;
    }

    public void setSubstituteFluids(boolean substituteFluids) {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_SET_FLUID_SUBSTITUTION, substituteFluids);
        } else {
            this.substituteFluids = substituteFluids;
        }
    }

    @Nullable
    public ResourceLocation getStonecuttingRecipeId() {
        return this.stonecuttingRecipeId;
    }

    public void setStonecuttingRecipeId(ResourceLocation id) {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_SET_STONECUTTING_RECIPE_ID, id);
        } else {
            this.encodingLogic.setStonecuttingRecipeId(id);
        }
    }

    protected ItemStack transferStackToMenu(ItemStack input) {
        if (this.blankPatternSlot.m_5857_(input) && (input = this.blankPatternSlot.m_150659_(input)).m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (this.encodedPatternSlot.m_5857_(input) && (input = this.encodedPatternSlot.m_150659_(input)).m_41619_()) {
            return ItemStack.f_41583_;
        }
        return super.transferStackToMenu(input);
    }

    @Contract(value="null -> false")
    public boolean canModifyAmountForSlot(@Nullable Slot slot) {
        return this.isProcessingPatternSlot(slot) && slot.m_6657_();
    }

    @Contract(value="null -> false")
    public boolean isProcessingPatternSlot(@Nullable Slot slot) {
        if (slot == null || this.mode != EncodingMode.PROCESSING) {
            return false;
        }
        for (FakeSlot processingOutputSlot : this.processingOutputSlots) {
            if (processingOutputSlot != slot) continue;
            return true;
        }
        for (FakeSlot craftingSlot : this.processingInputSlots) {
            if (craftingSlot != slot) continue;
            return true;
        }
        return false;
    }

    public FakeSlot[] getCraftingGridSlots() {
        return this.craftingGridSlots;
    }

    public FakeSlot[] getProcessingInputSlots() {
        return this.processingInputSlots;
    }

    public FakeSlot[] getProcessingOutputSlots() {
        return this.processingOutputSlots;
    }

    public FakeSlot getSmithingTableTemplateSlot() {
        return this.smithingTableTemplateSlot;
    }

    public FakeSlot getSmithingTableBaseSlot() {
        return this.smithingTableBaseSlot;
    }

    public FakeSlot getSmithingTableAdditionSlot() {
        return this.smithingTableAdditionSlot;
    }

    public void cycleProcessingOutput() {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_CYCLE_PROCESSING_OUTPUT);
        } else {
            int i;
            if (this.mode != EncodingMode.PROCESSING) {
                return;
            }
            ItemStack[] newOutputs = new ItemStack[this.getProcessingOutputSlots().length];
            block0: for (i = 0; i < this.processingOutputSlots.length; ++i) {
                newOutputs[i] = ItemStack.f_41583_;
                if (this.processingOutputSlots[i].m_7993_().m_41619_()) continue;
                for (int j = 1; j < this.processingOutputSlots.length; ++j) {
                    ItemStack nextItem = this.processingOutputSlots[(i + j) % this.processingOutputSlots.length].m_7993_();
                    if (nextItem.m_41619_()) continue;
                    newOutputs[i] = nextItem;
                    continue block0;
                }
            }
            for (i = 0; i < newOutputs.length; ++i) {
                this.processingOutputSlots[i].m_5852_(newOutputs[i]);
            }
        }
    }

    public boolean canCycleProcessingOutputs() {
        return this.mode == EncodingMode.PROCESSING && Arrays.stream(this.processingOutputSlots).filter(s -> !s.m_7993_().m_41619_()).count() > 1L;
    }

    public List<StonecutterRecipe> getStonecuttingRecipes() {
        return this.stonecuttingRecipes;
    }

    private static class VisitorState {
        int total;
        boolean forceFullUpdate;

        private VisitorState() {
        }
    }

    private static class ContainerTracker {
        private final PatternContainer container;
        private final long sortBy;
        private final long serverId = inventorySerial++;
        private final PatternContainerGroup group;
        private final InternalInventory client;
        private final InternalInventory server;

        public ContainerTracker(PatternContainer container, InternalInventory patterns, PatternContainerGroup group) {
            this.container = container;
            this.server = patterns;
            this.client = new AppEngInternalInventory(this.server.size());
            this.group = group;
            this.sortBy = container.getTerminalSortOrder();
        }

        public PatternAccessTerminalPacket createFullPacket() {
            Int2ObjectArrayMap slots = new Int2ObjectArrayMap(this.server.size());
            for (int i = 0; i < this.server.size(); ++i) {
                ItemStack stack = this.server.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                slots.put(i, (Object)stack);
            }
            return PatternAccessTerminalPacket.fullUpdate((long)this.serverId, (int)this.server.size(), (long)this.sortBy, (PatternContainerGroup)this.group, (Int2ObjectMap)slots);
        }

        @Nullable
        public PatternAccessTerminalPacket createUpdatePacket() {
            IntList changedSlots = this.detectChangedSlots();
            if (changedSlots == null) {
                return null;
            }
            Int2ObjectArrayMap slots = new Int2ObjectArrayMap(changedSlots.size());
            for (int i = 0; i < changedSlots.size(); ++i) {
                int slot;
                ItemStack stack = this.server.getStackInSlot(slot = changedSlots.getInt(i));
                this.client.setItemDirect(slot, stack.m_41619_() ? ItemStack.f_41583_ : stack.m_41777_());
                slots.put(slot, (Object)stack);
            }
            return PatternAccessTerminalPacket.incrementalUpdate((long)this.serverId, (Int2ObjectMap)slots);
        }

        @Nullable
        private IntList detectChangedSlots() {
            IntArrayList changedSlots = null;
            for (int x = 0; x < this.server.size(); ++x) {
                if (!ContainerTracker.isDifferent(this.server.getStackInSlot(x), this.client.getStackInSlot(x))) continue;
                if (changedSlots == null) {
                    changedSlots = new IntArrayList();
                }
                changedSlots.add(x);
            }
            return changedSlots;
        }

        private static boolean isDifferent(ItemStack a, ItemStack b) {
            if (a.m_41619_() && b.m_41619_()) {
                return false;
            }
            if (a.m_41619_() || b.m_41619_()) {
                return true;
            }
            return !ItemStack.m_41728_((ItemStack)a, (ItemStack)b);
        }
    }

    private static class PatternSlotFilter
    implements IAEItemFilter {
        private PatternSlotFilter() {
        }

        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return true;
        }

        public boolean allowInsert(InternalInventory inv, int slot, ItemStack stack) {
            return !stack.m_41619_() && PatternDetailsHelper.isEncodedPattern((ItemStack)stack);
        }
    }
}

