/*
 * Decompiled with CFR 0.152.
 */
package yuuki1293.ae2peat.itemlists;

import appeng.api.implementations.blockentities.PatternContainerGroup;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public interface IItemListsAdapter {
    @NotNull
    public List<? extends ItemLike> machinesFromRecipeType(@NotNull ResourceLocation var1);

    default public Optional<PatternContainerGroup> findFirst(List<PatternContainerGroup> groups, ResourceLocation recipeType) {
        List<? extends ItemLike> machines = this.machinesFromRecipeType(recipeType);
        if (machines.isEmpty()) {
            return Optional.empty();
        }
        for (PatternContainerGroup group : groups) {
            if (!group.name().getString().equals(recipeType.toString())) continue;
            return Optional.of(group);
        }
        return this.findFirst(groups, machines);
    }

    default public Optional<PatternContainerGroup> findFirst(List<PatternContainerGroup> groups, List<? extends ItemLike> machines) {
        List<String> localizedNames = machines.stream().map(m -> m.asItem().getDefaultInstance().getHoverName().getString().toLowerCase()).toList();
        for (PatternContainerGroup group : groups) {
            String searchName = group.name().getString().toLowerCase();
            Optional<String> matched = localizedNames.stream().filter(m -> m.equals(searchName)).findFirst();
            if (!matched.isPresent()) continue;
            return Optional.of(group);
        }
        return Optional.empty();
    }
}

