package yuuki1293.ae2peat.wireless;

import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.BackgroundPanel;
import appeng.client.gui.widgets.ToolboxPanel;
import appeng.client.gui.widgets.UpgradesPanel;
import appeng.menu.SlotSemantics;
import de.mari_023.ae2wtlib.wut.CycleTerminalButton;
import de.mari_023.ae2wtlib.wut.IUniversalTerminalCapable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import yuuki1293.ae2peat.gui.PatternEncodingAccessTermScreen;

public class WPEATScreen extends PatternEncodingAccessTermScreen<WPEATMenu> implements IUniversalTerminalCapable {
    public WPEATScreen(WPEATMenu container, Inventory playerInventory, Component title, ScreenStyle style) {
        super(container, playerInventory, title, style);
        if (getMenu().isWUT()) addToLeftToolbar(new CycleTerminalButton(btn -> cycleTerminal()));

        widgets.add(
                "upgrades",
                new UpgradesPanel(
                        getMenu().getSlots(SlotSemantics.UPGRADE), getMenu().getHost()));
        if (getMenu().getToolbox().isPresent())
            widgets.add(
                    "toolbox", new ToolboxPanel(style, getMenu().getToolbox().getName()));
        widgets.add("singularityBackground", new BackgroundPanel(style.getImage("singularityBackground")));
    }

    @Override
    public void storeState() {}
}
