/*
 * Decompiled with CFR 0.152.
 */
package yuuki1293.ae2peat;

import appeng.api.util.AEColor;
import appeng.client.render.StaticItemColor;
import appeng.core.AELog;
import appeng.init.client.InitScreens;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import yuuki1293.ae2peat.definisions.PEATCreativeTab;
import yuuki1293.ae2peat.definisions.PEATItems;
import yuuki1293.ae2peat.definisions.PEATMenus;
import yuuki1293.ae2peat.gui.PatternEncodingAccessTermScreen;
import yuuki1293.ae2peat.xmod.Addons;
import yuuki1293.ae2peat.xmod.ae2wtlib.AE2WtLibPlugin;

@Mod(value="ae2peat")
public class AE2PEAT {
    public static final String MOD_ID = "ae2peat";

    public AE2PEAT() {
        FMLJavaModLoadingContext context = FMLJavaModLoadingContext.get();
        IEventBus eventBus = context.getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        PEATItems.INSTANCE.register(eventBus);
        PEATMenus.INSTANCE.register(eventBus);
        PEATCreativeTab.INSTANCE.register(eventBus);
        eventBus.addListener(this::commonSetup);
        eventBus.addListener(this::onAe2Initialized);
        eventBus.addListener(AE2PEAT::initUpgrades);
    }

    public static ResourceLocation makeId(String id) {
        return new ResourceLocation(MOD_ID, id);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(this::postRegistrationInitialization).whenComplete((res, err) -> {
            if (err != null) {
                AELog.warn((Throwable)err);
            }
        });
    }

    public void postRegistrationInitialization() {
        if (Addons.AE2WTLIB.isLoaded()) {
            AE2WtLibPlugin.initGridLinkables();
        }
    }

    public void onAe2Initialized(RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)ForgeRegistries.MENU_TYPES.getRegistryKey()) && Addons.AE2WTLIB.isLoaded()) {
            AE2WtLibPlugin.initMenu();
        }
        if (event.getRegistryKey().equals((Object)ForgeRegistries.ITEMS.getRegistryKey()) && Addons.AE2WTLIB.isLoaded()) {
            AE2WtLibPlugin.initMenuType();
        }
    }

    private static void initUpgrades(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            if (Addons.AE2WTLIB.isLoaded()) {
                AE2WtLibPlugin.initUpgrades();
            }
        });
    }

    @Mod.EventBusSubscriber(modid="ae2peat", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            InitScreens.register(PEATMenus.PATTERN_ENCODING_ACCESS_TERMINAL.get(), PatternEncodingAccessTermScreen::new, (String)"/screens/terminals/pattern_encoding_access_terminal.json");
            if (Addons.AE2WTLIB.isLoaded()) {
                AE2WtLibPlugin.initScreen();
            }
        }

        @SubscribeEvent
        public static void initItemColours(RegisterColorHandlersEvent.Item event) {
            event.register(ClientModEvents.makeOpaque((ItemColor)new StaticItemColor(AEColor.TRANSPARENT)), new ItemLike[]{PEATItems.PATTERN_ENCODING_ACCESS_TERMINAL.m_5456_()});
        }

        private static ItemColor makeOpaque(ItemColor itemColor) {
            return (stack, tintIndex) -> itemColor.m_92671_(stack, tintIndex) | 0xFF000000;
        }
    }
}

