/*
 * Decompiled with CFR 0.152.
 */
package yuuki1293.ae2peat.gui;

import appeng.api.config.ActionItems;
import appeng.client.Point;
import appeng.client.gui.Icon;
import appeng.client.gui.WidgetContainer;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.widgets.ActionButton;
import appeng.client.gui.widgets.ToggleButton;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.GuiText;
import appeng.menu.SlotSemantics;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import yuuki1293.ae2peat.gui.EncodingModePanel;
import yuuki1293.ae2peat.gui.PatternEncodingAccessTermScreen;

public class CraftingEncodingPanel
extends EncodingModePanel {
    private static final Blitter BG = Blitter.texture((String)"guis/pattern_modes.png").src(0, 0, 126, 68);
    private final ActionButton clearBtn = new ActionButton(ActionItems.CLOSE, act -> this.menu.clear());
    private final ToggleButton substitutionsBtn;
    private final ToggleButton fluidSubstitutionsBtn;

    public CraftingEncodingPanel(PatternEncodingAccessTermScreen<?> screen, WidgetContainer widgets) {
        super(screen, widgets);
        this.clearBtn.setHalfSize(true);
        widgets.add("craftingClearPattern", (AbstractWidget)this.clearBtn);
        this.substitutionsBtn = this.createCraftingSubstitutionButton(widgets);
        this.fluidSubstitutionsBtn = this.createCraftingFluidSubstitutionButton(widgets);
    }

    @Override
    public ItemStack getTabIconItem() {
        return Items.f_41960_.m_7968_();
    }

    @Override
    public Component getTabTooltip() {
        return GuiText.CraftingPattern.text();
    }

    private ToggleButton createCraftingSubstitutionButton(WidgetContainer widgets) {
        ToggleButton button = new ToggleButton(Icon.SUBSTITUTION_ENABLED, Icon.SUBSTITUTION_DISABLED, this.menu::setSubstitute);
        button.setHalfSize(true);
        button.setTooltipOn(List.of(ButtonToolTips.SubstitutionsOn.text(), ButtonToolTips.SubstitutionsDescEnabled.text()));
        button.setTooltipOff(List.of(ButtonToolTips.SubstitutionsOff.text(), ButtonToolTips.SubstitutionsDescDisabled.text()));
        widgets.add("craftingSubstitutions", (AbstractWidget)button);
        return button;
    }

    private ToggleButton createCraftingFluidSubstitutionButton(WidgetContainer widgets) {
        ToggleButton button = new ToggleButton(Icon.FLUID_SUBSTITUTION_ENABLED, Icon.FLUID_SUBSTITUTION_DISABLED, this.menu::setSubstituteFluids);
        button.setHalfSize(true);
        button.setTooltipOn(List.of(ButtonToolTips.FluidSubstitutions.text(), ButtonToolTips.FluidSubstitutionsDescEnabled.text()));
        button.setTooltipOff(List.of(ButtonToolTips.FluidSubstitutions.text(), ButtonToolTips.FluidSubstitutionsDescDisabled.text()));
        widgets.add("craftingFluidSubstitutions", (AbstractWidget)button);
        return button;
    }

    public void drawBackgroundLayer(GuiGraphics guiGraphics, Rect2i bounds, Point mouse) {
        BG.dest(bounds.m_110085_() + 9, bounds.m_110086_() + bounds.m_110091_() - 164).blit(guiGraphics);
        int absMouseX = bounds.m_110085_() + mouse.getX();
        int absMouseY = bounds.m_110086_() + mouse.getY();
        if (this.menu.substituteFluids && this.fluidSubstitutionsBtn.m_5953_((double)absMouseX, (double)absMouseY)) {
            for (Integer slotIndex : this.menu.slotsSupportingFluidSubstitution) {
                this.drawSlotGreenBG(bounds, guiGraphics, (Slot)this.menu.getCraftingGridSlots()[slotIndex]);
            }
        }
    }

    private void drawSlotGreenBG(Rect2i bounds, GuiGraphics guiGraphics, Slot slot) {
        int x = bounds.m_110085_() + slot.f_40220_;
        int y = bounds.m_110086_() + slot.f_40221_;
        guiGraphics.m_280509_(x, y, x + 16, y + 16, 0x7F00FF00);
    }

    public void updateBeforeRender() {
        this.substitutionsBtn.setState(this.menu.substitute);
        this.fluidSubstitutionsBtn.setState(this.menu.substituteFluids);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.clearBtn.setVisibility(visible);
        this.substitutionsBtn.setVisibility(visible);
        this.fluidSubstitutionsBtn.setVisibility(visible);
        this.screen.setSlotsHidden(SlotSemantics.CRAFTING_GRID, !visible);
        this.screen.setSlotsHidden(SlotSemantics.CRAFTING_RESULT, !visible);
    }
}

