/*
 * Decompiled with CFR 0.152.
 */
package yuuki1293.ae2peat.gui;

import appeng.api.behaviors.ContainerItemStrategies;
import appeng.api.behaviors.EmptyingAction;
import appeng.api.config.ActionItems;
import appeng.api.config.Settings;
import appeng.api.config.ShowPatternProviders;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.TerminalStyle;
import appeng.api.config.TypeFilter;
import appeng.api.config.ViewItems;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.implementations.blockentities.PatternContainerGroup;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.ICompositeWidget;
import appeng.client.gui.me.common.Repo;
import appeng.client.gui.me.common.StackSizeRenderer;
import appeng.client.gui.me.patternaccess.PatternContainerRecord;
import appeng.client.gui.me.patternaccess.PatternSlot;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.AETextField;
import appeng.client.gui.widgets.ActionButton;
import appeng.client.gui.widgets.IScrollSource;
import appeng.client.gui.widgets.ISortSource;
import appeng.client.gui.widgets.Scrollbar;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.client.gui.widgets.TabButton;
import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.render.SimpleRenderContext;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.GuiText;
import appeng.core.localization.Tooltips;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.helpers.InventoryAction;
import appeng.menu.SlotSemantic;
import appeng.menu.SlotSemantics;
import appeng.menu.me.common.IClientRepo;
import appeng.parts.encoding.EncodingMode;
import appeng.util.inv.AppEngInternalInventory;
import com.google.common.collect.HashMultimap;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.locale.Language;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import yuuki1293.ae2peat.gui.CraftingEncodingPanel;
import yuuki1293.ae2peat.gui.EncodingModePanel;
import yuuki1293.ae2peat.gui.ProcessingEncodingPanel;
import yuuki1293.ae2peat.gui.SetProcessingPatternAmountScreen;
import yuuki1293.ae2peat.gui.SmithingTableEncodingPanel;
import yuuki1293.ae2peat.gui.StonecuttingEncodingPanel;
import yuuki1293.ae2peat.menu.PatternEncodingAccessTermMenu;

public class PatternEncodingAccessTermScreen<C extends PatternEncodingAccessTermMenu>
extends AEBaseScreen<C>
implements ISortSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PatternEncodingAccessTermScreen.class);
    private static final int GUI_WIDTH = 195;
    private static final int GUI_TOP_AND_BOTTOM_PADDING = 54;
    private static final int GUI_PADDING_X = 8;
    private static final int GUI_PADDING_Y = 6;
    private static final int GUI_HEADER_HEIGHT = 17;
    private static final int GUI_FOOTER_HEIGHT = 178;
    private static final int COLUMNS = 9;
    private static final int PATTERN_PROVIDER_NAME_MARGIN_X = 2;
    private static final int TEXT_MAX_WIDTH = 155;
    private static final int ROW_HEIGHT = 18;
    private static final int SLOT_SIZE = 18;
    private static final Rect2i HEADER_BBOX = new Rect2i(0, 0, 195, 17);
    private static final Rect2i ROW_TEXT_TOP_BBOX = new Rect2i(0, 17, 195, 18);
    private static final Rect2i ROW_TEXT_MIDDLE_BBOX = new Rect2i(0, 53, 195, 18);
    private static final Rect2i ROW_TEXT_BOTTOM_BBOX = new Rect2i(0, 89, 195, 18);
    private static final Rect2i ROW_INVENTORY_TOP_BBOX = new Rect2i(0, 35, 195, 18);
    private static final Rect2i ROW_INVENTORY_MIDDLE_BBOX = new Rect2i(0, 71, 195, 18);
    private static final Rect2i ROW_INVENTORY_BOTTOM_BBOX = new Rect2i(0, 107, 195, 18);
    private static final Rect2i FOOTER_BBOX = new Rect2i(0, 71, 195, 178);
    private static final Comparator<PatternContainerGroup> GROUP_COMPARATOR = Comparator.comparing(group -> group.name().getString().toLowerCase(Locale.ROOT));
    private final HashMap<Long, PatternContainerRecord> byId = new HashMap();
    private final HashMultimap<PatternContainerGroup, PatternContainerRecord> byGroup = HashMultimap.create();
    private final ArrayList<PatternContainerGroup> groups = new ArrayList();
    private final ArrayList<Row> rows = new ArrayList();
    private final Map<String, Set<Object>> cachedSearches = new WeakHashMap<String, Set<Object>>();
    private final Scrollbar scrollbar;
    private final AETextField searchField;
    private int visibleRows = 0;
    private final ServerSettingToggleButton<ShowPatternProviders> showPatternProviders;
    private final Map<EncodingMode, EncodingModePanel> modePanels = new EnumMap<EncodingMode, EncodingModePanel>(EncodingMode.class);
    private final Map<EncodingMode, TabButton> modeTabButtons = new EnumMap<EncodingMode, TabButton>(EncodingMode.class);
    protected final Repo repo;

    public PatternEncodingAccessTermScreen(C menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super(menu, playerInventory, title, style);
        this.scrollbar = this.widgets.addScrollBar("scrollbar");
        this.f_97726_ = 195;
        TerminalStyle terminalStyle = AEConfig.instance().getTerminalStyle();
        this.addToLeftToolbar((Button)new SettingToggleButton(Settings.TERMINAL_STYLE, (Enum)terminalStyle, this::toggleTerminalStyle));
        this.showPatternProviders = new ServerSettingToggleButton(Settings.TERMINAL_SHOW_PATTERN_PROVIDERS, (Enum)ShowPatternProviders.VISIBLE);
        this.addToLeftToolbar((Button)this.showPatternProviders);
        this.searchField = this.widgets.addTextField("search");
        this.searchField.m_94151_(str -> this.refreshList());
        this.searchField.setPlaceholder((Component)GuiText.SearchPlaceholder.text());
        for (EncodingMode mode : EncodingMode.values()) {
            EncodingModePanel panel = switch (mode) {
                default -> throw new IncompatibleClassChangeError();
                case EncodingMode.CRAFTING -> new CraftingEncodingPanel(this, this.widgets);
                case EncodingMode.PROCESSING -> new ProcessingEncodingPanel(this, this.widgets);
                case EncodingMode.SMITHING_TABLE -> new SmithingTableEncodingPanel(this, this.widgets);
                case EncodingMode.STONECUTTING -> new StonecuttingEncodingPanel(this, this.widgets);
            };
            TabButton tabButton = new TabButton(panel.getTabIconItem(), panel.getTabTooltip(), btn -> ((PatternEncodingAccessTermMenu)this.m_6262_()).setMode(mode));
            tabButton.setStyle(TabButton.Style.HORIZONTAL);
            int modeIndex = this.modeTabButtons.size();
            this.widgets.add("modePanel" + modeIndex, (ICompositeWidget)panel);
            this.widgets.add("modeTabButton" + modeIndex, (AbstractWidget)tabButton);
            this.modeTabButtons.put(mode, tabButton);
            this.modePanels.put(mode, panel);
        }
        ActionButton encodeBtn = new ActionButton(ActionItems.ENCODE, act -> menu.encode());
        this.widgets.add("encodePattern", (AbstractWidget)encodeBtn);
        this.repo = new Repo((IScrollSource)this.scrollbar, (ISortSource)this);
        ((PatternEncodingAccessTermMenu)((Object)menu)).setClientRepo((IClientRepo)this.repo);
    }

    public void m_7856_() {
        this.visibleRows = this.config.getTerminalStyle().getRows((this.f_96544_ - 17 - 178 - AEConfig.instance().getTerminalMargin() * 2) / 18);
        this.f_97727_ = 195 + this.visibleRows * 18;
        super.m_7856_();
        this.resetScrollbar();
    }

    public void drawFG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY) {
        ((PatternEncodingAccessTermMenu)this.f_97732_).f_38839_.removeIf(slot -> slot instanceof PatternSlot);
        int textColor = this.getStyle().getColor(PaletteColor.DEFAULT_TEXT_COLOR).toARGB();
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        int scrollLevel = this.scrollbar.getCurrentScroll();
        for (int i = 0; i < this.visibleRows; ++i) {
            int rows;
            if (scrollLevel + i >= this.rows.size()) continue;
            Row row = this.rows.get(scrollLevel + i);
            if (row instanceof SlotsRow) {
                SlotsRow slotsRow = (SlotsRow)row;
                PatternContainerRecord container = slotsRow.container;
                for (int col = 0; col < slotsRow.slots; ++col) {
                    PatternSlot slot2 = new PatternSlot(container, slotsRow.offset + col, col * 18 + 8, (i + 1) * 18);
                    ((PatternEncodingAccessTermMenu)this.f_97732_).f_38839_.add((Object)slot2);
                    ItemStack pattern = container.getInventory().getStackInSlot(slotsRow.offset + col);
                    if (pattern.m_41619_() || PatternDetailsHelper.decodePattern((ItemStack)pattern, (Level)level, (boolean)false) != null) continue;
                    guiGraphics.m_280509_(slot2.f_40220_, slot2.f_40221_, slot2.f_40220_ + 16, slot2.f_40221_ + 16, 0x7FFF0000);
                }
                continue;
            }
            if (!(row instanceof GroupHeaderRow)) continue;
            GroupHeaderRow headerRow = (GroupHeaderRow)row;
            PatternContainerGroup group = headerRow.group;
            if (group.icon() != null) {
                SimpleRenderContext renderContext = new SimpleRenderContext(LytRect.empty(), guiGraphics);
                renderContext.renderItem(group.icon().getReadOnlyStack(), 10, 23 + i * 18, 8.0f, 8.0f);
            }
            Object displayName = (rows = this.byGroup.get((Object)group).size()) > 1 ? Component.m_237119_().m_7220_(group.name()).m_7220_((Component)Component.m_237113_((String)(" (" + rows + ")"))) : group.name();
            FormattedCharSequence text = Language.m_128107_().m_5536_(this.f_96547_.m_92854_((FormattedText)displayName, 145));
            guiGraphics.m_280649_(this.f_96547_, text, 20, 23 + i * 18, textColor, false);
        }
    }

    protected void m_280072_(@NotNull GuiGraphics guiGraphics, int x, int y) {
        Row row;
        int hoveredLineIndex;
        if (((PatternEncodingAccessTermMenu)this.f_97732_).m_142621_().m_41619_() && ((PatternEncodingAccessTermMenu)this.f_97732_).canModifyAmountForSlot(this.f_97734_)) {
            ArrayList<Component> itemTooltip = new ArrayList<Component>(this.m_280553_(this.f_97734_.m_7993_()));
            GenericStack unwrapped = GenericStack.fromItemStack((ItemStack)this.f_97734_.m_7993_());
            if (unwrapped != null) {
                itemTooltip.add(Tooltips.getAmountTooltip((ButtonToolTips)ButtonToolTips.Amount, (GenericStack)unwrapped));
            }
            itemTooltip.add(Tooltips.getSetAmountTooltip());
            this.drawTooltip(guiGraphics, x, y, itemTooltip);
        } else if (this.f_97734_ == null && (hoveredLineIndex = this.getHoveredLineIndex(x, y)) != -1 && (row = this.rows.get(hoveredLineIndex)) instanceof GroupHeaderRow) {
            GroupHeaderRow headerRow = (GroupHeaderRow)row;
            if (!headerRow.group.tooltip().isEmpty()) {
                guiGraphics.m_280677_(this.f_96547_, headerRow.group.tooltip(), Optional.empty(), x, y);
                return;
            }
        }
        super.m_280072_(guiGraphics, x, y);
    }

    private int getHoveredLineIndex(int x, int y) {
        x = x - this.f_97735_ - 8;
        y = y - this.f_97736_ - 18;
        if (x < 0 || y < 0) {
            return -1;
        }
        if (x >= 162 || y >= this.visibleRows * 18) {
            return -1;
        }
        int rowIndex = this.scrollbar.getCurrentScroll() + y / 18;
        if (rowIndex < 0 || rowIndex >= this.rows.size()) {
            return -1;
        }
        return rowIndex;
    }

    public boolean m_6375_(double xCoord, double yCoord, int btn) {
        GenericStack currentStack;
        Slot slot;
        if (btn == 1 && this.searchField.m_5953_(xCoord, yCoord)) {
            this.searchField.m_94144_("");
        }
        if (this.f_96541_.f_91066_.f_92097_.m_90830_(btn) && ((PatternEncodingAccessTermMenu)this.f_97732_).canModifyAmountForSlot(slot = this.m_97744_(xCoord, yCoord)) && (currentStack = GenericStack.fromItemStack((ItemStack)slot.m_7993_())) != null) {
            SetProcessingPatternAmountScreen screen = new SetProcessingPatternAmountScreen(this, currentStack, newStack -> NetworkHandler.instance().sendToServer((BasePacket)new InventoryActionPacket(InventoryAction.SET_FILTER, slot.f_40219_, GenericStack.wrapInItemStack((GenericStack)newStack))));
            this.switchToScreen((AEBaseScreen)screen);
            return true;
        }
        return super.m_6375_(xCoord, yCoord, btn);
    }

    protected void m_6597_(Slot slot, int slotIdx, int mouseButton, ClickType clickType) {
        if (slot instanceof PatternSlot) {
            PatternSlot machineSlot = (PatternSlot)slot;
            InventoryAction action = null;
            switch (clickType) {
                case PICKUP: {
                    action = mouseButton == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
                    break;
                }
                case QUICK_MOVE: {
                    action = mouseButton == 1 ? InventoryAction.PICKUP_SINGLE : InventoryAction.SHIFT_CLICK;
                    break;
                }
                case CLONE: {
                    if (!this.getPlayer().m_150110_().f_35937_) break;
                    action = InventoryAction.CREATIVE_DUPLICATE;
                    break;
                }
            }
            if (action != null) {
                InventoryActionPacket p = new InventoryActionPacket(action, machineSlot.getSlotIndex(), machineSlot.getMachineInv().getServerId());
                NetworkHandler.instance().sendToServer((BasePacket)p);
            }
            return;
        }
        super.m_6597_(slot, slotIdx, mouseButton, clickType);
    }

    public void drawBG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        this.blitAccess(guiGraphics, offsetX, offsetY, HEADER_BBOX);
        int scrollLevel = this.scrollbar.getCurrentScroll();
        int currentY = offsetY + 17;
        this.blitEncoding(guiGraphics, offsetX, currentY + this.visibleRows * 18, FOOTER_BBOX);
        for (int i = 0; i < this.visibleRows; ++i) {
            Row row;
            boolean firstLine = i == 0;
            boolean lastLine = i == this.visibleRows - 1;
            Rect2i bbox = this.selectRowBackgroundBox(false, firstLine, lastLine);
            this.blitAccess(guiGraphics, offsetX, currentY, bbox);
            if (scrollLevel + i < this.rows.size() && (row = this.rows.get(scrollLevel + i)) instanceof SlotsRow) {
                SlotsRow slotsRow = (SlotsRow)row;
                bbox = this.selectRowBackgroundBox(true, firstLine, lastLine);
                bbox.m_173056_(8 + 18 * slotsRow.slots - 1);
                this.blitAccess(guiGraphics, offsetX, currentY, bbox);
            }
            currentY += 18;
        }
    }

    private Rect2i selectRowBackgroundBox(boolean isInvLine, boolean firstLine, boolean lastLine) {
        if (isInvLine) {
            if (firstLine) {
                return ROW_INVENTORY_TOP_BBOX;
            }
            if (lastLine) {
                return ROW_INVENTORY_BOTTOM_BBOX;
            }
            return ROW_INVENTORY_MIDDLE_BBOX;
        }
        if (firstLine) {
            return ROW_TEXT_TOP_BBOX;
        }
        if (lastLine) {
            return ROW_TEXT_BOTTOM_BBOX;
        }
        return ROW_TEXT_MIDDLE_BBOX;
    }

    public boolean m_5534_(char character, int key) {
        if (character == ' ' && this.searchField.m_94155_().isEmpty()) {
            return true;
        }
        return super.m_5534_(character, key);
    }

    public void clear() {
        this.byId.clear();
        this.cachedSearches.clear();
        this.refreshList();
    }

    public void postFullUpdate(long inventoryId, long sortBy, PatternContainerGroup group, int inventorySize, Int2ObjectMap<ItemStack> slots) {
        PatternContainerRecord record = new PatternContainerRecord(inventoryId, inventorySize, sortBy, group);
        this.byId.put(inventoryId, record);
        AppEngInternalInventory inventory = record.getInventory();
        for (Int2ObjectMap.Entry entry : slots.int2ObjectEntrySet()) {
            inventory.setItemDirect(entry.getIntKey(), (ItemStack)entry.getValue());
        }
        this.cachedSearches.clear();
        this.refreshList();
    }

    public void postIncrementalUpdate(long inventoryId, Int2ObjectMap<ItemStack> slots) {
        PatternContainerRecord record = this.byId.get(inventoryId);
        if (record == null) {
            LOGGER.warn("Ignoring incremental update for unknown inventory id {}", (Object)inventoryId);
            return;
        }
        AppEngInternalInventory inventory = record.getInventory();
        for (Int2ObjectMap.Entry entry : slots.int2ObjectEntrySet()) {
            inventory.setItemDirect(entry.getIntKey(), (ItemStack)entry.getValue());
        }
    }

    public void updateBeforeRender() {
        super.updateBeforeRender();
        this.showPatternProviders.set((Enum)((PatternEncodingAccessTermMenu)this.f_97732_).getShownProviders());
        for (EncodingMode mode : EncodingMode.values()) {
            boolean selected = ((PatternEncodingAccessTermMenu)this.f_97732_).getMode() == mode;
            this.modeTabButtons.get(mode).setSelected(selected);
            this.modePanels.get(mode).setVisible(selected);
        }
    }

    protected EmptyingAction getEmptyingAction(Slot slot, ItemStack carried) {
        EmptyingAction emptyingAction;
        if (((PatternEncodingAccessTermMenu)this.f_97732_).isProcessingPatternSlot(slot) && (emptyingAction = ContainerItemStrategies.getEmptyingAction((ItemStack)carried)) != null) {
            return emptyingAction;
        }
        return super.getEmptyingAction(slot, carried);
    }

    public void m_280092_(GuiGraphics guiGraphics, Slot s) {
        super.m_280092_(guiGraphics, s);
        if (this.shouldShowCraftableIndicatorForSlot(s)) {
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, 100.0f);
            StackSizeRenderer.renderSizeLabel((GuiGraphics)guiGraphics, (Font)this.f_96547_, (float)(s.f_40220_ - 11), (float)(s.f_40221_ - 11), (String)"+", (boolean)false);
            poseStack.m_85849_();
        }
    }

    protected List<Component> m_280553_(ItemStack stack) {
        ArrayList<MutableComponent> lines = super.m_280553_(stack);
        if (this.f_97734_ != null && this.shouldShowCraftableIndicatorForSlot(this.f_97734_)) {
            lines = new ArrayList<MutableComponent>(lines);
            lines.add(ButtonToolTips.Craftable.text().m_130940_(ChatFormatting.DARK_GRAY));
        }
        return lines;
    }

    private boolean shouldShowCraftableIndicatorForSlot(Slot s) {
        SlotSemantic semantic = ((PatternEncodingAccessTermMenu)this.f_97732_).getSlotSemantic(s);
        if (semantic == SlotSemantics.CRAFTING_GRID || semantic == SlotSemantics.PROCESSING_INPUTS || semantic == SlotSemantics.SMITHING_TABLE_ADDITION || semantic == SlotSemantics.SMITHING_TABLE_BASE || semantic == SlotSemantics.SMITHING_TABLE_TEMPLATE || semantic == SlotSemantics.STONECUTTING_INPUT) {
            GenericStack slotContent = GenericStack.fromItemStack((ItemStack)s.m_7993_());
            if (slotContent == null) {
                return false;
            }
            return this.repo.isCraftable(slotContent.what());
        }
        return false;
    }

    private void refreshList() {
        this.byGroup.clear();
        String searchFilterLowerCase = this.searchField.m_94155_().toLowerCase();
        Set<Object> cachedSearch = this.getCacheForSearchTerm(searchFilterLowerCase);
        boolean rebuild = cachedSearch.isEmpty();
        for (PatternContainerRecord entry : this.byId.values()) {
            if (!rebuild && !cachedSearch.contains(entry)) continue;
            boolean found = searchFilterLowerCase.isEmpty();
            if (!found) {
                ItemStack itemStack;
                Iterator iterator = entry.getInventory().iterator();
                while (iterator.hasNext() && !(found = this.itemStackMatchesSearchTerm(itemStack = (ItemStack)iterator.next(), searchFilterLowerCase))) {
                }
            }
            if (found || entry.getSearchName().contains(searchFilterLowerCase)) {
                this.byGroup.put((Object)entry.getGroup(), (Object)entry);
                cachedSearch.add(entry);
                continue;
            }
            cachedSearch.remove(entry);
        }
        this.groups.clear();
        this.groups.addAll(this.byGroup.keySet());
        this.groups.sort(GROUP_COMPARATOR);
        this.rows.clear();
        this.rows.ensureCapacity(this.getMaxRows());
        for (PatternContainerGroup group : this.groups) {
            this.rows.add(new GroupHeaderRow(group));
            ArrayList containers = new ArrayList(this.byGroup.get((Object)group));
            Collections.sort(containers);
            for (PatternContainerRecord container : containers) {
                AppEngInternalInventory inventory = container.getInventory();
                for (int offset = 0; offset < inventory.size(); offset += 9) {
                    int slots = Math.min(inventory.size() - offset, 9);
                    SlotsRow containerRow = new SlotsRow(container, offset, slots);
                    this.rows.add(containerRow);
                }
            }
        }
        this.resetScrollbar();
    }

    private void resetScrollbar() {
        this.scrollbar.setHeight(this.visibleRows * 18 - 2);
        this.scrollbar.setRange(0, this.rows.size() - this.visibleRows, 2);
    }

    private boolean itemStackMatchesSearchTerm(ItemStack itemStack, String searchTerm) {
        if (itemStack.m_41619_()) {
            return false;
        }
        CompoundTag encodedValue = itemStack.m_41783_();
        if (encodedValue == null) {
            return false;
        }
        ListTag outTag = encodedValue.m_128437_("out", 10);
        for (int i = 0; i < outTag.size(); ++i) {
            String displayName;
            ItemStack parsedItemStack = ItemStack.m_41712_((CompoundTag)outTag.m_128728_(i));
            AEItemKey itemKey = AEItemKey.of((ItemStack)parsedItemStack);
            if (itemKey == null || !(displayName = itemKey.getDisplayName().getString().toLowerCase()).contains(searchTerm)) continue;
            return true;
        }
        return false;
    }

    private Set<Object> getCacheForSearchTerm(String searchTerm) {
        Set<Object> cache;
        if (!this.cachedSearches.containsKey(searchTerm)) {
            this.cachedSearches.put(searchTerm, new HashSet());
        }
        if ((cache = this.cachedSearches.get(searchTerm)).isEmpty() && searchTerm.length() > 1) {
            cache.addAll(this.getCacheForSearchTerm(searchTerm.substring(0, searchTerm.length() - 1)));
        }
        return cache;
    }

    private void reinitialize() {
        this.m_6702_().removeAll(this.f_169369_);
        this.f_169369_.clear();
        this.m_7856_();
    }

    private void toggleTerminalStyle(SettingToggleButton<TerminalStyle> btn, boolean backwards) {
        TerminalStyle next = (TerminalStyle)btn.getNextValue(backwards);
        AEConfig.instance().setTerminalStyle(next);
        btn.set((Enum)next);
        this.reinitialize();
    }

    private int getMaxRows() {
        return this.groups.size() + this.byId.size();
    }

    private void blitAccess(GuiGraphics guiGraphics, int offsetX, int offsetY, Rect2i srcRect) {
        ResourceLocation texture = AppEng.makeId((String)"textures/guis/patternaccessterminal.png");
        guiGraphics.m_280218_(texture, offsetX, offsetY, srcRect.m_110085_(), srcRect.m_110086_(), srcRect.m_110090_(), srcRect.m_110091_());
    }

    private void blitEncoding(GuiGraphics guiGraphics, int offsetX, int offsetY, Rect2i srcRect) {
        ResourceLocation texture = AppEng.makeId((String)"textures/guis/pattern.png");
        guiGraphics.m_280218_(texture, offsetX, offsetY, srcRect.m_110085_(), srcRect.m_110086_(), srcRect.m_110090_(), srcRect.m_110091_());
    }

    public void m_7379_() {
        if (AEConfig.instance().isClearGridOnClose()) {
            ((PatternEncodingAccessTermMenu)this.m_6262_()).clear();
        }
        super.m_7379_();
    }

    public SortOrder getSortBy() {
        return SortOrder.AMOUNT;
    }

    public SortDir getSortDir() {
        return SortDir.ASCENDING;
    }

    public ViewItems getSortDisplay() {
        return ViewItems.ALL;
    }

    public TypeFilter getTypeFilter() {
        return TypeFilter.ALL;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static interface Row {
    }

    record SlotsRow(PatternContainerRecord container, int offset, int slots) implements Row
    {
    }

    record GroupHeaderRow(PatternContainerGroup group) implements Row
    {
    }
}

