/*
 * Decompiled with CFR 0.152.
 */
package yuuki1293.ae2peat.gui;

import appeng.api.config.ActionItems;
import appeng.client.Point;
import appeng.client.gui.Icon;
import appeng.client.gui.WidgetContainer;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.widgets.ActionButton;
import appeng.client.gui.widgets.ToggleButton;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.GuiText;
import appeng.menu.SlotSemantics;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.level.Level;
import yuuki1293.ae2peat.gui.EncodingModePanel;
import yuuki1293.ae2peat.gui.PatternEncodingAccessTermScreen;

public class SmithingTableEncodingPanel
extends EncodingModePanel {
    private static final Blitter BG = Blitter.texture((String)"guis/pattern_modes.png").src(128, 70, 126, 68);
    private final ActionButton clearBtn = new ActionButton(ActionItems.CLOSE, act -> this.menu.clear());
    private final ToggleButton substitutionsBtn;
    private final Slot resultSlot;

    public SmithingTableEncodingPanel(PatternEncodingAccessTermScreen<?> screen, WidgetContainer widgets) {
        super(screen, widgets);
        this.clearBtn.setHalfSize(true);
        widgets.add("smithingTableClearPattern", (AbstractWidget)this.clearBtn);
        this.substitutionsBtn = this.createSubstitutionButton(widgets);
        this.resultSlot = new Slot((Container)new SimpleContainer(1), 0, 0, 0);
        this.menu.addClientSideSlot(this.resultSlot, SlotSemantics.SMITHING_TABLE_RESULT);
    }

    @Override
    public ItemStack getTabIconItem() {
        return Items.f_42775_.m_7968_();
    }

    @Override
    public Component getTabTooltip() {
        return GuiText.SmithingTablePattern.text();
    }

    private ToggleButton createSubstitutionButton(WidgetContainer widgets) {
        ToggleButton button = new ToggleButton(Icon.SUBSTITUTION_ENABLED, Icon.SUBSTITUTION_DISABLED, this.menu::setSubstitute);
        button.setHalfSize(true);
        button.setTooltipOn(List.of(ButtonToolTips.SubstitutionsOn.text(), ButtonToolTips.SubstitutionsDescEnabled.text()));
        button.setTooltipOff(List.of(ButtonToolTips.SubstitutionsOff.text(), ButtonToolTips.SubstitutionsDescDisabled.text()));
        widgets.add("smithingTableSubstitutions", (AbstractWidget)button);
        return button;
    }

    public void drawBackgroundLayer(GuiGraphics guiGraphics, Rect2i bounds, Point mouse) {
        BG.dest(bounds.m_110085_() + 9, bounds.m_110086_() + bounds.m_110091_() - 164).blit(guiGraphics);
    }

    public void updateBeforeRender() {
        this.substitutionsBtn.setState(this.menu.substitute);
        SimpleContainer container = new SimpleContainer(3);
        container.m_6836_(0, this.menu.getSmithingTableTemplateSlot().m_7993_());
        container.m_6836_(1, this.menu.getSmithingTableBaseSlot().m_7993_());
        container.m_6836_(2, this.menu.getSmithingTableAdditionSlot().m_7993_());
        Level level = this.menu.getPlayer().m_9236_();
        SmithingRecipe recipe = level.m_7465_().m_44015_(RecipeType.f_44113_, (Container)container, level).orElse(null);
        if (recipe == null) {
            this.resultSlot.m_5852_(ItemStack.f_41583_);
        } else {
            this.resultSlot.m_5852_(recipe.m_5874_((Container)container, level.m_9598_()));
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.clearBtn.setVisibility(visible);
        this.substitutionsBtn.setVisibility(visible);
        this.screen.setSlotsHidden(SlotSemantics.SMITHING_TABLE_TEMPLATE, !visible);
        this.screen.setSlotsHidden(SlotSemantics.SMITHING_TABLE_BASE, !visible);
        this.screen.setSlotsHidden(SlotSemantics.SMITHING_TABLE_ADDITION, !visible);
        this.screen.setSlotsHidden(SlotSemantics.SMITHING_TABLE_RESULT, !visible);
    }
}

