/*
 * Decompiled with CFR 0.152.
 */
package yuuki1293.ae2peat.client.gui;

import appeng.api.behaviors.ContainerItemStrategies;
import appeng.api.behaviors.EmptyingAction;
import appeng.api.config.ActionItems;
import appeng.api.config.Settings;
import appeng.api.config.ShowPatternProviders;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.TerminalStyle;
import appeng.api.config.ViewItems;
import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.implementations.blockentities.PatternContainerGroup;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.AEKeyTypes;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.ILinkStatus;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.ICompositeWidget;
import appeng.client.gui.me.common.Repo;
import appeng.client.gui.me.common.RepoSlot;
import appeng.client.gui.me.common.StackSizeRenderer;
import appeng.client.gui.me.patternaccess.PatternContainerRecord;
import appeng.client.gui.me.patternaccess.PatternSlot;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.AETextField;
import appeng.client.gui.widgets.ActionButton;
import appeng.client.gui.widgets.IScrollSource;
import appeng.client.gui.widgets.ISortSource;
import appeng.client.gui.widgets.Scrollbar;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.client.gui.widgets.TabButton;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.GuiText;
import appeng.core.localization.Tooltips;
import appeng.core.network.serverbound.InventoryActionPacket;
import appeng.core.network.serverbound.QuickMovePatternPacket;
import appeng.helpers.InventoryAction;
import appeng.integration.abstraction.ItemListMod;
import appeng.menu.SlotSemantic;
import appeng.menu.SlotSemantics;
import appeng.menu.me.common.IClientRepo;
import appeng.parts.encoding.EncodingMode;
import appeng.util.inv.AppEngInternalInventory;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.vertex.PoseStack;
import guideme.color.ColorValue;
import guideme.color.ConstantColor;
import guideme.document.LytRect;
import guideme.render.SimpleRenderContext;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.NonNullList;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.pedroksl.ae2addonlib.client.widgets.AddonSettingToggleButton;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import yuuki1293.ae2peat.api.config.AccessSearchMode;
import yuuki1293.ae2peat.api.config.PEATSettings;
import yuuki1293.ae2peat.client.gui.CraftingEncodingPanel;
import yuuki1293.ae2peat.client.gui.EncodingModePanel;
import yuuki1293.ae2peat.client.gui.ProcessingEncodingPanel;
import yuuki1293.ae2peat.client.gui.SetProcessingPatternAmountScreen;
import yuuki1293.ae2peat.client.gui.SmithingTableEncodingPanel;
import yuuki1293.ae2peat.client.gui.StonecuttingEncodingPanel;
import yuuki1293.ae2peat.client.gui.widgets.PEATSettingToggleButton;
import yuuki1293.ae2peat.menu.PatternEncodingAccessTermMenu;

public class PatternEncodingAccessTermScreen<C extends PatternEncodingAccessTermMenu>
extends AEBaseScreen<C>
implements ISortSource {
    private static final Logger LOG = LoggerFactory.getLogger(PatternEncodingAccessTermScreen.class);
    protected final Repo repo;
    private final Map<EncodingMode, EncodingModePanel> modePanels = new EnumMap<EncodingMode, EncodingModePanel>(EncodingMode.class);
    private final Map<EncodingMode, TabButton> modeTabButtons = new EnumMap<EncodingMode, TabButton>(EncodingMode.class);
    private static final int GUI_WIDTH = 195;
    private static final int GUI_TOP_AND_BOTTOM_PADDING = 54;
    private static final int GUI_PADDING_X = 8;
    private static final int GUI_PADDING_Y = 6;
    private static final int GUI_HEADER_HEIGHT = 17;
    private static final int GUI_FOOTER_HEIGHT = 178;
    private static final int COLUMNS = 9;
    private static final int PATTERN_PROVIDER_NAME_MARGIN_X = 2;
    private static final int TEXT_MAX_WIDTH = 155;
    private static final int ROW_HEIGHT = 18;
    private static final int SLOT_SIZE = 18;
    private static final Rect2i HEADER_BBOX = new Rect2i(0, 0, 195, 17);
    private static final Rect2i ROW_TEXT_TOP_BBOX = new Rect2i(0, 17, 195, 18);
    private static final Rect2i ROW_TEXT_MIDDLE_BBOX = new Rect2i(0, 53, 195, 18);
    private static final Rect2i ROW_TEXT_BOTTOM_BBOX = new Rect2i(0, 89, 195, 18);
    private static final Rect2i ROW_INVENTORY_TOP_BBOX = new Rect2i(0, 35, 195, 18);
    private static final Rect2i ROW_INVENTORY_MIDDLE_BBOX = new Rect2i(0, 71, 195, 18);
    private static final Rect2i ROW_INVENTORY_BOTTOM_BBOX = new Rect2i(0, 107, 195, 18);
    private static final Rect2i FOOTER_BBOX = new Rect2i(0, 73, 195, 178);
    private static final Comparator<PatternContainerGroup> GROUP_COMPARATOR = Comparator.comparing(group -> group.name().getString().toLowerCase(Locale.ROOT));
    private final HashMap<Long, PatternContainerRecord> byId = new HashMap();
    private final HashMultimap<PatternContainerGroup, PatternContainerRecord> byGroup = HashMultimap.create();
    private final ArrayList<PatternContainerGroup> groups = new ArrayList();
    private final ArrayList<Row> rows = new ArrayList();
    private final Map<AccessSearchMode, Map<String, Set<Object>>> cachedSearches = new EnumMap<AccessSearchMode, Map<String, Set<Object>>>(AccessSearchMode.class);
    private final Scrollbar scrollbar;
    private final AETextField searchField;
    private final Map<ItemStack, String> patternSearchText = new WeakHashMap<ItemStack, String>();
    private int visibleRows = 0;
    private final ServerSettingToggleButton<ShowPatternProviders> showPatternProviders;
    private final AddonSettingToggleButton<AccessSearchMode> accessSearchMode;

    public PatternEncodingAccessTermScreen(C menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super(menu, playerInventory, title, style);
        if (this.style == null) {
            throw new IllegalStateException("Cannot construct screen " + String.valueOf(((Object)((Object)this)).getClass()) + " without a terminalStyles setting");
        }
        this.scrollbar = this.widgets.addScrollBar("scrollbar", Scrollbar.BIG);
        this.repo = new Repo((IScrollSource)this.scrollbar, (ISortSource)this);
        ((PatternEncodingAccessTermMenu)((Object)menu)).setClientRepo((IClientRepo)this.repo);
        if (!menu.isReturnedFromSubScreen() && this.config.isUseExternalSearch() && this.config.isClearExternalSearchOnOpen()) {
            ItemListMod.setSearchText((String)"");
        }
        for (EncodingMode mode : EncodingMode.values()) {
            EncodingModePanel panel = switch (mode) {
                default -> throw new MatchException(null, null);
                case EncodingMode.CRAFTING -> new CraftingEncodingPanel(this, this.widgets);
                case EncodingMode.PROCESSING -> new ProcessingEncodingPanel(this, this.widgets);
                case EncodingMode.SMITHING_TABLE -> new SmithingTableEncodingPanel(this, this.widgets);
                case EncodingMode.STONECUTTING -> new StonecuttingEncodingPanel(this, this.widgets);
            };
            TabButton tabButton = new TabButton(panel.getIcon(), panel.getTabTooltip(), btn -> ((PatternEncodingAccessTermMenu)this.getMenu()).setMode(mode));
            tabButton.setStyle(TabButton.Style.HORIZONTAL);
            int modeIndex = this.modeTabButtons.size();
            this.widgets.add("modePanel" + modeIndex, (ICompositeWidget)panel);
            this.widgets.add("modeTabButton" + modeIndex, (AbstractWidget)tabButton);
            this.modeTabButtons.put(mode, tabButton);
            this.modePanels.put(mode, panel);
        }
        ActionButton encodeBtn = new ActionButton(ActionItems.ENCODE, act -> menu.encode());
        this.widgets.add("encodePattern", (AbstractWidget)encodeBtn);
        this.imageWidth = 195;
        TerminalStyle terminalStyle = AEConfig.instance().getTerminalStyle();
        this.addToLeftToolbar((Button)new SettingToggleButton(Settings.TERMINAL_STYLE, (Enum)terminalStyle, this::toggleTerminalStyle));
        this.showPatternProviders = new ServerSettingToggleButton(Settings.TERMINAL_SHOW_PATTERN_PROVIDERS, (Enum)ShowPatternProviders.VISIBLE);
        this.addToLeftToolbar((Button)this.showPatternProviders);
        this.accessSearchMode = PEATSettingToggleButton.serverButton(PEATSettings.ACCESS_SEARCH_MODE, AccessSearchMode.BOTH);
        this.addToLeftToolbar((Button)this.accessSearchMode);
        this.searchField = this.widgets.addTextField("search");
        this.searchField.setResponder(str -> this.refreshList());
        this.searchField.setPlaceholder((Component)GuiText.SearchPlaceholder.text());
        for (AccessSearchMode mode : AccessSearchMode.values()) {
            this.cachedSearches.put(mode, new WeakHashMap());
        }
        ((PatternEncodingAccessTermMenu)this.menu).setGui(this::refreshList);
    }

    public void init() {
        NonNullList slots = ((PatternEncodingAccessTermMenu)this.menu).slots;
        slots.removeIf(slot -> slot instanceof RepoSlot);
        this.visibleRows = Math.max(2, this.config.getTerminalStyle().getRows((this.height - 17 - 178 - AEConfig.instance().getTerminalMargin() * 2) / 18));
        this.imageHeight = 195 + this.visibleRows * 18;
        super.init();
        this.resetScrollbar();
    }

    protected void updateBeforeRender() {
        super.updateBeforeRender();
        for (EncodingMode mode : EncodingMode.values()) {
            boolean selected = ((PatternEncodingAccessTermMenu)this.menu).getMode() == mode;
            this.modeTabButtons.get(mode).setSelected(selected);
            this.modePanels.get(mode).setVisible(selected);
        }
        this.showPatternProviders.set((Enum)((PatternEncodingAccessTermMenu)this.menu).getShownProviders());
        this.accessSearchMode.set((Enum)((PatternEncodingAccessTermMenu)this.menu).getAccessSearchMode());
    }

    public void drawFG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY) {
        ((PatternEncodingAccessTermMenu)this.menu).slots.removeIf(slot -> slot instanceof PatternSlot);
        int textColor = this.style.getColor(PaletteColor.DEFAULT_TEXT_COLOR).toARGB();
        ClientLevel level = Minecraft.getInstance().level;
        int scrollLevel = this.scrollbar.getCurrentScroll();
        for (int i = 0; i < this.visibleRows; ++i) {
            int rows;
            if (scrollLevel + i >= this.rows.size()) continue;
            Row row = this.rows.get(scrollLevel + i);
            if (row instanceof SlotsRow) {
                SlotsRow slotsRow = (SlotsRow)row;
                PatternContainerRecord container = slotsRow.container;
                for (int col = 0; col < slotsRow.slots; ++col) {
                    PatternSlot slot2 = new PatternSlot(container, slotsRow.offset + col, col * 18 + 8, (i + 1) * 18);
                    ((PatternEncodingAccessTermMenu)this.menu).slots.add((Object)slot2);
                    ItemStack pattern = container.getInventory().getStackInSlot(slotsRow.offset + col);
                    if (pattern.isEmpty() || PatternDetailsHelper.decodePattern((ItemStack)pattern, (Level)level) != null) continue;
                    guiGraphics.fill(slot2.x, slot2.y, slot2.x + 16, slot2.y + 16, 0x7FFF0000);
                }
                continue;
            }
            if (!(row instanceof GroupHeaderRow)) continue;
            GroupHeaderRow headerRow = (GroupHeaderRow)row;
            PatternContainerGroup group = headerRow.group;
            if (group.icon() != null) {
                SimpleRenderContext renderContext = new SimpleRenderContext(LytRect.empty(), guiGraphics);
                renderContext.renderItem(group.icon().getReadOnlyStack(), 10, 23 + i * 18, 8.0f, 8.0f);
            }
            Object displayName = (rows = this.byGroup.get((Object)group).size()) > 1 ? Component.empty().append(group.name()).append((Component)Component.literal((String)(" (" + rows + ")"))) : group.name();
            FormattedCharSequence text = Language.getInstance().getVisualOrder(this.font.substrByWidth((FormattedText)displayName, 145));
            guiGraphics.drawString(this.font, text, 20, 23 + i * 18, textColor, false);
        }
        this.renderLinkStatus(guiGraphics, ((PatternEncodingAccessTermMenu)this.getMenu()).getLinkStatus());
    }

    private void renderLinkStatus(GuiGraphics guiGraphics, ILinkStatus linkStatus) {
        if (!linkStatus.connected()) {
            SimpleRenderContext renderContext = new SimpleRenderContext(LytRect.empty(), guiGraphics);
            LytRect rect = new LytRect(7, 17, 162, this.visibleRows * 18);
            renderContext.fillRect(rect, (ColorValue)new ConstantColor(0x3F000000));
            Component statusDescription = linkStatus.statusDescription();
            if (statusDescription != null) {
                renderContext.renderTextCenteredIn(statusDescription.getString(), ERROR_TEXT_STYLE, rect);
            }
        }
    }

    public boolean mouseClicked(double xCoord, double yCoord, int btn) {
        GenericStack currentStack;
        Slot slot;
        if (this.minecraft.options.keyPickItem.matchesMouse(btn) && ((PatternEncodingAccessTermMenu)this.menu).canModifyAmountForSlot(slot = this.findSlot(xCoord, yCoord)) && (currentStack = GenericStack.fromItemStack((ItemStack)slot.getItem())) != null) {
            SetProcessingPatternAmountScreen screen = new SetProcessingPatternAmountScreen(this, currentStack, newStack -> {
                InventoryActionPacket message = new InventoryActionPacket(InventoryAction.SET_FILTER, slot.index, GenericStack.wrapInItemStack((GenericStack)newStack));
                PacketDistributor.sendToServer((CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
            });
            this.switchToScreen((AEBaseScreen)screen);
            return true;
        }
        if (btn == 1 && this.searchField.isMouseOver(xCoord, yCoord)) {
            this.searchField.setValue("");
        }
        return super.mouseClicked(xCoord, yCoord, btn);
    }

    protected void slotClicked(Slot slot, int slotIdx, int mouseButton, ClickType clickType) {
        if (slot instanceof PatternSlot) {
            InventoryAction action = null;
            switch (clickType) {
                case PICKUP: {
                    action = mouseButton == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
                    break;
                }
                case QUICK_MOVE: {
                    action = mouseButton == 1 ? InventoryAction.PICKUP_SINGLE : InventoryAction.SHIFT_CLICK;
                    break;
                }
                case CLONE: {
                    if (!this.getPlayer().getAbilities().instabuild) break;
                    action = InventoryAction.CREATIVE_DUPLICATE;
                    break;
                }
            }
            if (action != null) {
                PatternSlot machineSlot = (PatternSlot)slot;
                InventoryActionPacket p = new InventoryActionPacket(action, machineSlot.slot, machineSlot.getMachineInv().getServerId());
                PacketDistributor.sendToServer((CustomPacketPayload)p, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return;
        }
        if (clickType == ClickType.QUICK_MOVE && ((PatternEncodingAccessTermMenu)this.menu).isPlayerSideSlot(slot)) {
            LinkedHashSet<Long> visiblePatternContainers = new LinkedHashSet<Long>();
            for (Row row : this.rows) {
                if (!(row instanceof SlotsRow)) continue;
                SlotsRow slotsRow = (SlotsRow)row;
                visiblePatternContainers.add(slotsRow.container.getServerId());
            }
            int clickedSlot = slot.getContainerSlot();
            QuickMovePatternPacket packet = new QuickMovePatternPacket(((PatternEncodingAccessTermMenu)this.menu).containerId, clickedSlot, List.copyOf(visiblePatternContainers));
            PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            return;
        }
        super.slotClicked(slot, slotIdx, mouseButton, clickType);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        if (((PatternEncodingAccessTermMenu)this.menu).getCarried().isEmpty() && ((PatternEncodingAccessTermMenu)this.menu).canModifyAmountForSlot(this.hoveredSlot)) {
            ArrayList<Component> itemTooltip = new ArrayList<Component>(this.getTooltipFromContainerItem(this.hoveredSlot.getItem()));
            GenericStack unwrapped = GenericStack.fromItemStack((ItemStack)this.hoveredSlot.getItem());
            if (unwrapped != null) {
                itemTooltip.add(Tooltips.getAmountTooltip((ButtonToolTips)ButtonToolTips.Amount, (GenericStack)unwrapped));
            }
            itemTooltip.add(Tooltips.getSetAmountTooltip());
            this.drawTooltip(guiGraphics, x, y, itemTooltip);
        } else if (this.hoveredSlot == null) {
            Row row;
            int hoveredLineIndex = this.getHoveredLineIndex(x, y);
            if (hoveredLineIndex != -1 && (row = this.rows.get(hoveredLineIndex)) instanceof GroupHeaderRow) {
                GroupHeaderRow headerRow = (GroupHeaderRow)row;
                if (!headerRow.group.tooltip().isEmpty()) {
                    guiGraphics.renderTooltip(this.font, headerRow.group.tooltip(), Optional.empty(), x, y);
                    return;
                }
            }
        } else {
            super.renderTooltip(guiGraphics, x, y);
        }
    }

    private int getHoveredLineIndex(int x, int y) {
        x = x - this.leftPos - 8;
        y = y - this.topPos - 18;
        if (x < 0 || y < 0) {
            return -1;
        }
        if (x >= 162 || y >= this.visibleRows * 18) {
            return -1;
        }
        int rowIndex = this.scrollbar.getCurrentScroll() + y / 18;
        if (rowIndex < 0 || rowIndex >= this.rows.size()) {
            return -1;
        }
        return rowIndex;
    }

    protected EmptyingAction getEmptyingAction(Slot slot, ItemStack carried) {
        EmptyingAction emptyingAction;
        if (((PatternEncodingAccessTermMenu)this.menu).isProcessingPatternSlot(slot) && (emptyingAction = ContainerItemStrategies.getEmptyingAction((ItemStack)carried)) != null) {
            return emptyingAction;
        }
        return super.getEmptyingAction(slot, carried);
    }

    public void drawBG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        this.blitAccess(guiGraphics, offsetX, offsetY, HEADER_BBOX);
        int scrollLevel = this.scrollbar.getCurrentScroll();
        int currentY = offsetY + 17;
        this.blitEncoding(guiGraphics, offsetX, currentY + this.visibleRows * 18, FOOTER_BBOX);
        for (int i = 0; i < this.visibleRows; ++i) {
            Row row;
            boolean firstLine = i == 0;
            boolean lastLine = i == this.visibleRows - 1;
            Rect2i bbox = this.selectRowBackgroundBox(false, firstLine, lastLine);
            this.blitAccess(guiGraphics, offsetX, currentY, bbox);
            if (scrollLevel + i < this.rows.size() && (row = this.rows.get(scrollLevel + i)) instanceof SlotsRow) {
                SlotsRow slotsRow = (SlotsRow)row;
                bbox = this.selectRowBackgroundBox(true, firstLine, lastLine);
                bbox.setWidth(8 + 18 * slotsRow.slots - 1);
                this.blitAccess(guiGraphics, offsetX, currentY, bbox);
            }
            currentY += 18;
        }
    }

    private Rect2i selectRowBackgroundBox(boolean isInvLine, boolean firstLine, boolean lastLine) {
        if (isInvLine) {
            if (firstLine) {
                return ROW_INVENTORY_TOP_BBOX;
            }
            if (lastLine) {
                return ROW_INVENTORY_BOTTOM_BBOX;
            }
            return ROW_INVENTORY_MIDDLE_BBOX;
        }
        if (firstLine) {
            return ROW_TEXT_TOP_BBOX;
        }
        if (lastLine) {
            return ROW_TEXT_BOTTOM_BBOX;
        }
        return ROW_TEXT_MIDDLE_BBOX;
    }

    public boolean charTyped(char character, int key) {
        if (character == ' ' && this.searchField.getValue().isEmpty()) {
            return true;
        }
        return super.charTyped(character, key);
    }

    public void clear() {
        this.byId.clear();
        this.cachedSearches.forEach((k, v) -> v.clear());
        this.refreshList();
    }

    public void postFullUpdate(long inventoryId, long sortBy, PatternContainerGroup group, int inventorySize, Int2ObjectMap<ItemStack> slots) {
        PatternContainerRecord record = new PatternContainerRecord(inventoryId, inventorySize, sortBy, group);
        this.byId.put(inventoryId, record);
        AppEngInternalInventory inventory = record.getInventory();
        for (Int2ObjectMap.Entry entry : slots.int2ObjectEntrySet()) {
            inventory.setItemDirect(entry.getIntKey(), (ItemStack)entry.getValue());
        }
        this.cachedSearches.forEach((k, v) -> v.clear());
        this.refreshList();
    }

    public void postIncrementalUpdate(long inventoryId, Int2ObjectMap<ItemStack> slots) {
        PatternContainerRecord record = this.byId.get(inventoryId);
        if (record == null) {
            LOG.warn("Ignoring incremental update for unknown inventory id {}", (Object)inventoryId);
            return;
        }
        AppEngInternalInventory inventory = record.getInventory();
        for (Int2ObjectMap.Entry entry : slots.int2ObjectEntrySet()) {
            inventory.setItemDirect(entry.getIntKey(), (ItemStack)entry.getValue());
        }
    }

    public void renderSlot(GuiGraphics guiGraphics, Slot s) {
        super.renderSlot(guiGraphics, s);
        if (this.shouldShowCraftableIndicatorForSlot(s)) {
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, 100.0f);
            StackSizeRenderer.renderSizeLabel((GuiGraphics)guiGraphics, (Font)this.font, (float)(s.x - 11), (float)(s.y - 11), (String)"+", (boolean)false);
            poseStack.popPose();
        }
    }

    @NotNull
    protected List<Component> getTooltipFromContainerItem(ItemStack stack) {
        ArrayList<MutableComponent> lines = super.getTooltipFromContainerItem(stack);
        if (this.hoveredSlot != null && this.shouldShowCraftableIndicatorForSlot(this.hoveredSlot)) {
            lines = new ArrayList<MutableComponent>(lines);
            lines.add(ButtonToolTips.Craftable.text().withStyle(ChatFormatting.DARK_GRAY));
        }
        return lines;
    }

    private boolean shouldShowCraftableIndicatorForSlot(Slot s) {
        SlotSemantic semantic = ((PatternEncodingAccessTermMenu)this.menu).getSlotSemantic(s);
        if (semantic == SlotSemantics.CRAFTING_GRID || semantic == SlotSemantics.PROCESSING_INPUTS || semantic == SlotSemantics.SMITHING_TABLE_ADDITION || semantic == SlotSemantics.SMITHING_TABLE_BASE || semantic == SlotSemantics.SMITHING_TABLE_TEMPLATE || semantic == SlotSemantics.STONECUTTING_INPUT) {
            GenericStack slotContent = GenericStack.fromItemStack((ItemStack)s.getItem());
            if (slotContent == null) {
                return false;
            }
            return this.repo.isCraftable(slotContent.what());
        }
        return false;
    }

    private void refreshList() {
        AccessSearchMode searchMode = (AccessSearchMode)((PatternEncodingAccessTermMenu)this.menu).getConfigManager().getSetting(PEATSettings.ACCESS_SEARCH_MODE);
        this.byGroup.clear();
        String searchFilterLowerCase = this.searchField.getValue().toLowerCase();
        Set<Object> cachedSearch = this.getCacheForSearchTerm(searchFilterLowerCase, searchMode);
        boolean rebuild = cachedSearch.isEmpty();
        for (PatternContainerRecord entry : this.byId.values()) {
            if (!rebuild && !cachedSearch.contains(entry)) continue;
            boolean found = searchFilterLowerCase.isEmpty();
            if (!(searchMode != AccessSearchMode.BOTH && searchMode != AccessSearchMode.PATTERN || found)) {
                ItemStack itemStack;
                Iterator iterator = entry.getInventory().iterator();
                while (iterator.hasNext() && !(found = this.itemStackMatchesSearchTerm(itemStack = (ItemStack)iterator.next(), searchFilterLowerCase))) {
                }
            }
            if (searchMode == AccessSearchMode.BOTH || searchMode == AccessSearchMode.MACHINE) {
                boolean bl = found = found || entry.getSearchName().contains(searchFilterLowerCase);
            }
            if (found) {
                this.byGroup.put((Object)entry.getGroup(), (Object)entry);
                cachedSearch.add(entry);
                continue;
            }
            cachedSearch.remove(entry);
        }
        this.groups.clear();
        this.groups.addAll(this.byGroup.keySet());
        this.groups.sort(GROUP_COMPARATOR);
        this.rows.clear();
        this.rows.ensureCapacity(this.getMaxRows());
        for (PatternContainerGroup group : this.groups) {
            this.rows.add(new GroupHeaderRow(group));
            ArrayList containers = new ArrayList(this.byGroup.get((Object)group));
            Collections.sort(containers);
            for (PatternContainerRecord container : containers) {
                AppEngInternalInventory inventory = container.getInventory();
                for (int offset = 0; offset < inventory.size(); offset += 9) {
                    int slots = Math.min(inventory.size() - offset, 9);
                    SlotsRow containerRow = new SlotsRow(container, offset, slots);
                    this.rows.add(containerRow);
                }
            }
        }
        this.resetScrollbar();
    }

    private void resetScrollbar() {
        this.scrollbar.setHeight(this.visibleRows * 18 - 2);
        this.scrollbar.setRange(0, this.rows.size() - this.visibleRows, 2);
    }

    private boolean itemStackMatchesSearchTerm(ItemStack itemStack, String searchTerm) {
        if (itemStack.isEmpty()) {
            return false;
        }
        return this.patternSearchText.computeIfAbsent(itemStack, this::getPatternSearchText).contains(searchTerm);
    }

    private String getPatternSearchText(ItemStack stack) {
        Level level = ((PatternEncodingAccessTermMenu)this.menu).getPlayer().level();
        StringBuilder text = new StringBuilder();
        IPatternDetails pattern = PatternDetailsHelper.decodePattern((ItemStack)stack, (Level)level);
        if (pattern != null) {
            for (GenericStack output : pattern.getOutputs()) {
                output.what().getDisplayName().visit(content -> {
                    text.append(content.toLowerCase());
                    return Optional.empty();
                });
                text.append('\n');
            }
        }
        return text.toString();
    }

    private Set<Object> getCacheForSearchTerm(String searchTerm, AccessSearchMode searchMode) {
        Set<Object> cache;
        if (!this.cachedSearches.get((Object)searchMode).containsKey(searchTerm)) {
            this.cachedSearches.get((Object)searchMode).put(searchTerm, new HashSet());
        }
        if ((cache = this.cachedSearches.get((Object)searchMode).get(searchTerm)).isEmpty() && searchTerm.length() > 1) {
            cache.addAll(this.getCacheForSearchTerm(searchTerm.substring(0, searchTerm.length() - 1), searchMode));
        }
        return cache;
    }

    private void reinitialize() {
        this.children().removeAll(this.renderables);
        this.renderables.clear();
        this.init();
    }

    private void toggleTerminalStyle(SettingToggleButton<TerminalStyle> btn, boolean backwards) {
        TerminalStyle next = (TerminalStyle)btn.getNextValue(backwards);
        AEConfig.instance().setTerminalStyle(next);
        btn.set((Enum)next);
        this.reinitialize();
    }

    private int getMaxRows() {
        return this.groups.size() + this.byId.size();
    }

    private void blitAccess(GuiGraphics guiGraphics, int offsetX, int offsetY, Rect2i srcRect) {
        ResourceLocation texture = AppEng.makeId((String)"textures/guis/patternaccessterminal.png");
        guiGraphics.blit(texture, offsetX, offsetY, srcRect.getX(), srcRect.getY(), srcRect.getWidth(), srcRect.getHeight());
    }

    private void blitEncoding(GuiGraphics guiGraphics, int offsetX, int offsetY, Rect2i srcRect) {
        ResourceLocation texture = AppEng.makeId((String)"textures/guis/pattern.png");
        guiGraphics.blit(texture, offsetX, offsetY, srcRect.getX(), srcRect.getY(), srcRect.getWidth(), srcRect.getHeight());
    }

    protected int getVisibleRows() {
        return this.visibleRows;
    }

    public void containerTick() {
        this.repo.setEnabled(((PatternEncodingAccessTermMenu)this.menu).getLinkStatus().connected());
        super.containerTick();
    }

    public SortOrder getSortBy() {
        return SortOrder.AMOUNT;
    }

    public SortDir getSortDir() {
        return SortDir.ASCENDING;
    }

    public ViewItems getSortDisplay() {
        return ViewItems.ALL;
    }

    public Set<AEKeyType> getSortKeyTypes() {
        return Sets.newHashSet((Iterable)AEKeyTypes.getAll());
    }

    static sealed interface Row
    permits GroupHeaderRow, SlotsRow {
    }

    record SlotsRow(PatternContainerRecord container, int offset, int slots) implements Row
    {
    }

    record GroupHeaderRow(PatternContainerGroup group) implements Row
    {
    }
}

