/*
 * Decompiled with CFR 0.152.
 */
package yuuki1293.ae2peat.integration.modules.jei.transfer;

import appeng.api.stacks.GenericStack;
import appeng.core.localization.ItemModText;
import appeng.integration.modules.itemlists.TransferHelper;
import appeng.menu.me.common.GridInventoryEntry;
import appeng.menu.me.common.IClientRepo;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IUniversalRecipeTransferHandler;
import mezz.jei.api.runtime.IIngredientVisibility;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tamaized.ae2jeiintegration.integration.modules.jei.GenericEntryStackHelper;
import yuuki1293.ae2peat.integration.modules.itemlists.EncodingHelper;
import yuuki1293.ae2peat.integration.modules.jei.transfer.AbstractTransferHandler;
import yuuki1293.ae2peat.menu.PatternEncodingAccessTermMenu;

public class EncodePatternTransferHandler<T extends PatternEncodingAccessTermMenu>
extends AbstractTransferHandler
implements IUniversalRecipeTransferHandler<T> {
    private static final int CRAFTING_GRID_WIDTH = 3;
    private static final int CRAFTING_GRID_HEIGHT = 3;
    private final MenuType<T> menuType;
    private final Class<T> menuClass;
    private final IRecipeTransferHandlerHelper helper;
    private final IIngredientVisibility ingredientVisibility;

    public EncodePatternTransferHandler(MenuType<T> menuType, Class<T> menuClass, IRecipeTransferHandlerHelper helper, IIngredientVisibility ingredientVisibility) {
        this.menuType = menuType;
        this.menuClass = menuClass;
        this.helper = helper;
        this.ingredientVisibility = ingredientVisibility;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(@NotNull T menu, @NotNull Object recipeBase, @NotNull IRecipeSlotsView slotsView, @NotNull Player player, boolean maxTransfer, boolean doTransfer) {
        boolean craftingRecipe;
        Recipe recipe = null;
        RecipeHolder recipeHolder = null;
        if (recipeBase instanceof RecipeHolder) {
            recipeHolder = (RecipeHolder)recipeBase;
            recipe = recipeHolder.value();
        }
        if ((craftingRecipe = EncodingHelper.isSupportedCraftingRecipe(recipe)) && !this.fitsIn3x3Grid(recipe)) {
            return this.helper.createUserErrorWithTooltip((Component)ItemModText.RECIPE_TOO_LARGE.text());
        }
        if (doTransfer) {
            if (craftingRecipe) {
                EncodingHelper.encodeCraftingRecipe(menu, recipeHolder, this.getGuiIngredientsForCrafting(slotsView), this::isIngredientVisible);
            } else {
                EncodingHelper.encodeProcessingRecipe(menu, GenericEntryStackHelper.ofInputs((IRecipeSlotsView)slotsView), GenericEntryStackHelper.ofOutputs((IRecipeSlotsView)slotsView));
            }
        } else {
            List<IRecipeSlotView> craftableSlots = this.findCraftableSlots(menu, slotsView);
            return new ErrorRenderer(craftableSlots);
        }
        return null;
    }

    private boolean isIngredientVisible(ItemStack itemStack) {
        return this.ingredientVisibility.isIngredientVisible((IIngredientType)VanillaTypes.ITEM_STACK, (Object)itemStack);
    }

    private List<List<GenericStack>> getGuiIngredientsForCrafting(IRecipeSlotsView recipeLayout) {
        List recipeSlots = recipeLayout.getSlotViews();
        ArrayList<List<GenericStack>> result = new ArrayList<List<GenericStack>>(9);
        for (int i = 0; i < 9; ++i) {
            if (i < recipeSlots.size()) {
                IRecipeSlotView slot = (IRecipeSlotView)recipeSlots.get(i);
                result.add(slot.getIngredients((IIngredientType)VanillaTypes.ITEM_STACK).map(GenericStack::fromItemStack).filter(Objects::nonNull).toList());
                continue;
            }
            result.add(Collections.emptyList());
        }
        return result;
    }

    private List<IRecipeSlotView> findCraftableSlots(T menu, IRecipeSlotsView slotsView) {
        IClientRepo repo = ((PatternEncodingAccessTermMenu)((Object)menu)).getClientRepo();
        if (repo == null) {
            return List.of();
        }
        Set craftableKeys = repo.getAllEntries().stream().filter(GridInventoryEntry::isCraftable).map(GridInventoryEntry::getWhat).collect(Collectors.toSet());
        return slotsView.getSlotViews(RecipeIngredientRole.INPUT).stream().filter(slotView -> slotView.getAllIngredients().anyMatch(ingredient -> {
            GenericStack stack = GenericEntryStackHelper.ingredientToStack((ITypedIngredient)ingredient);
            return stack != null && craftableKeys.contains(stack.what());
        })).toList();
    }

    @NotNull
    public Optional<MenuType<T>> getMenuType() {
        return Optional.of(this.menuType);
    }

    @NotNull
    public Class<? extends T> getContainerClass() {
        return this.menuClass;
    }

    private record ErrorRenderer(List<IRecipeSlotView> craftableSlots) implements IRecipeTransferError
    {
        @NotNull
        public IRecipeTransferError.Type getType() {
            return IRecipeTransferError.Type.COSMETIC;
        }

        public int getButtonHighlightColor() {
            return 0;
        }

        public void showError(GuiGraphics guiGraphics, int mouseX, int mouseY, @NotNull IRecipeSlotsView recipeSlotsView, int recipeX, int recipeY) {
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            poseStack.translate((float)recipeX, (float)recipeY, 0.0f);
            for (IRecipeSlotView slotView : this.craftableSlots) {
                slotView.drawHighlight(guiGraphics, 0x400000FF);
            }
            poseStack.popPose();
        }

        public void getTooltip(ITooltipBuilder tooltip) {
            tooltip.addAll((Collection)TransferHelper.createEncodingTooltip((!this.craftableSlots.isEmpty() ? 1 : 0) != 0, (boolean)true));
        }
    }
}

