/*
 * Decompiled with CFR 0.152.
 */
package yuuki1293.ae2peat.parts;

import appeng.api.config.Settings;
import appeng.api.config.ShowPatternProviders;
import appeng.api.networking.IGrid;
import appeng.api.networking.IManagedGridNode;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.storage.ILinkStatus;
import appeng.api.storage.IPatternAccessTermMenuHost;
import appeng.api.storage.MEStorage;
import appeng.api.storage.SupplierStorage;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.helpers.IPatternTerminalLogicHost;
import appeng.helpers.IPatternTerminalMenuHost;
import appeng.items.parts.PartModels;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import appeng.parts.encoding.PatternEncodingLogic;
import appeng.parts.reporting.AbstractDisplayPart;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import yuuki1293.ae2peat.AE2PEAT;
import yuuki1293.ae2peat.definisions.PEATMenus;

public class PatternEncodingAccessTerminalPart
extends AbstractDisplayPart
implements IConfigurableObject,
IPatternTerminalLogicHost,
IPatternTerminalMenuHost,
IPatternAccessTermMenuHost {
    private final IConfigManager cm = IConfigManager.builder(() -> this.getHost().markForSave()).registerSetting(Settings.TERMINAL_SHOW_PATTERN_PROVIDERS, (Enum)ShowPatternProviders.VISIBLE).build();
    @PartModels
    public static final ResourceLocation MODEL_OFF = AE2PEAT.makeId("part/pattern_encoding_access_terminal_off");
    @PartModels
    public static final ResourceLocation MODEL_ON = AE2PEAT.makeId("part/pattern_encoding_access_terminal_on");
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_OFF, MODEL_STATUS_OFF});
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_ON, MODEL_STATUS_ON});
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_ON, MODEL_STATUS_HAS_CHANNEL});
    private final PatternEncodingLogic logic = new PatternEncodingLogic((IPatternTerminalLogicHost)this);

    public PatternEncodingAccessTerminalPart(IPartItem<?> partItem) {
        super(partItem, true);
    }

    public IConfigManager getConfigManager() {
        return this.cm;
    }

    public void readFromNBT(CompoundTag data, HolderLookup.Provider registries) {
        super.readFromNBT(data, registries);
        this.cm.readFromNBT(data, registries);
        this.logic.readFromNBT(data, registries);
    }

    public void writeToNBT(CompoundTag data, HolderLookup.Provider registries) {
        super.writeToNBT(data, registries);
        this.cm.writeToNBT(data, registries);
        this.logic.writeToNBT(data, registries);
    }

    public boolean onUseWithoutItem(Player player, Vec3 pos) {
        if (!super.onUseWithoutItem(player, pos) && !player.level().isClientSide) {
            MenuOpener.open(this.getMenuType(player), (Player)player, (MenuHostLocator)MenuLocators.forPart((AEBasePart)this));
        }
        return true;
    }

    public void returnToMainMenu(Player player, ISubMenu subMenu) {
        MenuOpener.open(this.getMenuType(player), (Player)player, (MenuHostLocator)subMenu.getLocator(), (boolean)true);
    }

    public ItemStack getMainMenuIcon() {
        return new ItemStack((ItemLike)this.getPartItem());
    }

    public MenuType<?> getMenuType(Player player) {
        return PEATMenus.PATTERN_ENCODING_ACCESS_TERMINAL.get();
    }

    public MEStorage getInventory() {
        return new SupplierStorage(() -> {
            IGrid grid = this.getMainNode().getGrid();
            if (grid != null) {
                return grid.getStorageService().getInventory();
            }
            return null;
        });
    }

    public ILinkStatus getLinkStatus() {
        return ILinkStatus.ofManagedNode((IManagedGridNode)this.getMainNode());
    }

    public void addAdditionalDrops(List<ItemStack> drops, boolean wrenched) {
        super.addAdditionalDrops(drops, wrenched);
        for (ItemStack is : this.logic.getBlankPatternInv()) {
            drops.add(is);
        }
        for (ItemStack is : this.logic.getEncodedPatternInv()) {
            drops.add(is);
        }
    }

    public void clearContent() {
        super.clearContent();
        this.logic.getBlankPatternInv().clear();
        this.logic.getEncodedPatternInv().clear();
    }

    public PatternEncodingLogic getLogic() {
        return this.logic;
    }

    public void markForSave() {
        this.getHost().markForSave();
    }

    public IPartModel getStaticModels() {
        return this.selectModel(MODELS_OFF, MODELS_ON, MODELS_HAS_CHANNEL);
    }
}

