/*
 * Decompiled with CFR 0.152.
 */
package com.qwsadd.qwsaddmod.capability;

import com.qwsadd.qwsaddmod.capability.IPeeCapability;
import net.minecraft.nbt.CompoundTag;

public class PeeCapabilityImpl
implements IPeeCapability {
    private int peeLevel = 0;
    private int absorbingLevel = 0;
    private static final int MAX_PEE_LEVEL = 100;

    @Override
    public int getPeeLevel() {
        return this.peeLevel;
    }

    @Override
    public void setPeeLevel(int level) {
        this.peeLevel = Math.max(0, Math.min(level, this.getMaxPeeLevel()));
    }

    @Override
    public void addPeeLevel(int amount) {
        this.setPeeLevel(this.peeLevel + amount);
    }

    @Override
    public int getAbsorbingLevel() {
        return this.absorbingLevel;
    }

    @Override
    public void setAbsorbingLevel(int level) {
        this.absorbingLevel = Math.max(0, level);
    }

    @Override
    public void addAbsorbingLevel(int amount) {
        this.setAbsorbingLevel(this.absorbingLevel + amount);
    }

    @Override
    public void decreaseAbsorbingLevel(int amount) {
        this.setAbsorbingLevel(this.absorbingLevel - amount);
    }

    @Override
    public boolean canPee() {
        return this.peeLevel > 0;
    }

    @Override
    public int getMaxPeeLevel() {
        return 100;
    }

    @Override
    public boolean isPeeFull() {
        return this.peeLevel >= this.getMaxPeeLevel();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("pee_level", this.peeLevel);
        nbt.m_128405_("absorbing_level", this.absorbingLevel);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.peeLevel = nbt.m_128451_("pee_level");
        this.absorbingLevel = nbt.m_128451_("absorbing_level");
    }
}

