/*
 * Decompiled with CFR 0.152.
 */
package com.qwsadd.qwsaddmod.capability;

import com.qwsadd.qwsaddmod.capability.IPoopCapability;
import net.minecraft.nbt.CompoundTag;

public class PoopCapabilityImpl
implements IPoopCapability {
    private int poopLevel = 0;
    private int digestingLevel = 0;
    private static final int MAX_POOP_LEVEL = 100;
    private boolean hasFullWarningShown = false;

    @Override
    public int getPoopLevel() {
        return this.poopLevel;
    }

    @Override
    public void setPoopLevel(int level) {
        this.poopLevel = Math.min(Math.max(level, 0), 100);
        if (this.poopLevel < 100) {
            this.hasFullWarningShown = false;
        }
    }

    @Override
    public void addPoopLevel(int amount) {
        this.setPoopLevel(this.poopLevel + amount);
    }

    @Override
    public int getDigestingLevel() {
        return this.digestingLevel;
    }

    @Override
    public void setDigestingLevel(int level) {
        this.digestingLevel = Math.max(0, level);
    }

    @Override
    public void addDigestingLevel(int amount) {
        this.setDigestingLevel(this.digestingLevel + amount);
    }

    @Override
    public void decreaseDigestingLevel(int amount) {
        this.setDigestingLevel(this.digestingLevel - amount);
    }

    @Override
    public int getMaxPoopLevel() {
        return 100;
    }

    @Override
    public boolean canPoop() {
        return this.poopLevel >= 10;
    }

    @Override
    public boolean isPoopFull() {
        return this.poopLevel >= 100;
    }

    @Override
    public boolean hasFullWarningShown() {
        return this.hasFullWarningShown;
    }

    @Override
    public void markFullWarningShown() {
        this.hasFullWarningShown = true;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("poopLevel", this.poopLevel);
        tag.m_128405_("digestingLevel", this.digestingLevel);
        tag.m_128379_("hasFullWarningShown", this.hasFullWarningShown);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.poopLevel = nbt.m_128451_("poopLevel");
        this.digestingLevel = nbt.m_128451_("digestingLevel");
        this.hasFullWarningShown = nbt.m_128471_("hasFullWarningShown");
    }
}

