/*
 * Decompiled with CFR 0.152.
 */
package com.qwsadd.qwsaddmod.entity;

import com.qwsadd.qwsaddmod.init.EntityInit;
import com.qwsadd.qwsaddmod.init.ItemInit;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public class PeeEntity
extends Entity {
    private static final EntityDataAccessor<Integer> DATA_LIFETIME_ID = SynchedEntityData.m_135353_(PeeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_OWNER_UUID_ID = SynchedEntityData.m_135353_(PeeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final int MAX_LIFE_TIME = 1200;

    public PeeEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public PeeEntity(Player owner) {
        this((EntityType)EntityInit.PEE_ENTITY.get(), owner.m_9236_());
        this.setOwner((LivingEntity)owner);
        this.m_6034_(owner.m_20185_() + owner.m_20154_().f_82479_ * 0.5, owner.m_20186_(), owner.m_20189_() + owner.m_20154_().f_82481_ * 0.5);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_LIFETIME_ID, (Object)1200);
        this.f_19804_.m_135372_(DATA_OWNER_UUID_ID, Optional.empty());
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82542_((double)0.98f, 1.0, (double)0.98f));
        int currentLifeTime = this.getLifeTime();
        if (currentLifeTime > 0) {
            this.setLifeTime(currentLifeTime - 1);
        }
        if (!this.m_9236_().f_46443_) {
            if (currentLifeTime <= 0) {
                this.m_146870_();
                return;
            }
            Optional<UUID> ownerUUID = this.getOwnerUUID();
            List nearbyEntities = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_());
            for (LivingEntity entity : nearbyEntities) {
                Player p;
                if (ownerUUID.isPresent() && entity.m_20148_().equals(ownerUUID.get()) || entity instanceof Player && ((p = (Player)entity).m_7500_() || p.m_5833_())) continue;
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 40, 0));
            }
        }
    }

    public int getLifeTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_LIFETIME_ID);
    }

    public void setLifeTime(int lifeTime) {
        this.f_19804_.m_135381_(DATA_LIFETIME_ID, (Object)lifeTime);
    }

    public Optional<UUID> getOwnerUUID() {
        return (Optional)this.f_19804_.m_135370_(DATA_OWNER_UUID_ID);
    }

    @Nullable
    public LivingEntity getOwner() {
        try {
            Level level;
            Optional<UUID> uuid = this.getOwnerUUID();
            if (uuid.isPresent() && (level = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                return (LivingEntity)serverLevel.m_8791_(uuid.get());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void setOwner(@Nullable LivingEntity owner) {
        this.f_19804_.m_135381_(DATA_OWNER_UUID_ID, Optional.ofNullable(owner).map(Entity::m_20148_));
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (!this.m_9236_().f_46443_ && !this.m_213877_()) {
            this.m_146870_();
        }
        return true;
    }

    public InteractionResult m_6096_(Player pPlayer, InteractionHand pHand) {
        ItemStack heldItem = pPlayer.m_21120_(pHand);
        if (heldItem.m_150930_(Items.f_42446_)) {
            if (!this.m_9236_().f_46443_) {
                pPlayer.m_5496_(SoundEvents.f_11781_, 1.0f, 1.0f);
                if (!pPlayer.m_150110_().f_35937_) {
                    heldItem.m_41774_(1);
                    pPlayer.m_150109_().m_36054_(new ItemStack((ItemLike)ItemInit.PEE_BUCKET.get()));
                }
                this.m_146870_();
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (heldItem.m_150930_(Items.f_42590_)) {
            if (!this.m_9236_().f_46443_) {
                pPlayer.m_5496_(SoundEvents.f_11770_, 1.0f, 1.0f);
                if (!pPlayer.m_150110_().f_35937_) {
                    heldItem.m_41774_(1);
                    pPlayer.m_150109_().m_36054_(new ItemStack((ItemLike)ItemInit.BOTTLE_OF_PEE.get()));
                }
                this.m_146870_();
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6096_(pPlayer, pHand);
    }

    protected void m_7378_(CompoundTag pCompound) {
        if (pCompound.m_128425_("LifeTime", 99)) {
            this.setLifeTime(pCompound.m_128451_("LifeTime"));
        }
        if (pCompound.m_128403_("Owner")) {
            this.f_19804_.m_135381_(DATA_OWNER_UUID_ID, Optional.of(pCompound.m_128342_("Owner")));
        }
    }

    protected void m_7380_(CompoundTag pCompound) {
        pCompound.m_128405_("LifeTime", this.getLifeTime());
        this.getOwnerUUID().ifPresent(uuid -> pCompound.m_128362_("Owner", uuid));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

