/*
 * Decompiled with CFR 0.152.
 */
package com.qwsadd.qwsaddmod.entity;

import com.qwsadd.qwsaddmod.init.EntityInit;
import com.qwsadd.qwsaddmod.init.ItemInit;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public class PoopEntity
extends Entity {
    private static final EntityDataAccessor<String> DATA_OWNER_NAME = SynchedEntityData.m_135353_(PoopEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private int lifeTime = 6000;
    private float health = 10.0f;

    public PoopEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public PoopEntity(Level level, double x, double y, double z) {
        this((EntityType)EntityInit.POOP_ENTITY.get(), level);
        this.m_6034_(x, y, z);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        float friction = 0.98f;
        if (this.m_20096_()) {
            friction = this.m_9236_().m_8055_(this.m_216999_()).m_60734_().m_49958_() * 0.98f;
        }
        this.m_20256_(this.m_20184_().m_82542_((double)friction, 1.0, (double)friction));
        if (!this.m_9236_().f_46443_ && this.lifeTime > 0) {
            --this.lifeTime;
        } else if (this.lifeTime <= 0) {
            this.m_6074_();
        }
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6094_() {
        return true;
    }

    public boolean m_5829_() {
        return true;
    }

    public InteractionResult m_6096_(Player pPlayer, InteractionHand pHand) {
        if (!this.m_9236_().f_46443_ && this.tryPickUp(pPlayer)) {
            this.m_5496_(SoundEvents.f_12470_, 1.0f, 1.0f);
            pPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 0));
            return InteractionResult.SUCCESS;
        }
        return super.m_6096_(pPlayer, pHand);
    }

    public boolean m_6097_() {
        return true;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_9236_().f_46443_ || this.m_213877_()) {
            return false;
        }
        this.health -= pAmount;
        this.m_5496_(SoundEvents.f_12468_, 1.0f, 1.0f);
        if (this.health <= 0.0f) {
            this.dieAndDrop();
        }
        return true;
    }

    public ItemStack m_142340_() {
        return this.createPoopItemStack();
    }

    private void dieAndDrop() {
        this.m_5496_(SoundEvents.f_12467_, 1.0f, 1.0f);
        if (!this.m_9236_().f_46443_) {
            ItemStack drop = this.createPoopItemStack();
            ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), drop);
            this.m_9236_().m_7967_((Entity)itemEntity);
        }
        this.m_6074_();
    }

    private boolean tryPickUp(Player player) {
        if (!this.m_213877_()) {
            ItemStack stack = this.createPoopItemStack();
            if (player.m_150109_().m_36054_(stack)) {
                this.m_6074_();
                return true;
            }
        }
        return false;
    }

    private ItemStack createPoopItemStack() {
        ItemStack poopItemStack = new ItemStack((ItemLike)ItemInit.POOP_ITEM.get());
        poopItemStack.m_41784_().m_128359_("OwnerName", this.getOwnerName());
        return poopItemStack;
    }

    public void setOwnerName(String name) {
        this.f_19804_.m_135381_(DATA_OWNER_NAME, (Object)name);
    }

    public String getOwnerName() {
        return (String)this.f_19804_.m_135370_(DATA_OWNER_NAME);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_OWNER_NAME, (Object)"");
    }

    protected void m_7378_(CompoundTag pCompound) {
        this.lifeTime = pCompound.m_128451_("LifeTime");
        this.setOwnerName(pCompound.m_128461_("OwnerName"));
        if (pCompound.m_128441_("Health")) {
            this.health = pCompound.m_128457_("Health");
        }
    }

    protected void m_7380_(CompoundTag pCompound) {
        pCompound.m_128405_("LifeTime", this.lifeTime);
        pCompound.m_128359_("OwnerName", this.getOwnerName());
        pCompound.m_128350_("Health", this.health);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

