/*
 * Decompiled with CFR 0.152.
 */
package com.qwsadd.qwsaddmod.events;

import com.qwsadd.qwsaddmod.QwsaddModMain;
import com.qwsadd.qwsaddmod.core.ModDamageTypes;
import com.qwsadd.qwsaddmod.entity.PoopEntity;
import com.qwsadd.qwsaddmod.init.ItemInit;
import com.qwsadd.qwsaddmod.network.PeeLevelPacket;
import com.qwsadd.qwsaddmod.network.PoopLevelPacket;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;

public class PlayerEvents {
    private static final int DIGESTION_INTERVAL = 100;
    private static final float DIGESTION_RATE = 0.25f;
    private static final int ABSORPTION_INTERVAL = 100;
    private static final float ABSORPTION_RATE = 0.15f;
    private static final int MINIMUM_DIGEST_AMOUNT = 1;
    private static final int MINIMUM_ABSORB_AMOUNT = 1;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().f_46443_) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.player;
        if (player.m_7500_() || player.m_5833_()) {
            return;
        }
        if (player.f_19797_ % 100 == 0) {
            player.getCapability(QwsaddModMain.POOP_CAPABILITY).ifPresent(poopCap -> {
                if (poopCap.getDigestingLevel() > 0) {
                    int amountToDigest = (int)((float)poopCap.getDigestingLevel() * 0.25f);
                    amountToDigest = Math.max(1, amountToDigest);
                    amountToDigest = Math.min(poopCap.getDigestingLevel(), amountToDigest);
                    poopCap.decreaseDigestingLevel(amountToDigest);
                    poopCap.addPoopLevel(amountToDigest);
                    if (poopCap.isPoopFull()) {
                        PlayerEvents.triggerIncontinencePenalty(player, "poop");
                    } else {
                        QwsaddModMain.NETWORK_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PoopLevelPacket(poopCap.getPoopLevel()));
                    }
                }
            });
        }
        if (player.f_19797_ % 100 == 0) {
            player.getCapability(QwsaddModMain.PEE_CAPABILITY).ifPresent(peeCap -> {
                if (peeCap.getAbsorbingLevel() > 0) {
                    int amountToAbsorb = (int)((float)peeCap.getAbsorbingLevel() * 0.15f);
                    amountToAbsorb = Math.max(1, amountToAbsorb);
                    amountToAbsorb = Math.min(peeCap.getAbsorbingLevel(), amountToAbsorb);
                    peeCap.decreaseAbsorbingLevel(amountToAbsorb);
                    peeCap.addPeeLevel(amountToAbsorb);
                    if (peeCap.isPeeFull()) {
                        PlayerEvents.triggerIncontinencePenalty(player, "pee");
                    } else {
                        QwsaddModMain.NETWORK_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PeeLevelPacket(peeCap.getPeeLevel()));
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        ServerPlayer player;
        block11: {
            block10: {
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof ServerPlayer)) break block10;
                player = (ServerPlayer)livingEntity;
                if (!player.m_9236_().f_46443_) break block11;
            }
            return;
        }
        if (player.m_7500_() || player.m_5833_()) {
            return;
        }
        ItemStack usedItem = event.getItem();
        Item item = usedItem.m_41720_();
        if (item == ItemInit.POOP_ITEM.get()) {
            PlayerEvents.grantAdvancementIfNotDone(player, "eat_poop");
        }
        if (item == ItemInit.PEE_BUCKET.get() || item == ItemInit.BOTTLE_OF_PEE.get()) {
            PlayerEvents.grantAdvancementIfNotDone(player, "drink_pee");
        }
        boolean waterAbsorbed = false;
        if (usedItem.m_41780_() == UseAnim.DRINK) {
            player.getCapability(QwsaddModMain.PEE_CAPABILITY).ifPresent(peeCap -> peeCap.addAbsorbingLevel(20));
            waterAbsorbed = true;
        }
        if (usedItem.m_41614_()) {
            FoodProperties foodProperties = usedItem.m_41720_().getFoodProperties(usedItem, (LivingEntity)player);
            if (foodProperties != null) {
                int nutrition = foodProperties.m_38744_();
                float saturation = foodProperties.m_38745_();
                int amountToAdd = (int)((float)nutrition * 2.5f + (float)nutrition * saturation);
                player.getCapability(QwsaddModMain.POOP_CAPABILITY).ifPresent(poopCap -> poopCap.addDigestingLevel(amountToAdd));
            }
            if (!waterAbsorbed) {
                player.getCapability(QwsaddModMain.PEE_CAPABILITY).ifPresent(peeCap -> peeCap.addAbsorbingLevel(20));
            }
        }
    }

    private static void triggerIncontinencePenalty(ServerPlayer player, String type) {
        MutableComponent message;
        DamageSource damageSource = ModDamageTypes.incontinence((Player)player);
        if ("pee".equals(type)) {
            PlayerEvents.grantAdvancementIfNotDone(player, "pee_incontinence");
            player.m_5496_(SoundEvents.f_12277_, 1.0f, 1.0f);
            player.getCapability(QwsaddModMain.PEE_CAPABILITY).ifPresent(cap -> {
                cap.setPeeLevel(0);
                QwsaddModMain.NETWORK_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PeeLevelPacket(0));
            });
            player.m_6469_(damageSource, player.m_21233_() * 0.75f);
            message = Component.m_237110_((String)"message.qwsaddmod.pee_incontinence_broadcast", (Object[])new Object[]{player.m_5446_()});
        } else if ("poop".equals(type)) {
            PlayerEvents.grantAdvancementIfNotDone(player, "poop_incontinence");
            PoopEntity poopEntity = new PoopEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_());
            poopEntity.setOwnerName(player.m_36316_().getName());
            player.m_9236_().m_7967_((Entity)poopEntity);
            player.m_5496_(SoundEvents.f_12388_, 1.0f, 0.8f);
            player.getCapability(QwsaddModMain.POOP_CAPABILITY).ifPresent(cap -> {
                cap.setPoopLevel(0);
                QwsaddModMain.NETWORK_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PoopLevelPacket(0));
            });
            player.m_6469_(damageSource, player.m_21233_() * 0.9f);
            message = Component.m_237110_((String)"message.qwsaddmod.poop_incontinence_broadcast", (Object[])new Object[]{player.m_5446_()});
        } else {
            return;
        }
        if (player.m_20194_() != null) {
            player.m_20194_().m_6846_().m_240416_((Component)message, false);
        }
    }

    private static void grantAdvancementIfNotDone(ServerPlayer player, String advancementId) {
        AdvancementProgress progress;
        if (player.m_20194_() == null) {
            return;
        }
        ResourceLocation res = ResourceLocation.fromNamespaceAndPath((String)"qwsaddmod", (String)advancementId);
        Advancement advancement = player.m_20194_().m_129889_().m_136041_(res);
        if (advancement != null && !(progress = player.m_8960_().m_135996_(advancement)).m_8193_()) {
            for (String criterion : progress.m_8219_()) {
                player.m_8960_().m_135988_(advancement, criterion);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            Player originalPlayer = event.getOriginal();
            Player newPlayer = event.getEntity();
            originalPlayer.getCapability(QwsaddModMain.POOP_CAPABILITY).ifPresent(oldCap -> newPlayer.getCapability(QwsaddModMain.POOP_CAPABILITY).ifPresent(newCap -> newCap.deserializeNBT((Tag)((CompoundTag)oldCap.serializeNBT()))));
            originalPlayer.getCapability(QwsaddModMain.PEE_CAPABILITY).ifPresent(oldCap -> newPlayer.getCapability(QwsaddModMain.PEE_CAPABILITY).ifPresent(newCap -> newCap.deserializeNBT(oldCap.serializeNBT())));
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PlayerEvents.syncPlayerCapabilities(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PlayerEvents.syncPlayerCapabilities(serverPlayer);
        }
    }

    private static void syncPlayerCapabilities(ServerPlayer player) {
        player.getCapability(QwsaddModMain.POOP_CAPABILITY).ifPresent(cap -> QwsaddModMain.NETWORK_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PoopLevelPacket(cap.getPoopLevel())));
        player.getCapability(QwsaddModMain.PEE_CAPABILITY).ifPresent(cap -> QwsaddModMain.NETWORK_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PeeLevelPacket(cap.getPeeLevel())));
    }
}

