/*
 * Decompiled with CFR 0.152.
 */
package com.qwsadd.qwsaddmod.network;

import com.qwsadd.qwsaddmod.QwsaddModMain;
import com.qwsadd.qwsaddmod.entity.PoopEntity;
import com.qwsadd.qwsaddmod.network.PoopLevelPacket;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class PoopActionPacket {
    public static void encode(PoopActionPacket msg, FriendlyByteBuf buf) {
    }

    public static PoopActionPacket decode(FriendlyByteBuf buf) {
        return new PoopActionPacket();
    }

    public static void handle(PoopActionPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            player.getCapability(QwsaddModMain.POOP_CAPABILITY).ifPresent(cap -> {
                if (cap.canPoop()) {
                    int newLevel = Math.max(cap.getPoopLevel() - 25, 0);
                    cap.setPoopLevel(newLevel);
                    QwsaddModMain.NETWORK_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PoopLevelPacket(newLevel));
                    PoopEntity poopEntity = new PoopEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_());
                    poopEntity.setOwnerName(player.m_5446_().getString());
                    player.m_9236_().m_7967_((Entity)poopEntity);
                    player.m_5496_(SoundEvents.f_12278_, 1.0f, 0.8f);
                } else {
                    player.m_213846_((Component)Component.m_237115_((String)"message.qwsaddmod.cannot_poop"));
                }
            });
        });
        ctx.get().setPacketHandled(true);
    }
}

