/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.petsdun.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import net.mcreator.petsdun.procedures.HellishDisplayProcedure;
import net.mcreator.petsdun.world.inventory.StariHellishGuiMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class StariHellishGuiScreen
extends AbstractContainerScreen<StariHellishGuiMenu> {
    private static final HashMap<String, Object> guistate = StariHellishGuiMenu.guistate;
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private static final ResourceLocation texture = ResourceLocation.parse((String)"pets_dun:textures/screens/stari_hellish_gui.png");

    public StariHellishGuiScreen(StariHellishGuiMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 300;
        this.imageHeight = 180;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        Entity entity = HellishDisplayProcedure.execute((LevelAccessor)this.world, (Entity)this.entity);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.renderEntityInInventoryFollowsAngle(guiGraphics, this.leftPos + 51, this.topPos + 115, 65, 0.0f + (float)Math.atan((double)(this.leftPos + 51 - mouseX) / 40.0), (float)Math.atan((double)(this.topPos + 66 - mouseY) / 40.0), livingEntity);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(RenderType::guiTextured, texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        guiGraphics.blit(RenderType::guiTextured, ResourceLocation.parse((String)"pets_dun:textures/screens/rarity_legend.png"), this.leftPos + 113, this.topPos + -13, 0.0f, 0.0f, 64, 64, 64, 64);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        return super.keyPressed(key, b, c);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.pets_dun.stari_hellish_gui.label_cactus_stari"), 14, 5, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.pets_dun.stari_hellish_gui.label_has_builtin_thorns_and_also_ran"), 113, 32, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.pets_dun.stari_hellish_gui.label_only_when_touching_water"), 122, 41, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.pets_dun.stari_hellish_gui.label_immune_to_marine_hate"), 113, 59, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.pets_dun.stari_hellish_gui.label_for_11_seconds"), 122, 68, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.pets_dun.stari_hellish_gui.label_gives_absorption_ii_to_allies"), 113, 86, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.pets_dun.stari_hellish_gui.label_for_29_seconds"), 122, 95, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.pets_dun.stari_hellish_gui.label_only_when_above_half_hp"), 122, 104, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.pets_dun.stari_hellish_gui.label_gains_regeneration_ii"), 113, 122, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.pets_dun.stari_hellish_gui.label_for_20_seconds"), 122, 131, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.pets_dun.stari_hellish_gui.label_only_when_below_half_hp"), 122, 140, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.pets_dun.stari_hellish_gui.label_immune_to_burning"), 113, 158, -12829636, false);
    }

    public void init() {
        super.init();
    }

    private void renderEntityInInventoryFollowsAngle(GuiGraphics guiGraphics, int x, int y, int scale, float angleXComponent, float angleYComponent, LivingEntity entity) {
        Quaternionf pose = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf cameraOrientation = new Quaternionf().rotateX(angleYComponent * 20.0f * ((float)Math.PI / 180));
        pose.mul((Quaternionfc)cameraOrientation);
        float f2 = entity.yBodyRot;
        float f3 = entity.getYRot();
        float f4 = entity.getXRot();
        float f5 = entity.yHeadRotO;
        float f6 = entity.yHeadRot;
        entity.yBodyRot = 180.0f + angleXComponent * 20.0f;
        entity.setYRot(180.0f + angleXComponent * 40.0f);
        entity.setXRot(-angleYComponent * 20.0f);
        entity.yHeadRot = entity.getYRot();
        entity.yHeadRotO = entity.getYRot();
        InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (float)x, (float)y, (float)scale, (Vector3f)new Vector3f(0.0f, 0.0f, 0.0f), (Quaternionf)pose, (Quaternionf)cameraOrientation, (LivingEntity)entity);
        entity.yBodyRot = f2;
        entity.setYRot(f3);
        entity.setXRot(f4);
        entity.yHeadRotO = f5;
        entity.yHeadRot = f6;
    }
}

