/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.petsdun.procedures;

import java.util.Comparator;
import net.mcreator.petsdun.init.PetsDunModEntities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ShadelingFakelookOnEntityTickUpdateProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        if (!world.getEntitiesOfClass(Player.class, new AABB(Vec3.ZERO, Vec3.ZERO).move(new Vec3(x, y, z)).inflate(2.5), e -> true).isEmpty() && !(ShadelingFakelookOnEntityTickUpdateProcedure.getEntityGameType(ShadelingFakelookOnEntityTickUpdateProcedure.findEntityInWorldRange(world, Player.class, x, y, z, 5.0)) == GameType.CREATIVE)) {
            if (!entity.level().isClientSide()) {
                entity.discard();
            }
            if (world instanceof ServerLevel) {
                ServerLevel _level = (ServerLevel)world;
                Entity entityToSpawn = ((EntityType)PetsDunModEntities.SHADELING_FAKELOOK_MONSTER.get()).spawn(_level, BlockPos.containing((double)x, (double)y, (double)z), EntitySpawnReason.MOB_SUMMONED);
                if (entityToSpawn != null) {
                    entityToSpawn.setYRot(world.getRandom().nextFloat() * 360.0f);
                }
            }
        }
    }

    private static Entity findEntityInWorldRange(LevelAccessor world, Class<? extends Entity> clazz, double x, double y, double z, double range) {
        return world.getEntitiesOfClass(clazz, AABB.ofSize((Vec3)new Vec3(x, y, z), (double)range, (double)range, (double)range), e -> true).stream().sorted(Comparator.comparingDouble(e -> e.distanceToSqr(x, y, z))).findFirst().orElse(null);
    }

    private static GameType getEntityGameType(Entity entity) {
        PlayerInfo playerInfo;
        Player player;
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            return serverPlayer.gameMode.getGameModeForPlayer();
        }
        if (entity instanceof Player && (player = (Player)entity).level().isClientSide() && (playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo(player.getGameProfile().getId())) != null) {
            return playerInfo.getGameMode();
        }
        return null;
    }
}

