/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.vintage.compat.kubejs.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.recipe.BlockTagIngredient;
import dev.latvian.mods.kubejs.create.CreateInputFluid;
import dev.latvian.mods.kubejs.create.platform.FluidIngredientHelper;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.fluid.InputFluid;
import dev.latvian.mods.kubejs.fluid.OutputFluid;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.item.ingredient.TagContext;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.FluidComponents;
import dev.latvian.mods.kubejs.recipe.component.NumberComponent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import dev.latvian.mods.kubejs.util.MapJS;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;

public interface LaserRecipeSchema {
    public static final RecipeKey<Either<OutputFluid, OutputItem>[]> RESULTS = FluidComponents.OUTPUT_OR_ITEM_ARRAY.key("results");
    public static final RecipeKey<Either<InputFluid, InputItem>[]> INGREDIENTS = FluidComponents.INPUT_OR_ITEM_ARRAY.key("ingredients");
    public static final RecipeKey<Integer> ENERGY_COST = NumberComponent.IntRange.INT.key("energy").optional((Object)1000);
    public static final RecipeKey<Integer> MAX_CHARGE_RATE = NumberComponent.IntRange.INT.key("maxChargeRate").optional((Object)100);
    public static final RecipeSchema LASER_PROCESSING = new RecipeSchema(ProcessingRecipeJS.class, ProcessingRecipeJS::new, new RecipeKey[]{RESULTS, INGREDIENTS, ENERGY_COST, MAX_CHARGE_RATE});

    public static class ProcessingRecipeJS
    extends RecipeJS {
        public InputFluid readInputFluid(Object from) {
            if (from instanceof CreateInputFluid) {
                CreateInputFluid fluid = (CreateInputFluid)from;
                return fluid;
            }
            if (from instanceof FluidIngredient) {
                FluidIngredient fluid = (FluidIngredient)from;
                return new CreateInputFluid(fluid);
            }
            if (from instanceof FluidStackJS) {
                FluidStackJS fluid = (FluidStackJS)from;
                return new CreateInputFluid(FluidIngredientHelper.toFluidIngredient((FluidStackJS)fluid));
            }
            if (from instanceof FluidStack) {
                FluidStack fluid = (FluidStack)from;
                return new CreateInputFluid(FluidIngredient.fromFluidStack((FluidStack)fluid));
            }
            JsonObject json = MapJS.json((Object)from);
            if (json != null) {
                return new CreateInputFluid(FluidIngredient.deserialize((JsonElement)json));
            }
            return CreateInputFluid.EMPTY;
        }

        public JsonElement writeInputFluid(InputFluid value) {
            if (value instanceof CreateInputFluid) {
                CreateInputFluid fluid = (CreateInputFluid)value;
                return fluid.ingredient().serialize();
            }
            if (value instanceof FluidIngredient) {
                FluidIngredient fluid = (FluidIngredient)value;
                return fluid.serialize();
            }
            if (value instanceof FluidStackJS) {
                FluidStackJS fluid = (FluidStackJS)value;
                return FluidIngredientHelper.toFluidIngredient((FluidStackJS)fluid).serialize();
            }
            return FluidIngredient.EMPTY.serialize();
        }

        public boolean inputItemHasPriority(Object from) {
            if (from instanceof InputItem || from instanceof Ingredient || from instanceof ItemStack) {
                return true;
            }
            InputItem input = this.readInputItem(from);
            Ingredient ingredient = input.ingredient;
            if (ingredient instanceof BlockTagIngredient) {
                BlockTagIngredient blockTag = (BlockTagIngredient)ingredient;
                return !((TagContext)TagContext.INSTANCE.getValue()).isEmpty(blockTag.getTag());
            }
            return !input.isEmpty();
        }

        public boolean inputFluidHasPriority(Object from) {
            return from instanceof InputFluid || FluidIngredient.isFluidIngredient((JsonElement)MapJS.json((Object)from));
        }

        public OutputItem readOutputItem(Object from) {
            JsonObject j;
            if (from instanceof ProcessingOutput) {
                ProcessingOutput output = (ProcessingOutput)from;
                return OutputItem.of((ItemStack)output.getStack(), (double)output.getChance());
            }
            OutputItem outputItem = super.readOutputItem(from);
            if (from instanceof JsonObject && (j = (JsonObject)from).has("chance")) {
                return outputItem.withChance((double)j.get("chance").getAsFloat());
            }
            return outputItem;
        }

        public RecipeJS energyCost(int energy) {
            return this.setValue(ENERGY_COST, energy);
        }

        public RecipeJS maxChargeRate(int energy) {
            return this.setValue(MAX_CHARGE_RATE, energy);
        }
    }
}

