/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.vintage.content.kinetics.centrifuge;

import com.google.gson.JsonObject;
import com.simibubi.create.compat.jei.category.sequencedAssembly.SequencedAssemblySubCategory;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.sequenced.IAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import dev.bluephs.vintage.VintageBlocks;
import dev.bluephs.vintage.VintageLang;
import dev.bluephs.vintage.VintageRecipes;
import dev.bluephs.vintage.compat.jei.category.assemblies.AssemblyCentrifugation;
import dev.bluephs.vintage.content.kinetics.centrifuge.CentrifugeBlockEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class CentrifugationRecipe
extends ProcessingRecipe<SmartInventory>
implements IAssemblyRecipe {
    int minimalRPM;

    public static boolean match(CentrifugeBlockEntity centrifuge, Recipe<?> recipe) {
        return CentrifugationRecipe.apply(centrifuge, recipe, true);
    }

    public static boolean apply(CentrifugeBlockEntity centrifuge, Recipe<?> recipe) {
        return CentrifugationRecipe.apply(centrifuge, recipe, false);
    }

    private static boolean apply(CentrifugeBlockEntity centrifuge, Recipe<?> recipe, boolean test) {
        IItemHandlerModifiable availableItems = (IItemHandlerModifiable)centrifuge.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        IFluidHandler availableFluids = (IFluidHandler)centrifuge.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
        if (availableItems == null || availableFluids == null) {
            return false;
        }
        ArrayList<ItemStack> recipeOutputItems = new ArrayList<ItemStack>();
        ArrayList<FluidStack> recipeOutputFluids = new ArrayList<FluidStack>();
        LinkedList ingredients = new LinkedList(recipe.m_7527_());
        NonNullList fluidIngredients = ((CentrifugationRecipe)recipe).getFluidIngredients();
        for (boolean simulate : Iterate.trueAndFalse) {
            if (!simulate && test) {
                return true;
            }
            int[] extractedItemsFromSlot = new int[availableItems.getSlots()];
            int[] extractedFluidsFromTank = new int[availableFluids.getTanks()];
            for (int i = 0; i < ingredients.size(); ++i) {
                int slot;
                block12: {
                    Ingredient ingredient = (Ingredient)ingredients.get(i);
                    for (slot = 0; slot < availableItems.getSlots(); ++slot) {
                        ItemStack extracted;
                        if (simulate && availableItems.getStackInSlot(slot).m_41613_() <= extractedItemsFromSlot[slot] || !ingredient.test(extracted = availableItems.getStackInSlot(slot))) continue;
                        if (!simulate) {
                            extracted.m_41774_(1);
                        }
                        break block12;
                    }
                    return false;
                }
                int n = slot;
                extractedItemsFromSlot[n] = extractedItemsFromSlot[n] + 1;
            }
            boolean fluidsAffected = false;
            for (int i = 0; i < fluidIngredients.size(); ++i) {
                int drainedAmount;
                int tank;
                block13: {
                    FluidIngredient fluidIngredient = (FluidIngredient)fluidIngredients.get(i);
                    int amountRequired = fluidIngredient.getRequiredAmount();
                    for (tank = 0; tank < availableFluids.getTanks(); ++tank) {
                        FluidStack fluidStack = availableFluids.getFluidInTank(tank);
                        if (simulate && fluidStack.getAmount() <= extractedFluidsFromTank[tank] || !fluidIngredient.test(fluidStack)) continue;
                        drainedAmount = Math.min(amountRequired, fluidStack.getAmount());
                        if (!simulate) {
                            fluidStack.shrink(drainedAmount);
                            fluidsAffected = true;
                        }
                        if ((amountRequired -= drainedAmount) != 0) {
                            continue;
                        }
                        break block13;
                    }
                    return false;
                }
                int n = tank;
                extractedFluidsFromTank[n] = extractedFluidsFromTank[n] + drainedAmount;
            }
            if (fluidsAffected) {
                ((SmartFluidTankBehaviour)centrifuge.getBehaviour(SmartFluidTankBehaviour.INPUT)).forEach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
                ((SmartFluidTankBehaviour)centrifuge.getBehaviour(SmartFluidTankBehaviour.OUTPUT)).forEach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
            }
            if (simulate && recipe instanceof CentrifugationRecipe) {
                CentrifugationRecipe centrifugeRecipe = (CentrifugationRecipe)recipe;
                recipeOutputItems.addAll(centrifugeRecipe.rollResults());
                recipeOutputFluids.addAll((Collection<FluidStack>)centrifugeRecipe.getFluidResults());
                recipeOutputItems.addAll((Collection<ItemStack>)centrifugeRecipe.m_7457_((Container)centrifuge.getInputInventory()));
            }
            if (centrifuge.acceptOutputs(recipeOutputItems, recipeOutputFluids, simulate)) continue;
            return false;
        }
        return true;
    }

    public CentrifugationRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super((IRecipeTypeInfo)VintageRecipes.CENTRIFUGATION, params);
    }

    protected int getMaxInputCount() {
        return 9;
    }

    protected int getMaxOutputCount() {
        return 4;
    }

    protected int getMaxFluidInputCount() {
        return 2;
    }

    protected int getMaxFluidOutputCount() {
        return 2;
    }

    protected boolean canSpecifyDuration() {
        return true;
    }

    public boolean matches(SmartInventory inv, @Nonnull Level worldIn) {
        if (inv.m_7983_()) {
            return false;
        }
        if (this.ingredients.isEmpty()) {
            return !this.fluidIngredients.isEmpty();
        }
        for (Ingredient ingredient : this.ingredients) {
            if (inv.m_18947_(ingredient.m_43908_()[0].m_41720_()) >= ingredient.m_43908_().length) continue;
            return false;
        }
        return true;
    }

    public void addAssemblyIngredients(List<Ingredient> list) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getDescriptionForAssembly() {
        int startNum;
        MutableComponent result = VintageLang.translateDirect("recipe.assembly.centrifugation", new Object[0]);
        if (this.ingredients.size() <= 1 && this.fluidIngredients.isEmpty()) {
            return result;
        }
        result.m_130946_(" ").m_7220_((Component)VintageLang.translateDirect("recipe.assembly.with", new Object[0])).m_130946_(" ");
        if (this.ingredients.size() > 1) {
            if (((Ingredient)this.ingredients.get(1)).m_43908_().length > 0) {
                result.m_7220_(((Ingredient)this.ingredients.get(1)).m_43908_()[0].m_41720_().m_41466_());
            }
        } else if (!this.fluidIngredients.isEmpty() && !((FluidIngredient)this.fluidIngredients.get(0)).getMatchingFluidStacks().isEmpty()) {
            result.m_7220_(((FluidStack)((FluidIngredient)this.fluidIngredients.get(0)).getMatchingFluidStacks().get(0)).getDisplayName());
        }
        if (this.ingredients.size() > 2) {
            for (int i = 2; i < this.ingredients.size() - 1; ++i) {
                if (((Ingredient)this.ingredients.get(i)).m_43908_().length <= 0) continue;
                result.m_130946_(", ").m_7220_(((Ingredient)this.ingredients.get(i)).m_43908_()[0].m_41720_().m_41466_());
            }
            if (((Ingredient)this.ingredients.get(this.ingredients.size() - 1)).m_43908_().length > 0) {
                if (this.fluidIngredients.isEmpty()) {
                    result.m_130946_(" ").m_7220_((Component)VintageLang.translateDirect("recipe.assembly.and", new Object[0]).m_130946_(" ").m_7220_(((Ingredient)this.ingredients.get(this.ingredients.size() - 1)).m_43908_()[0].m_41720_().m_41466_()));
                } else {
                    result.m_130946_(", ").m_7220_(((Ingredient)this.ingredients.get(this.ingredients.size() - 1)).m_43908_()[0].m_41720_().m_41466_());
                }
            }
        }
        int n = startNum = this.ingredients.size() > 1 ? 0 : 1;
        if (this.fluidIngredients.size() > startNum) {
            for (int i = startNum; i < this.fluidIngredients.size() - 1; ++i) {
                if (((FluidIngredient)this.fluidIngredients.get(i)).getMatchingFluidStacks().isEmpty()) continue;
                result.m_130946_(", ").m_7220_(((FluidStack)((FluidIngredient)this.fluidIngredients.get(i)).getMatchingFluidStacks().get(0)).getDisplayName());
            }
            if (!((FluidIngredient)this.fluidIngredients.get(this.fluidIngredients.size() - 1)).getMatchingFluidStacks().isEmpty()) {
                result.m_130946_(" ").m_7220_((Component)VintageLang.translateDirect("recipe.assembly.and", new Object[0]).m_130946_(" ").m_7220_(((FluidStack)((FluidIngredient)this.fluidIngredients.get(this.fluidIngredients.size() - 1)).getMatchingFluidStacks().get(0)).getDisplayName()));
            }
        }
        return result;
    }

    public void addRequiredMachines(Set<ItemLike> list) {
        list.add((ItemLike)VintageBlocks.CENTRIFUGE.get());
    }

    public Supplier<Supplier<SequencedAssemblySubCategory>> getJEISubCategory() {
        return () -> AssemblyCentrifugation::new;
    }

    public void readAdditional(JsonObject json) {
        this.minimalRPM = json.has("minimalRPM") ? json.get("minimalRPM").getAsInt() : 100;
    }

    public void readAdditional(FriendlyByteBuf buffer) {
        this.minimalRPM = buffer.readInt();
    }

    public void writeAdditional(JsonObject json) {
        json.addProperty("minimalRPM", (Number)this.minimalRPM);
    }

    public void writeAdditional(FriendlyByteBuf buffer) {
        buffer.writeInt(this.minimalRPM);
    }

    public int getMinimalRPM() {
        return this.minimalRPM;
    }
}

