/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.vintage.content.kinetics.helve_hammer;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.bluephs.vintage.VintageItems;
import dev.bluephs.vintage.VintageLang;
import dev.bluephs.vintage.VintageRecipes;
import dev.bluephs.vintage.VintageRecipesList;
import dev.bluephs.vintage.content.kinetics.helve_hammer.HammeringRecipe;
import dev.bluephs.vintage.content.kinetics.helve_hammer.HelveBlock;
import dev.bluephs.vintage.content.kinetics.helve_hammer.HelveKineticBlockEntity;
import dev.bluephs.vintage.foundation.advancement.VintageAdvancementBehaviour;
import dev.bluephs.vintage.foundation.advancement.VintageAdvancements;
import dev.bluephs.vintage.infrastructure.config.VintageConfig;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class HelveBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public SmartInventory inputInv = new SmartInventory(3, (SyncedBlockEntity)this);
    public SmartInventory bufInv = new SmartInventory(3, (SyncedBlockEntity)this);
    public SmartInventory outputInv = new SmartInventory(3, (SyncedBlockEntity)this);
    public LazyOptional<IItemHandlerModifiable> capability = LazyOptional.of(() -> new HelveInventoryHandler(new IItemHandlerModifiable[]{this.inputInv, this.outputInv}));
    public int timer;
    public int hammerBlows = 0;
    private SmithingRecipe lastSmithingRecipe;
    private HammeringRecipe lastHammeringRecipe;
    boolean lastRecipeIsAssembly;
    private boolean contentsChanged;
    private static final Object hammeringRecipesKey = new Object();
    private int operatingMode = 0;
    Block anvilBlock = Blocks.f_50016_;
    VintageAdvancementBehaviour advancementBehaviour;
    private int blockedSlots = 0;
    public static final TagKey<Item> customAnvilTag = ItemTags.create((ResourceLocation)new ResourceLocation("vintage", "custom_hammering_blocks"));
    public static final TagKey<Item> anvilTag = ItemTags.create((ResourceLocation)new ResourceLocation("vintage", "anvils"));

    public HelveBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void resetRecipes() {
        this.lastHammeringRecipe = null;
        this.lastSmithingRecipe = null;
        this.timer = 0;
        this.hammerBlows = 0;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this));
        this.advancementBehaviour = new VintageAdvancementBehaviour(this);
        behaviours.add(this.advancementBehaviour);
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("Timer", this.timer);
        compound.m_128405_("HammerBlows", this.hammerBlows);
        compound.m_128365_("InputInventory", (Tag)this.inputInv.serializeNBT());
        compound.m_128365_("OutputInventory", (Tag)this.outputInv.serializeNBT());
        compound.m_128379_("LastRecipeIsAssembly", this.lastRecipeIsAssembly);
        compound.m_128405_("BlockedSlots", this.blockedSlots);
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.timer = compound.m_128451_("Timer");
        this.hammerBlows = compound.m_128451_("HammerBlows");
        this.inputInv.deserializeNBT(compound.m_128469_("InputInventory"));
        this.outputInv.deserializeNBT(compound.m_128469_("OutputInventory"));
        this.lastRecipeIsAssembly = compound.m_128471_("LastRecipeIsAssembly");
        this.blockedSlots = compound.m_128451_("BlockedSlots");
    }

    public boolean addBlockedSlots() {
        if (this.blockedSlots >= 2) {
            return false;
        }
        ++this.blockedSlots;
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.inputInv);
        this.inputInv = new SmartInventory(3 - this.blockedSlots, (SyncedBlockEntity)this);
        this.capability = LazyOptional.of(() -> new HelveInventoryHandler(new IItemHandlerModifiable[]{this.inputInv, this.outputInv}));
        this.resetRecipes();
        return true;
    }

    public int getBlockedSlots() {
        return this.blockedSlots;
    }

    public ItemStack resetBlockedSlots() {
        if (this.blockedSlots <= 0) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = new ItemStack((ItemLike)VintageItems.HELVE_HAMMER_SLOT_COVER.get(), this.blockedSlots);
        this.blockedSlots = 0;
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.inputInv);
        this.inputInv = new SmartInventory(3, (SyncedBlockEntity)this);
        this.capability = LazyOptional.of(() -> new HelveInventoryHandler(new IItemHandlerModifiable[]{this.inputInv, this.outputInv}));
        this.resetRecipes();
        return itemStack;
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82400_(1.0);
    }

    private void changeMode(int mode) {
        if (this.operatingMode == mode) {
            return;
        }
        this.operatingMode = mode;
        this.lastSmithingRecipe = null;
        this.lastHammeringRecipe = null;
        this.timer = 0;
        this.hammerBlows = 0;
        if (mode == 0) {
            ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_.m_7495_(), (IItemHandler)this.inputInv);
            ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_.m_7495_(), (IItemHandler)this.outputInv);
            this.inputInv.m_6211_();
            this.outputInv.m_6211_();
        }
    }

    public float getHammerAngle() {
        if (this.timer <= 0) {
            return 0.0f;
        }
        if (this.operatingMode > 0 && (this.operatingMode == 2 && this.lastSmithingRecipe != null || this.operatingMode == 1 && this.lastHammeringRecipe != null)) {
            if (this.timer > 25) {
                return -25.0f + (float)this.timer / 20.0f;
            }
            return (float)this.timer * -1.0f;
        }
        return 0.0f;
    }

    protected void spawnEventParticles(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return;
        }
        Object particleData = null;
        particleData = stack.m_41720_() instanceof BlockItem ? new BlockParticleOption(ParticleTypes.f_123794_, ((BlockItem)stack.m_41720_()).m_40614_().m_49966_()) : new ItemParticleOption(ParticleTypes.f_123752_, stack);
        RandomSource r = this.f_58857_.f_46441_;
        Vec3 v = VecHelper.getCenterOf((Vec3i)this.f_58858_).m_82520_(0.0, -0.5, 0.0);
        for (int i = 0; i < 10; ++i) {
            Vec3 m = VecHelper.offsetRandomly((Vec3)new Vec3(0.0, 0.25, 0.0), (RandomSource)r, (float)0.125f);
            this.f_58857_.m_7106_((ParticleOptions)particleData, v.f_82479_, v.f_82480_, v.f_82481_, m.f_82479_, m.f_82480_, m.f_82480_);
        }
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.m_8055_(this.f_58858_.m_7495_()).m_60734_() instanceof AnvilBlock || this.f_58857_.m_8055_(this.f_58858_.m_7495_()).m_60734_().m_5456_().m_7968_().m_204117_(anvilTag)) {
            this.changeMode(1);
            this.anvilBlock = Blocks.f_50016_;
        } else if (this.f_58857_.m_8055_(this.f_58858_.m_7495_()).m_60734_().m_5456_().m_7968_().m_204117_(customAnvilTag)) {
            this.changeMode(1);
            this.anvilBlock = this.f_58857_.m_8055_(this.f_58858_.m_7495_()).m_60734_();
        } else if (this.f_58857_.m_8055_(this.f_58858_.m_7495_()).m_60713_(Blocks.f_50625_)) {
            this.changeMode(2);
            this.anvilBlock = Blocks.f_50016_;
        } else {
            this.changeMode(0);
            this.anvilBlock = Blocks.f_50016_;
        }
        if (this.operatingMode == 1) {
            int i;
            for (i = 0; i < this.outputInv.getSlots(); ++i) {
                if (this.outputInv.getStackInSlot(i).m_41613_() != this.outputInv.getSlotLimit(i)) continue;
                return;
            }
            if (this.timer > 0) {
                if (this.getSpeed() == 0.0f) {
                    this.timer = 0;
                    this.lastHammeringRecipe = null;
                }
                if (this.lastHammeringRecipe != null) {
                    this.timer -= this.getProcessingSpeed();
                    if (this.f_58857_.f_46443_ && this.timer > 0 && this.timer - this.getProcessingSpeed() <= 0) {
                        this.spawnEventParticles(this.inputInv.getStackInSlot(0));
                        AllSoundEvents.MECHANICAL_PRESS_ACTIVATION.playAt(this.f_58857_, (Vec3i)this.f_58858_, 3.0f, 1.0f, true);
                        return;
                    }
                    if (this.timer <= 0) {
                        --this.hammerBlows;
                        if (this.hammerBlows <= 0) {
                            this.process();
                            this.lastHammeringRecipe = null;
                            this.sendData();
                        } else {
                            this.timer = 500;
                        }
                    }
                    return;
                }
            }
            if (this.inputInv.m_7983_()) {
                return;
            }
            if (this.lastHammeringRecipe == null || !HammeringRecipe.match(this, this.lastHammeringRecipe)) {
                Recipe<?> assemblyRecipe;
                for (i = 0; i < this.inputInv.getSlots(); ++i) {
                    assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.f_58857_, (ItemStack)this.inputInv.getStackInSlot(i), VintageRecipes.HAMMERING.getType(), HammeringRecipe.class);
                    if (!assemblyRecipe.isPresent()) continue;
                    boolean found = true;
                    for (Ingredient cur : ((HammeringRecipe)((Object)assemblyRecipe.get())).m_7527_()) {
                        boolean find = false;
                        for (ItemStack item : cur.m_43908_()) {
                            if (item.m_41613_() > this.inputInv.m_18947_(item.m_41720_())) continue;
                            find = true;
                            break;
                        }
                        found = find;
                    }
                    if (!found) continue;
                    this.lastHammeringRecipe = (HammeringRecipe)((Object)assemblyRecipe.get());
                    this.timer = 500;
                    this.hammerBlows = ((HammeringRecipe)((Object)assemblyRecipe.get())).hammerBlows;
                    this.lastRecipeIsAssembly = true;
                    this.sendData();
                    return;
                }
                this.lastRecipeIsAssembly = false;
                if (!this.getRecipes().isEmpty()) {
                    assemblyRecipe = this.getRecipes().get(0);
                    if (assemblyRecipe instanceof HammeringRecipe) {
                        HammeringRecipe hammering;
                        this.lastHammeringRecipe = hammering = (HammeringRecipe)assemblyRecipe;
                        this.timer = 500;
                        this.hammerBlows = hammering.hammerBlows;
                        this.sendData();
                    }
                    return;
                }
            }
        } else if (this.operatingMode == 2) {
            if (this.f_58857_.f_46443_ && this.timer > 0 && this.timer - this.getProcessingSpeed() * 2 <= 0) {
                this.spawnEventParticles(this.inputInv.getStackInSlot(0));
                AllSoundEvents.MECHANICAL_PRESS_ACTIVATION.playAt(this.f_58857_, (Vec3i)this.f_58858_, 3.0f, 1.0f, true);
            }
            int slots = 0;
            for (int i = 0; i < this.inputInv.getSlots(); ++i) {
                if (this.inputInv.getStackInSlot(i).m_41619_()) continue;
                ++slots;
            }
            if (this.lastSmithingRecipe == null && slots >= ((Boolean)VintageConfig.server().recipes.allowTemplatelessRecipes.get() != false ? 2 : 3) && this.getSpeed() != 0.0f) {
                for (SmithingRecipe recipe : VintageRecipesList.getSmithing()) {
                    boolean template = false;
                    boolean base = false;
                    boolean addition = false;
                    for (int i = 0; i < this.inputInv.getSlots(); ++i) {
                        ItemStack item = this.inputInv.getStackInSlot(i);
                        if (recipe.m_266166_(item) || ((Boolean)VintageConfig.server().recipes.allowTemplatelessRecipes.get()).booleanValue() && recipe.m_266166_(ItemStack.f_41583_)) {
                            template = true;
                        }
                        if (recipe.m_266343_(item)) {
                            base = true;
                        }
                        if (!recipe.m_266253_(item)) continue;
                        addition = true;
                    }
                    if (!template || !base || !addition) continue;
                    this.lastSmithingRecipe = recipe;
                    this.timer = 500;
                    break;
                }
            }
            if (this.lastSmithingRecipe != null && (slots < ((Boolean)VintageConfig.server().recipes.allowTemplatelessRecipes.get() != false ? 2 : 3) || this.getSpeed() == 0.0f)) {
                this.lastSmithingRecipe = null;
                this.timer = 0;
            }
            if (this.timer > 0 && this.lastSmithingRecipe != null) {
                this.timer -= this.getProcessingSpeed();
                if (this.f_58857_.f_46443_) {
                    return;
                }
                if (this.timer <= 0) {
                    this.processSmith();
                    this.lastSmithingRecipe = null;
                    this.sendData();
                }
                return;
            }
        }
    }

    private List<Recipe<?>> getRecipes() {
        List list = RecipeFinder.get((Object)hammeringRecipesKey, (Level)this.f_58857_, this::matchStaticFilters);
        return list.stream().filter(this::matchHelveRecipe).sorted((r1, r2) -> r2.m_7527_().size() - r1.m_7527_().size()).collect(Collectors.toList());
    }

    protected <C extends Container> boolean matchHelveRecipe(Recipe<C> recipe) {
        if (recipe == null) {
            return false;
        }
        return HammeringRecipe.match(this, recipe);
    }

    protected <C extends Container> boolean matchStaticFilters(Recipe<C> r) {
        return r.m_6671_() == VintageRecipes.HAMMERING.getType();
    }

    private void process() {
        if (this.lastHammeringRecipe == null || !HammeringRecipe.match(this, this.lastHammeringRecipe)) {
            List<Recipe<?>> recipes;
            boolean found = false;
            Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.f_58857_, (Container)this.inputInv, VintageRecipes.HAMMERING.getType(), HammeringRecipe.class);
            if (assemblyRecipe.isPresent()) {
                this.lastHammeringRecipe = (HammeringRecipe)((Object)assemblyRecipe.get());
                this.lastRecipeIsAssembly = true;
                found = true;
            }
            if (!found && !(recipes = this.getRecipes()).isEmpty()) {
                this.lastHammeringRecipe = (HammeringRecipe)recipes.get(0);
                found = true;
            }
            if (!found) {
                return;
            }
        }
        if (HammeringRecipe.apply(this, this.lastHammeringRecipe)) {
            this.advancementBehaviour.awardVintageAdvancement(VintageAdvancements.USE_HELVE);
            this.lastHammeringRecipe = null;
            if (((Boolean)VintageConfig.server().recipes.damageAnvilAfterHammeringRecipe.get()).booleanValue() && !this.f_58857_.f_46443_ && this.f_58857_.m_8055_(this.f_58858_.m_7495_()).m_60734_() instanceof AnvilBlock && this.f_58857_.f_46441_.m_188502_() % 100 < (Integer)VintageConfig.server().recipes.chanceToDamageAnvilAfterHammeringRecipe.get()) {
                BlockState state = AnvilBlock.m_48824_((BlockState)this.f_58857_.m_8055_(this.f_58858_.m_7495_()));
                if (state == null) {
                    this.f_58857_.m_46961_(this.f_58858_.m_7495_(), false);
                } else {
                    this.f_58857_.m_46597_(this.f_58858_.m_7495_(), state);
                }
            }
        }
        this.sendData();
        this.m_6596_();
    }

    private void processSmith() {
        if (this.lastSmithingRecipe == null) {
            return;
        }
        this.bufInv.m_6211_();
        boolean template = false;
        boolean base = false;
        boolean addition = false;
        for (int i = 0; i < this.inputInv.getSlots(); ++i) {
            ItemStack item = this.inputInv.getStackInSlot(i);
            if (this.lastSmithingRecipe.m_266166_(item)) {
                template = true;
                this.bufInv.setStackInSlot(0, item);
            }
            if (this.lastSmithingRecipe.m_266343_(item)) {
                base = true;
                this.bufInv.setStackInSlot(1, item);
            }
            if (!this.lastSmithingRecipe.m_266253_(item)) continue;
            addition = true;
            this.bufInv.setStackInSlot(2, item);
        }
        if (!(template && base && addition)) {
            this.lastSmithingRecipe = null;
            return;
        }
        if (this.acceptOutputs(this.lastSmithingRecipe.m_5874_((Container)this.bufInv, this.f_58857_.m_9598_()), true) && this.lastSmithingRecipe.m_5818_((Container)this.bufInv, this.f_58857_)) {
            this.acceptOutputs(this.lastSmithingRecipe.m_5874_((Container)this.bufInv, this.f_58857_.m_9598_()), false);
            this.advancementBehaviour.awardVintageAdvancement(VintageAdvancements.USE_HELVE);
            this.bufInv.getStackInSlot(0).m_41774_(1);
            this.bufInv.getStackInSlot(1).m_41774_(1);
            this.bufInv.getStackInSlot(2).m_41774_(1);
            this.inputInv.setStackInSlot(0, this.bufInv.getStackInSlot(0));
            this.inputInv.setStackInSlot(1, this.bufInv.getStackInSlot(1));
            this.inputInv.setStackInSlot(2, this.bufInv.getStackInSlot(2));
            this.bufInv.m_6211_();
        }
    }

    public void invalidate() {
        super.invalidate();
        this.capability.invalidate();
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.inputInv);
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.outputInv);
        if (this.blockedSlots > 0) {
            SmartInventory coverInv = new SmartInventory(1, (SyncedBlockEntity)this);
            ItemHandlerHelper.insertItemStacked((IItemHandler)coverInv, (ItemStack)new ItemStack((ItemLike)VintageItems.HELVE_HAMMER_SLOT_COVER.get(), this.blockedSlots), (boolean)false);
            ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)coverInv);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.capability.cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean canProcess() {
        return this.operatingMode > 0;
    }

    public SmartInventory getInputInventory() {
        return this.inputInv;
    }

    public SmartInventory getOutputInventory() {
        return this.outputInv;
    }

    public boolean acceptOutputs(List<ItemStack> outputItems, boolean simulate) {
        this.outputInv.allowInsertion();
        boolean acceptOutputsInner = this.acceptOutputsInner(outputItems, simulate);
        this.outputInv.forbidInsertion();
        return acceptOutputsInner;
    }

    private boolean acceptOutputsInner(List<ItemStack> outputItems, boolean simulate) {
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof HelveBlock)) {
            return false;
        }
        SmartInventory targetInv = this.outputInv;
        if (targetInv == null && !outputItems.isEmpty()) {
            return false;
        }
        return this.acceptItemOutputsIntoHelve(outputItems, simulate, (IItemHandler)targetInv);
    }

    private boolean acceptItemOutputsIntoHelve(List<ItemStack> outputItems, boolean simulate, IItemHandler targetInv) {
        for (ItemStack itemStack : outputItems) {
            if (ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)itemStack.m_41777_(), (boolean)simulate).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public boolean acceptOutputs(ItemStack item, boolean simulate) {
        this.outputInv.allowInsertion();
        boolean acceptOutputsInner = this.acceptOutputsInner(item, simulate);
        this.outputInv.forbidInsertion();
        return acceptOutputsInner;
    }

    private boolean acceptOutputsInner(ItemStack item, boolean simulate) {
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof HelveBlock)) {
            return false;
        }
        SmartInventory targetInv = this.outputInv;
        if (targetInv == null && !item.m_41619_()) {
            return false;
        }
        return this.acceptItemOutputsIntoHelve(item, simulate, (IItemHandler)targetInv);
    }

    private boolean acceptItemOutputsIntoHelve(ItemStack itemStack, boolean simulate, IItemHandler targetInv) {
        return ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)itemStack.m_41777_(), (boolean)simulate).m_41619_();
    }

    public float getSpeed() {
        HelveKineticBlockEntity be = (HelveKineticBlockEntity)this.f_58857_.m_7702_(HelveBlock.getSlave((BlockGetter)this.f_58857_, this.f_58858_, this.m_58900_()));
        if (be != null) {
            return be.getSpeed();
        }
        return 0.0f;
    }

    public int getProcessingSpeed() {
        return Mth.m_14045_((int)((int)Math.abs(this.getSpeed() / 16.0f)), (int)1, (int)512);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        BlockEntity blockEntity = this.f_58857_.m_7702_(HelveBlock.getSlave((BlockGetter)this.f_58857_, this.f_58858_, this.m_58900_()));
        if (blockEntity instanceof HelveKineticBlockEntity) {
            HelveKineticBlockEntity be = (HelveKineticBlockEntity)blockEntity;
            be.addToGoggleTooltip(tooltip, isPlayerSneaking);
        }
        switch (this.operatingMode) {
            case 1: {
                VintageLang.translate("gui.goggles.current_mode", new Object[0]).add(CreateLang.text((String)" ")).add(VintageLang.translate("gui.goggles.hammering_mode", new Object[0])).style(ChatFormatting.DARK_AQUA).forGoggles(tooltip);
                break;
            }
            case 2: {
                VintageLang.translate("gui.goggles.current_mode", new Object[0]).add(CreateLang.text((String)" ")).add(VintageLang.translate("gui.goggles.smithing_mode", new Object[0])).style(ChatFormatting.DARK_PURPLE).forGoggles(tooltip);
                break;
            }
            default: {
                VintageLang.translate("gui.goggles.no_operating_block", new Object[0]).style(ChatFormatting.DARK_RED).forGoggles(tooltip);
            }
        }
        if (this.blockedSlots > 0) {
            VintageLang.translate("gui.goggles.blocked_slots", new Object[0]).add(CreateLang.text((String)(" " + this.blockedSlots))).style(ChatFormatting.GOLD).forGoggles(tooltip);
        }
        if (this.operatingMode == 1 && this.hammerBlows > 0 && this.lastHammeringRecipe != null) {
            VintageLang.translate("gui.goggles.hammer_blows", new Object[0]).add(CreateLang.text((String)" ")).add(CreateLang.number((double)this.hammerBlows)).forGoggles(tooltip);
        }
        return true;
    }

    private class HelveInventoryHandler
    extends CombinedInvWrapper {
        public HelveInventoryHandler(IItemHandlerModifiable ... itemHandlers) {
            super(itemHandlers);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (HelveBlockEntity.this.outputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return false;
            }
            return HelveBlockEntity.this.canProcess() && super.isItemValid(slot, stack);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (HelveBlockEntity.this.outputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot)) || !this.isItemValid(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (HelveBlockEntity.this.inputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return ItemStack.f_41583_;
            }
            return super.extractItem(slot, amount, simulate);
        }
    }
}

