/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.createvintageneoforged.compat.jei.animated;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.compat.jei.category.animations.AnimatedKinetics;
import dev.bluephs.createvintageneoforged.registry.VintageBlocks;
import dev.bluephs.createvintageneoforged.registry.VintagePartialModels;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;

public class AnimatedVacuumChamber
extends AnimatedKinetics {
    public void draw(GuiGraphics graphics, int xOffset, int yOffset, boolean mode) {
        int scale = 23;
        this.draw(graphics, xOffset, yOffset);
        PoseStack matrixStack = graphics.pose();
        matrixStack.pushPose();
        matrixStack.translate((float)xOffset, (float)yOffset, 200.0f);
        matrixStack.mulPose(Axis.XP.rotationDegrees(-15.5f));
        matrixStack.mulPose(Axis.YP.rotationDegrees(22.5f));
        if (!mode) {
            this.blockElement(VintagePartialModels.VACUUM_CHAMBER_ARROWS).atLocal(0.0, 0.0, 0.0).scale((double)scale).render(graphics);
        } else {
            this.blockElement(VintagePartialModels.VACUUM_CHAMBER_ARROWS).atLocal(0.0, 0.0, 0.0).rotateBlock(0.0, 0.0, 180.0).scale((double)scale).render(graphics);
        }
        matrixStack.popPose();
    }

    public void draw(GuiGraphics graphics, int xOffset, int yOffset) {
        PoseStack matrixStack = graphics.pose();
        matrixStack.pushPose();
        matrixStack.translate((float)xOffset, (float)yOffset, 200.0f);
        matrixStack.mulPose(Axis.XP.rotationDegrees(-15.5f));
        matrixStack.mulPose(Axis.YP.rotationDegrees(22.5f));
        int scale = 23;
        this.blockElement(VintagePartialModels.VACUUM_COG).rotateBlock(0.0, (double)(AnimatedVacuumChamber.getCurrentAngle() * 2.0f), 0.0).atLocal(0.0, 0.0, 0.0).scale((double)scale).render(graphics);
        this.blockElement(VintageBlocks.VACUUM_CHAMBER.getDefaultState()).atLocal(0.0, 0.0, 0.0).scale((double)scale).render(graphics);
        float animation = (Mth.sin((float)(AnimationTickHolder.getRenderTime() / 32.0f)) + 1.0f) / 5.0f + 0.5f;
        animation = Mth.clamp((float)animation, (float)0.0f, (float)0.7f);
        this.blockElement(VintagePartialModels.VACUUM_PIPE).atLocal(0.0, (double)animation, 0.0).scale((double)scale).render(graphics);
        this.blockElement(AllBlocks.BASIN.getDefaultState()).atLocal(0.0, 1.65, 0.0).scale((double)scale).render(graphics);
        matrixStack.popPose();
    }
}

