/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.createvintageneoforged.content.kinetics.centrifuge;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.content.kinetics.base.SingleAxisRotatingVisual;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.bluephs.createvintageneoforged.content.kinetics.centrifuge.CentrifugeBlockEntity;
import dev.bluephs.createvintageneoforged.registry.VintagePartialModels;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.OrientedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;

public class CentrifugeVisual
extends SingleAxisRotatingVisual<CentrifugeBlockEntity>
implements SimpleDynamicVisual {
    private final RotatingInstance centrifugeHead;
    private final OrientedInstance centrifugePole;
    private final CentrifugeBlockEntity centrifuge;

    public CentrifugeVisual(VisualizationContext context, CentrifugeBlockEntity blockEntity, float partialTick) {
        super(context, (KineticBlockEntity)blockEntity, partialTick, Models.partial((PartialModel)AllPartialModels.SHAFTLESS_COGWHEEL));
        this.centrifuge = blockEntity;
        this.centrifugeHead = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)VintagePartialModels.ZENTRIFUGE_POLE_HEAD)).createInstance();
        this.centrifugeHead.setRotationAxis(Direction.Axis.Y);
        this.centrifugePole = (OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial((PartialModel)VintagePartialModels.ZENTRIFUGE_POLE)).createInstance();
        this.animate(partialTick);
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        this.animate(ctx.partialTick());
    }

    private void animate(float pt) {
        float renderedHeadOffset = this.centrifuge.getRenderedHeadOffset(pt);
        this.transformPole(renderedHeadOffset);
        this.transformHead(renderedHeadOffset, pt);
    }

    private void transformHead(float renderedHeadOffset, float pt) {
        float speed = this.centrifuge.getRenderedHeadRotationSpeed(pt);
        this.centrifugeHead.setPosition((Vec3i)this.getVisualPosition()).nudge(0.0f, -renderedHeadOffset, 0.0f).setRotationalSpeed(speed * 2.0f * 6.0f).setChanged();
    }

    private void transformPole(float renderedHeadOffset) {
        this.centrifugePole.position((Vec3i)this.getVisualPosition()).translatePosition(0.0f, -renderedHeadOffset, 0.0f).setChanged();
    }

    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        this.relight(this.pos.below(), new FlatLit[]{this.centrifugeHead});
        this.relight(new FlatLit[]{this.centrifugePole});
    }

    protected void _delete() {
        super._delete();
        this.centrifugeHead.delete();
        this.centrifugePole.delete();
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        super.collectCrumblingInstances(consumer);
        consumer.accept((Instance)this.centrifugeHead);
        consumer.accept((Instance)this.centrifugePole);
    }
}

