/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.createvintageneoforged.content.kinetics.coiling;

import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import dev.bluephs.createvintageneoforged.content.kinetics.coiling.CoilingBlockEntity;
import dev.bluephs.createvintageneoforged.registry.VintageBlockEntity;
import dev.bluephs.createvintageneoforged.registry.VintageShapes;
import javax.annotation.Nullable;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CoilingBlock
extends HorizontalKineticBlock
implements IBE<CoilingBlockEntity> {
    public static final VoxelShaper COILING_MACHINE_SHAPE = VintageShapes.shape(0.0, 0.0, 14.0, 16.0, 16.0, 16.0).add(0.0, 0.0, 2.0, 16.0, 11.0, 14.0).forDirectional();

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    public CoilingBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction prefferedSide = this.getPreferredHorizontalFacing(context);
        if (prefferedSide != null) {
            return (BlockState)this.defaultBlockState().setValue(HORIZONTAL_FACING, (Comparable)prefferedSide.getOpposite());
        }
        return super.getStateForPlacement(context);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue(HORIZONTAL_FACING)).getAxis();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face == ((Direction)state.getValue(HORIZONTAL_FACING)).getOpposite();
    }

    public Class<CoilingBlockEntity> getBlockEntityClass() {
        return CoilingBlockEntity.class;
    }

    public BlockEntityType<? extends CoilingBlockEntity> getBlockEntityType() {
        return (BlockEntityType)VintageBlockEntity.COILING.get();
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return COILING_MACHINE_SHAPE.get((Direction)state.getValue(HORIZONTAL_FACING));
    }

    public void updateEntityAfterFallOn(BlockGetter worldIn, Entity entityIn) {
        super.updateEntityAfterFallOn(worldIn, entityIn);
        if (!(entityIn instanceof ItemEntity)) {
            return;
        }
        if (entityIn.level().isClientSide) {
            return;
        }
        BlockPos pos = entityIn.blockPosition();
        this.withBlockEntityDo((BlockGetter)entityIn.level(), pos, be -> {
            if (be.getSpeed() == 0.0f) {
                return;
            }
            be.insertItem((ItemEntity)entityIn);
        });
    }
}

