/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.createvintageneoforged.content.kinetics.vacuum_chamber;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.block.IBE;
import dev.bluephs.createvintageneoforged.content.kinetics.vacuum_chamber.VacuumChamberBlockEntity;
import dev.bluephs.createvintageneoforged.registry.VintageBlockEntity;
import dev.bluephs.createvintageneoforged.registry.VintageShapes;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class VacuumChamberBlock
extends KineticBlock
implements IBE<VacuumChamberBlockEntity>,
ICogWheel {
    public static final VoxelShaper VACUUM_CHAMBER_SHAPE = VintageShapes.shape(0.0, 0.0, 0.0, 16.0, 16.0, 16.0).forDirectional();
    public static final EnumProperty<VacuumChamberBlockEntity.ChamberMode> MODE = EnumProperty.create((String)"mode", VacuumChamberBlockEntity.ChamberMode.class);

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    public VacuumChamberBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(MODE, (Comparable)((Object)VacuumChamberBlockEntity.ChamberMode.VACUUM)));
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{MODE});
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        return !AllBlocks.BASIN.has(worldIn.getBlockState(pos.below()));
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return VACUUM_CHAMBER_SHAPE.get(Direction.DOWN);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return Direction.Axis.Y;
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return false;
    }

    public IRotate.SpeedLevel getMinimumRequiredSpeedLevel() {
        return IRotate.SpeedLevel.MEDIUM;
    }

    public Class<VacuumChamberBlockEntity> getBlockEntityClass() {
        return VacuumChamberBlockEntity.class;
    }

    public BlockEntityType<? extends VacuumChamberBlockEntity> getBlockEntityType() {
        return (BlockEntityType)VintageBlockEntity.VACUUM.get();
    }

    public boolean isPathfindable(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemStack, @Nullable BlockGetter getter, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.translatable((String)"createvintageneoforged.item_description.machine_rpm_requirements").append(" " + IRotate.SpeedLevel.MEDIUM.getSpeedValue()).withStyle(ChatFormatting.GOLD));
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack held = player.getItemInHand(hand);
        return this.onBlockEntityUse((BlockGetter)level, pos, be -> {
            if (AllItems.WRENCH.isIn(held)) {
                if (!level.isClientSide) {
                    be.changeMode();
                    be.setChanged();
                    be.sendData();
                    level.sendBlockUpdated(pos, state, state, 3);
                } else {
                    be.requestModelDataUpdate();
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            return InteractionResult.PASS;
        });
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        return this.onBlockEntityUse((BlockGetter)level, pos, be -> {
            if (!level.isClientSide) {
                be.changeMode();
                be.setChanged();
                be.sendData();
                level.sendBlockUpdated(pos, state, state, 3);
            } else {
                be.requestModelDataUpdate();
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        });
    }
}

