/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.createvintageneoforged.content.kinetics.vacuum_chamber;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.processing.basin.BasinBlock;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.basin.BasinOperatingBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.bluephs.createvintageneoforged.content.kinetics.vacuum_chamber.PressurizingRecipe;
import dev.bluephs.createvintageneoforged.content.kinetics.vacuum_chamber.VacuumChamberBlock;
import dev.bluephs.createvintageneoforged.content.kinetics.vacuum_chamber.VacuumizingRecipe;
import dev.bluephs.createvintageneoforged.registry.VintageRecipes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class VacuumChamberBlockEntity
extends BasinOperatingBlockEntity
implements IWrenchable {
    private ChamberMode mode = ChamberMode.VACUUM;
    private static final Object vacuumizingRecipesKey = new Object();
    private static final Object pressurizingRecipesKey = new Object();
    public int runningTicks;
    public int processingTicks;
    public boolean running;
    public SmartFluidTankBehaviour outputTank;
    public SmartFluidTankBehaviour inputTank;
    public IFluidHandler fluidCapability;
    boolean contentsChanged;

    public VacuumChamberBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void changeMode() {
        this.mode = this.mode.toggle();
        this.running = false;
        this.runningTicks = 0;
        this.currentRecipe = null;
        this.setChanged();
        this.sendData();
        if (this.level != null && this.level.isClientSide) {
            this.requestModelDataUpdate();
        }
    }

    public ChamberMode getMode() {
        return this.mode;
    }

    public boolean isVacuum() {
        return this.mode == ChamberMode.VACUUM;
    }

    public boolean isPressurizing() {
        return this.mode == ChamberMode.PRESSURE;
    }

    public int getRecipeDuration() {
        Recipe recipe = this.currentRecipe;
        if (recipe instanceof VacuumizingRecipe) {
            VacuumizingRecipe vacuumRecipe = (VacuumizingRecipe)recipe;
            return vacuumRecipe.getProcessingDuration();
        }
        recipe = this.currentRecipe;
        if (recipe instanceof PressurizingRecipe) {
            PressurizingRecipe pressureRecipe = (PressurizingRecipe)recipe;
            return pressureRecipe.getProcessingDuration();
        }
        return 100;
    }

    public int getScaledRecipeDuration() {
        float modifier;
        float clamped;
        int scaled;
        float speed;
        int base = this.getRecipeDuration();
        if (base <= 0) {
            base = 100;
        }
        if ((speed = Math.abs(this.getSpeed())) < 1.0f) {
            return base;
        }
        float medium = IRotate.SpeedLevel.MEDIUM.getSpeedValue();
        if (medium <= 0.0f) {
            medium = 32.0f;
        }
        if ((scaled = (int)((float)base / (clamped = Mth.clamp((float)(modifier = speed / medium), (float)0.5f, (float)8.0f)))) < 5) {
            scaled = 5;
        }
        return scaled;
    }

    public float getRenderedHeadOffset(float partialTicks) {
        float animatedOffset = 0.0f;
        float totalMovement = 1.25f;
        int closingTicks = 40;
        int openingTicks = 40;
        if (this.running) {
            int duration;
            int n = duration = this.processingTicks > 0 ? this.processingTicks : this.getRecipeDuration();
            if (this.runningTicks < closingTicks) {
                int localTick = this.runningTicks;
                float progress = ((float)localTick + partialTicks) / (float)closingTicks;
                progress = (2.0f - Mth.cos((float)((float)((double)progress * Math.PI)))) / 2.0f;
                animatedOffset = progress * totalMovement;
            } else if (this.runningTicks < duration - openingTicks) {
                animatedOffset = totalMovement;
            } else {
                int localTick = this.runningTicks - (duration - openingTicks);
                float progress = ((float)openingTicks - ((float)localTick + partialTicks)) / (float)openingTicks;
                progress = (2.0f - Mth.cos((float)((float)((double)progress * Math.PI)))) / 2.0f;
                animatedOffset = progress * totalMovement;
            }
        }
        return animatedOffset;
    }

    public void tick() {
        super.tick();
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        if (Mth.abs((float)this.getSpeed()) < IRotate.SpeedLevel.MEDIUM.getSpeedValue()) {
            if (this.running) {
                this.running = false;
                this.runningTicks = 0;
                this.getBasin().ifPresent(bte -> bte.setAreFluidsMoving(false));
                this.setChanged();
                this.sendData();
                this.requestModelDataUpdate();
            }
            return;
        }
        if (this.running) {
            ++this.runningTicks;
            if (this.runningTicks >= this.processingTicks) {
                this.runningTicks = 0;
                this.running = false;
                this.applyBasinRecipe();
                this.setChanged();
                this.sendData();
                this.requestModelDataUpdate();
                this.getBasin().ifPresent(bte -> bte.setAreFluidsMoving(false));
            }
            return;
        }
        this.findMatchingRecipe().ifPresent(this::startRecipe);
    }

    private Optional<? extends Recipe<?>> findMatchingRecipe() {
        if (this.level == null) {
            return Optional.empty();
        }
        if (this.isVacuum()) {
            return this.getMatchingRecipes(VintageRecipes.VACUUMIZING.getType()).stream().map(RecipeHolder::value).findFirst();
        }
        if (this.isPressurizing()) {
            return this.getMatchingRecipes(VintageRecipes.PRESSURIZING.getType()).stream().map(RecipeHolder::value).findFirst();
        }
        return Optional.empty();
    }

    protected <C extends Recipe<?>> List<RecipeHolder<C>> getMatchingRecipes(RecipeType<C> type) {
        if (this.level == null) {
            return Collections.emptyList();
        }
        Optional basin = this.getBasin();
        if (basin.isEmpty()) {
            return Collections.emptyList();
        }
        List allRecipes = this.level.getRecipeManager().getAllRecipesFor(type);
        return allRecipes.stream().filter(recipeHolder -> {
            Recipe recipe = recipeHolder.value();
            if (this.isVacuum() && recipe instanceof VacuumizingRecipe) {
                VacuumizingRecipe vacuumRecipe = (VacuumizingRecipe)recipe;
                return VacuumizingRecipe.match((BasinBlockEntity)basin.get(), vacuumRecipe, this);
            }
            if (this.isPressurizing() && recipe instanceof PressurizingRecipe) {
                PressurizingRecipe pressurizingRecipe = (PressurizingRecipe)recipe;
                return PressurizingRecipe.match((BasinBlockEntity)basin.get(), pressurizingRecipe, this);
            }
            return false;
        }).map(recipeHolder -> recipeHolder).toList();
    }

    private void startRecipe(Recipe<?> recipe) {
        this.currentRecipe = recipe;
        this.running = true;
        this.runningTicks = 0;
        this.processingTicks = this.getScaledRecipeDuration();
        this.setChanged();
        this.sendData();
        this.requestModelDataUpdate();
        AllSoundEvents.PACKAGE_POP.playAt(this.level, (Vec3i)this.worldPosition, 3.0f, 1.0f, true);
        this.getBasin().ifPresent(bte -> bte.setAreFluidsMoving(true));
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        this.running = compound.getBoolean("Running");
        this.runningTicks = compound.getInt("Ticks");
        ChamberMode previousMode = this.mode;
        if (compound.contains("Mode")) {
            try {
                this.mode = ChamberMode.valueOf(compound.getString("Mode"));
            }
            catch (Exception e) {
                this.mode = ChamberMode.VACUUM;
            }
        }
        super.read(compound, registries, clientPacket);
        if (clientPacket && this.hasLevel()) {
            this.getBasin().ifPresent(bte -> bte.setAreFluidsMoving(this.running && this.runningTicks <= 20));
            if (previousMode != this.mode || this.running || this.runningTicks == 0) {
                this.requestModelDataUpdate();
            }
        }
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.putBoolean("Running", this.running);
        compound.putInt("Ticks", this.runningTicks);
        compound.putString("Mode", this.mode.name());
        super.write(compound, registries, clientPacket);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.inputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.INPUT, (SmartBlockEntity)this, 2, 1000, true).whenFluidUpdates(() -> {
            this.contentsChanged = true;
        });
        this.outputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.OUTPUT, (SmartBlockEntity)this, 2, 1000, true).whenFluidUpdates(() -> {
            this.contentsChanged = true;
        }).forbidInsertion();
        behaviours.add((BlockEntityBehaviour)this.inputTank);
        behaviours.add((BlockEntityBehaviour)this.outputTank);
        this.fluidCapability = new VacuumChamberTanksHandler(this.outputTank.getCapability(), this.inputTank.getCapability());
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.worldPosition).expandTowards(0.0, -1.5, 0.0);
    }

    protected void applyBasinRecipe() {
        if (this.currentRecipe == null) {
            return;
        }
        Optional optionalBasin = this.getBasin();
        if (optionalBasin.isEmpty()) {
            return;
        }
        BasinBlockEntity basin = (BasinBlockEntity)optionalBasin.get();
        boolean wasEmpty = basin.canContinueProcessing();
        if (this.mode == ChamberMode.VACUUM ? !VacuumizingRecipe.apply(basin, this.currentRecipe, this) : !PressurizingRecipe.apply(basin, this.currentRecipe, this)) {
            return;
        }
        this.getProcessedRecipeTrigger().ifPresent(arg_0 -> ((VacuumChamberBlockEntity)this).award(arg_0));
        basin.inputTank.sendDataImmediately();
        if (wasEmpty && this.matchBasinRecipe(this.currentRecipe)) {
            this.continueWithPreviousRecipe();
            this.sendData();
        }
        basin.notifyChangeOfContents();
    }

    protected void onBasinRemoved() {
        if (!this.running) {
            return;
        }
        this.runningTicks = 40;
        this.running = false;
    }

    List<Recipe<?>> getRecipes() {
        ArrayList res = new ArrayList();
        if (this.level == null) {
            return res;
        }
        if (this.isVacuum()) {
            this.level.getRecipeManager().getAllRecipesFor(VintageRecipes.VACUUMIZING.getType()).forEach(r -> res.add(r.value()));
        } else if (this.isPressurizing()) {
            this.level.getRecipeManager().getAllRecipesFor(VintageRecipes.PRESSURIZING.getType()).forEach(r -> res.add(r.value()));
        }
        return res;
    }

    public boolean acceptOutputs(List<FluidStack> outputFluids, boolean simulate) {
        this.outputTank.allowInsertion();
        boolean acceptOutputsInner = this.acceptOutputsInner(outputFluids, simulate);
        this.outputTank.forbidInsertion();
        return acceptOutputsInner;
    }

    private boolean acceptOutputsInner(List<FluidStack> outputFluids, boolean simulate) {
        IFluidHandler targetTank;
        BlockState blockState = this.getBlockState();
        Direction direction = (Direction)blockState.getValue((Property)BasinBlock.FACING);
        BlockEntity be = this.level.getBlockEntity(this.worldPosition.below().relative(direction));
        if (!(blockState.getBlock() instanceof VacuumChamberBlock)) {
            return false;
        }
        IFluidHandler iFluidHandler = targetTank = be == null ? null : (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, be.getBlockPos(), (Object)direction.getOpposite());
        if (outputFluids.isEmpty()) {
            return true;
        }
        if (targetTank == null) {
            return false;
        }
        return this.acceptFluidOutputsIntoCentrifuge(outputFluids, simulate, targetTank);
    }

    private boolean acceptFluidOutputsIntoCentrifuge(List<FluidStack> outputFluids, boolean simulate, IFluidHandler targetTank) {
        for (FluidStack fluidStack : outputFluids) {
            IFluidHandler.FluidAction action = simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE;
            int fill = targetTank instanceof SmartFluidTankBehaviour.InternalFluidHandler ? ((SmartFluidTankBehaviour.InternalFluidHandler)targetTank).forceFill(fluidStack.copy(), action) : targetTank.fill(fluidStack.copy(), action);
            if (fill == fluidStack.getAmount()) continue;
            return false;
        }
        return true;
    }

    public void renderParticles() {
        Optional basin = this.getBasin();
        if (!basin.isPresent() || this.level == null) {
            return;
        }
        if (!this.level.getBlockState(this.getBlockPos().above()).is(Blocks.AIR)) {
            return;
        }
        if (Mth.abs((float)this.getSpeed()) < IRotate.SpeedLevel.MEDIUM.getSpeedValue()) {
            return;
        }
        float angle = this.level.random.nextFloat() * 360.0f;
        Vec3 offset = new Vec3(0.0, 0.0, 0.25);
        offset = VecHelper.rotate((Vec3)offset, (double)angle, (Direction.Axis)Direction.Axis.Y);
        Vec3 target = VecHelper.rotate((Vec3)offset, (double)(this.getSpeed() > 0.0f ? 25.0 : -25.0), (Direction.Axis)Direction.Axis.Y).add(0.0, 0.25, 0.0);
        Vec3 center = offset.add(VecHelper.getCenterOf((Vec3i)this.worldPosition));
        target = VecHelper.offsetRandomly((Vec3)target.subtract(offset), (RandomSource)this.level.random, (float)0.0078125f);
        if (this.mode == ChamberMode.PRESSURE) {
            this.level.addParticle((ParticleOptions)ParticleTypes.CLOUD, center.x + target.x * 10.0, center.y + 0.5 + target.y * 10.0, center.z + target.z * 10.0, -target.x * 0.6, -target.y * 0.6, -target.z * 0.6);
        } else {
            this.level.addParticle((ParticleOptions)ParticleTypes.CLOUD, center.x, center.y + 0.5, center.z, target.x, target.y, target.z);
        }
    }

    protected boolean matchStaticFilters(RecipeHolder<? extends Recipe<?>> recipe) {
        return false;
    }

    protected Object getRecipeCacheKey() {
        return this.isVacuum() ? vacuumizingRecipesKey : pressurizingRecipesKey;
    }

    protected boolean isRunning() {
        return this.running;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        if (this.runningTicks == 25) {
            AllSoundEvents.STEAM.playAt(this.level, (Vec3i)this.worldPosition, 3.0f, 1.0f, true);
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        ChatFormatting color;
        MutableComponent modeText;
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (this.mode == ChamberMode.PRESSURE) {
            modeText = Component.translatable((String)"gui.goggles.pressurizing_mode");
            color = ChatFormatting.DARK_PURPLE;
        } else {
            modeText = Component.translatable((String)"gui.goggles.vacuumizing_mode");
            color = ChatFormatting.DARK_AQUA;
        }
        tooltip.add((Component)Component.translatable((String)"gui.goggles.current_mode").append((Component)Component.literal((String)" ")).append((Component)modeText).withStyle(color));
        boolean isEmpty = true;
        LangBuilder mb = CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        for (int i = 0; i < this.fluidCapability.getTanks(); ++i) {
            FluidStack fluidStack = this.fluidCapability.getFluidInTank(i);
            if (fluidStack.isEmpty()) continue;
            CreateLang.text((String)"").add(CreateLang.fluidName((FluidStack)fluidStack).add(CreateLang.text((String)" ")).style(ChatFormatting.GRAY).add(CreateLang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.BLUE))).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        if (isEmpty) {
            tooltip.remove(0);
        }
        return true;
    }

    public static enum ChamberMode implements StringRepresentable
    {
        VACUUM,
        PRESSURE;


        public ChamberMode toggle() {
            return this == VACUUM ? PRESSURE : VACUUM;
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    private static class VacuumChamberTanksHandler
    extends CombinedTankWrapper {
        public VacuumChamberTanksHandler(IFluidHandler ... fluidHandlers) {
            super(fluidHandlers);
        }
    }
}

