/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.createvintageneoforged.content.kinetics.vacuum_chamber;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.SingleAxisRotatingVisual;
import dev.bluephs.createvintageneoforged.content.kinetics.vacuum_chamber.VacuumChamberBlockEntity;
import dev.bluephs.createvintageneoforged.registry.VintagePartialModels;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.OrientedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.minecraft.core.Vec3i;

public class VacuumChamberVisual
extends SingleAxisRotatingVisual<VacuumChamberBlockEntity>
implements SimpleDynamicVisual {
    private final OrientedInstance mixerPole;
    private final VacuumChamberBlockEntity chamber;

    public VacuumChamberVisual(VisualizationContext context, VacuumChamberBlockEntity blockEntity, float partialTick) {
        super(context, (KineticBlockEntity)blockEntity, partialTick, Models.partial((PartialModel)VintagePartialModels.VACUUM_COG));
        this.chamber = blockEntity;
        this.mixerPole = (OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial((PartialModel)VintagePartialModels.VACUUM_PIPE)).createInstance();
        this.animate(partialTick);
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        this.animate(ctx.partialTick());
    }

    private void animate(float pt) {
        float renderedHeadOffset = this.chamber.getRenderedHeadOffset(pt);
        this.transformPole(renderedHeadOffset);
    }

    private void transformPole(float renderedHeadOffset) {
        float baseCorrection = 0.4375f;
        this.mixerPole.position((Vec3i)this.getVisualPosition()).translatePosition(0.0f, -renderedHeadOffset - baseCorrection, 0.0f).setChanged();
    }

    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        this.relight(new FlatLit[]{this.mixerPole});
    }

    protected void _delete() {
        super._delete();
        this.mixerPole.delete();
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        super.collectCrumblingInstances(consumer);
        consumer.accept((Instance)this.mixerPole);
    }
}

