/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.createvintageneoforged.content.kinetics.vibration;

import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.block.IBE;
import dev.bluephs.createvintageneoforged.content.kinetics.vibration.VibratingTableBlockEntity;
import dev.bluephs.createvintageneoforged.registry.VintageBlockEntity;
import dev.bluephs.createvintageneoforged.registry.VintageShapes;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class VibratingTableBlock
extends HorizontalKineticBlock
implements IBE<VibratingTableBlockEntity> {
    public static final VoxelShaper vibrating_table_SHAPE = VintageShapes.shape(0.0, 0.0, 0.0, 16.0, 14.0, 16.0).forDirectional();

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    public VibratingTableBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction prefferedSide = this.getPreferredHorizontalFacing(context);
        if (prefferedSide != null) {
            return (BlockState)this.defaultBlockState().setValue(HORIZONTAL_FACING, (Comparable)prefferedSide);
        }
        return super.getStateForPlacement(context);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        this.withBlockEntityDo((BlockGetter)level, pos, vibratingtable -> {
            int slot;
            boolean emptyOutput = true;
            ItemStackHandler inv = vibratingtable.outputInv;
            for (slot = 0; slot < inv.getSlots(); ++slot) {
                ItemStack stackInSlot = inv.getStackInSlot(slot);
                if (!stackInSlot.isEmpty()) {
                    emptyOutput = false;
                }
                player.getInventory().placeItemBackInInventory(stackInSlot);
                inv.setStackInSlot(slot, ItemStack.EMPTY);
            }
            if (emptyOutput) {
                inv = vibratingtable.inputInv;
                for (slot = 0; slot < inv.getSlots(); ++slot) {
                    player.getInventory().placeItemBackInInventory(inv.getStackInSlot(slot));
                    inv.setStackInSlot(slot, ItemStack.EMPTY);
                }
            }
            vibratingtable.setChanged();
            vibratingtable.sendData();
        });
        return InteractionResult.SUCCESS;
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue(HORIZONTAL_FACING)).getAxis();
    }

    public IRotate.SpeedLevel getMinimumRequiredSpeedLevel() {
        return IRotate.SpeedLevel.MEDIUM;
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.getAxis() == ((Direction)state.getValue(HORIZONTAL_FACING)).getAxis();
    }

    public Class<VibratingTableBlockEntity> getBlockEntityClass() {
        return VibratingTableBlockEntity.class;
    }

    public BlockEntityType<? extends VibratingTableBlockEntity> getBlockEntityType() {
        return (BlockEntityType)VintageBlockEntity.VIBRATION.get();
    }

    public boolean isPathfindable(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return vibrating_table_SHAPE.get(Direction.UP);
    }

    public static boolean isHorizontal(BlockState state) {
        return true;
    }

    public void updateEntityAfterFallOn(BlockGetter worldIn, Entity entityIn) {
        super.updateEntityAfterFallOn(worldIn, entityIn);
        if (entityIn.level().isClientSide) {
            return;
        }
        if (!(entityIn instanceof ItemEntity)) {
            return;
        }
        if (!entityIn.isAlive()) {
            return;
        }
        VibratingTableBlockEntity vibratingtable = null;
        for (BlockPos pos : Iterate.hereAndBelow((BlockPos)entityIn.blockPosition())) {
            if (vibratingtable != null) continue;
            vibratingtable = (VibratingTableBlockEntity)this.getBlockEntity(worldIn, pos);
        }
        if (vibratingtable == null) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entityIn;
        IItemHandler capability = (IItemHandler)vibratingtable.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, vibratingtable.getBlockPos(), null);
        if (capability == null) {
            return;
        }
        ItemStack remainder = capability.insertItem(0, itemEntity.getItem(), false);
        if (remainder.isEmpty()) {
            itemEntity.discard();
        }
        if (remainder.getCount() < itemEntity.getItem().getCount()) {
            itemEntity.setItem(remainder);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemStack, @Nullable BlockGetter getter, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.translatable((String)"createvintageneoforged.item_description.machine_rpm_requirements").append(" " + IRotate.SpeedLevel.FAST.getSpeedValue()).withStyle(ChatFormatting.GOLD));
    }
}

