/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.createvintageneoforged.infrastructure.gui;

import dev.bluephs.createvintageneoforged.infrastructure.config.VintageConfig;
import dev.bluephs.createvintageneoforged.registry.VintageBlocks;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.createmod.catnip.config.ui.BaseConfigScreen;
import net.createmod.catnip.gui.ScreenOpener;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ScreenEvent;
import org.apache.commons.lang3.mutable.MutableObject;

public class OpenVintageMenuButton
extends Button {
    public static final ItemStack ICON = VintageBlocks.BELT_GRINDER.asStack();

    public OpenVintageMenuButton(int x, int y) {
        super(x, y, 20, 20, (Component)Component.empty(), OpenVintageMenuButton::click, DEFAULT_NARRATION);
    }

    public void renderString(GuiGraphics graphics, Font pFont, int pColor) {
        graphics.renderItem(ICON, this.getX() + 2, this.getY() + 2);
    }

    public static void click(Button b) {
        ScreenOpener.open((Screen)new BaseConfigScreen(Minecraft.getInstance().screen, "createvintageneoforged"));
    }

    @EventBusSubscriber(value={Dist.CLIENT})
    public static class OpenConfigButtonHandler {
        @SubscribeEvent
        public static void onGuiInit(ScreenEvent.Init.Post event) {
            Screen gui = event.getScreen();
            MenuRows menu = null;
            int rowIdx = 0;
            int offsetX = 0;
            if (gui instanceof TitleScreen) {
                menu = MenuRows.MAIN_MENU;
                rowIdx = (Integer)VintageConfig.client().mainMenuConfigButtonRow.get();
                offsetX = (Integer)VintageConfig.client().mainMenuConfigButtonOffsetX.get();
            } else if (gui instanceof PauseScreen) {
                menu = MenuRows.INGAME_MENU;
                rowIdx = (Integer)VintageConfig.client().ingameMenuConfigButtonRow.get();
                offsetX = (Integer)VintageConfig.client().ingameMenuConfigButtonOffsetX.get();
            }
            if (rowIdx != 0 && menu != null) {
                boolean onLeft = offsetX < 0;
                String target = (onLeft ? menu.leftButtons : menu.rightButtons).get(rowIdx - 1);
                int offsetX_ = offsetX;
                MutableObject toAdd = new MutableObject(null);
                event.getListenersList().stream().filter(w -> w instanceof AbstractWidget).map(w -> (AbstractWidget)w).filter(w -> w.getMessage().getString().equals(target)).findFirst().ifPresent(w -> toAdd.setValue((Object)new OpenVintageMenuButton(w.getX() + offsetX_ + (onLeft ? -20 : w.getWidth()), w.getY())));
                if (toAdd.getValue() != null) {
                    event.addListener((GuiEventListener)toAdd.getValue());
                }
            }
        }
    }

    public static class MenuRows {
        public static final MenuRows MAIN_MENU = new MenuRows(Arrays.asList(new SingleMenuRow("menu.singleplayer"), new SingleMenuRow("menu.multiplayer"), new SingleMenuRow("fml.menu.mods", "menu.online"), new SingleMenuRow("narrator.button.language", "narrator.button.accessibility")));
        public static final MenuRows INGAME_MENU = new MenuRows(Arrays.asList(new SingleMenuRow("menu.returnToGame"), new SingleMenuRow("gui.advancements", "gui.stats"), new SingleMenuRow("menu.sendFeedback", "menu.reportBugs"), new SingleMenuRow("menu.options", "menu.shareToLan"), new SingleMenuRow("menu.returnToMenu")));
        protected final List<String> leftButtons;
        protected final List<String> rightButtons;

        public MenuRows(List<SingleMenuRow> variants) {
            this.leftButtons = variants.stream().map(r -> r.left).collect(Collectors.toList());
            this.rightButtons = variants.stream().map(r -> r.right).collect(Collectors.toList());
        }
    }

    public static class SingleMenuRow {
        public final String left;
        public final String right;

        public SingleMenuRow(String left, String right) {
            this.left = I18n.get((String)left, (Object[])new Object[0]);
            this.right = I18n.get((String)right, (Object[])new Object[0]);
        }

        public SingleMenuRow(String center) {
            this(center, center);
        }
    }
}

