/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.createvintageneoforged.registry;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.processing.recipe.StandardProcessingRecipe;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.bluephs.createvintageneoforged.CreateVintageneoForged;
import dev.bluephs.createvintageneoforged.content.kinetics.centrifuge.CentrifugationRecipe;
import dev.bluephs.createvintageneoforged.content.kinetics.coiling.CoilingRecipe;
import dev.bluephs.createvintageneoforged.content.kinetics.grinder.PolishingRecipe;
import dev.bluephs.createvintageneoforged.content.kinetics.vacuum_chamber.PressurizingRecipe;
import dev.bluephs.createvintageneoforged.content.kinetics.vacuum_chamber.VacuumizingRecipe;
import dev.bluephs.createvintageneoforged.content.kinetics.vibration.LeavesVibratingRecipe;
import dev.bluephs.createvintageneoforged.content.kinetics.vibration.VibratingRecipe;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.Nullable;

public enum VintageRecipes implements IRecipeTypeInfo
{
    POLISHING(PolishingRecipe::new),
    COILING(CoilingRecipe::new),
    VACUUMIZING(VacuumizingRecipe::new),
    PRESSURIZING(PressurizingRecipe::new),
    VIBRATING(VibratingRecipe::new),
    CENTRIFUGATION(CentrifugationRecipe::new),
    LEAVES_VIBRATING(LeavesVibratingRecipe::new);

    private final ResourceLocation id;
    private final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> serializerObject;
    @Nullable
    private final DeferredHolder<RecipeType<?>, RecipeType<?>> typeObject;
    private final Supplier<RecipeType<?>> type;

    private VintageRecipes(Supplier<RecipeSerializer<?>> serializerSupplier) {
        String name = CreateLang.asId((String)this.name());
        this.id = CreateVintageneoForged.asResource(name);
        this.serializerObject = Registers.SERIALIZER_REGISTER.register(name, serializerSupplier);
        this.typeObject = Registers.TYPE_REGISTER.register(name, () -> RecipeType.simple((ResourceLocation)this.id));
        this.type = this.typeObject;
    }

    private VintageRecipes(StandardProcessingRecipe.Factory<?> processingFactory) {
        this(() -> new StandardProcessingRecipe.Serializer(processingFactory));
    }

    public static void register(IEventBus modEventBus) {
        Registers.SERIALIZER_REGISTER.register(modEventBus);
        Registers.TYPE_REGISTER.register(modEventBus);
    }

    public static boolean shouldIgnoreInAutomation(RecipeHolder<?> r) {
        RecipeSerializer serializer = r.value().getSerializer();
        if (AllTags.AllRecipeSerializerTags.AUTOMATION_IGNORE.matches(serializer)) {
            return true;
        }
        return !AllRecipeTypes.CAN_BE_AUTOMATED.test(r);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public <T extends RecipeSerializer<?>> T getSerializer() {
        return (T)((RecipeSerializer)this.serializerObject.get());
    }

    public <I extends RecipeInput, R extends Recipe<I>> RecipeType<R> getType() {
        return this.type.get();
    }

    public Optional<Object> find(RecipeWrapper inventoryIn, Level level) {
        RecipeType type = this.getType();
        List recipes = level.getRecipeManager().getAllRecipesFor(type);
        for (Object obj : recipes) {
            if (!(obj instanceof RecipeHolder)) continue;
            RecipeHolder holder = (RecipeHolder)obj;
            Recipe recipe = holder.value();
            try {
                if (!recipe.matches((RecipeInput)inventoryIn, level)) continue;
                return Optional.of(recipe);
            }
            catch (ClassCastException classCastException) {
            }
        }
        return Optional.empty();
    }

    private static class Registers {
        private static final DeferredRegister<RecipeSerializer<?>> SERIALIZER_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"createvintageneoforged");
        private static final DeferredRegister<RecipeType<?>> TYPE_REGISTER = DeferredRegister.create((ResourceKey)Registries.RECIPE_TYPE, (String)"createvintageneoforged");

        private Registers() {
        }
    }
}

