/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.vintage.content.kinetics.coiling;

import com.google.gson.JsonObject;
import com.simibubi.create.compat.jei.category.sequencedAssembly.SequencedAssemblySubCategory;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.sequenced.IAssemblyRecipe;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import dev.bluephs.vintage.VintageBlocks;
import dev.bluephs.vintage.VintageLang;
import dev.bluephs.vintage.VintageRecipes;
import dev.bluephs.vintage.compat.jei.category.assemblies.AssemblyCoiling;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.wrapper.RecipeWrapper;

@ParametersAreNonnullByDefault
public class CoilingRecipe
extends ProcessingRecipe<RecipeWrapper>
implements IAssemblyRecipe {
    public int springColor = 10134685;

    public CoilingRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super((IRecipeTypeInfo)VintageRecipes.COILING, params);
    }

    public boolean matches(RecipeWrapper inv, Level worldIn) {
        if (inv.m_7983_()) {
            return false;
        }
        return ((Ingredient)this.ingredients.get(0)).test(inv.m_8020_(0));
    }

    protected int getMaxInputCount() {
        return 1;
    }

    protected int getMaxOutputCount() {
        return 4;
    }

    protected boolean canSpecifyDuration() {
        return true;
    }

    public void addAssemblyIngredients(List<Ingredient> list) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getDescriptionForAssembly() {
        return VintageLang.translateDirect("recipe.assembly.coiling", new Object[0]);
    }

    public void addRequiredMachines(Set<ItemLike> list) {
        list.add((ItemLike)VintageBlocks.SPRING_COILING_MACHINE.get());
    }

    public Supplier<Supplier<SequencedAssemblySubCategory>> getJEISubCategory() {
        return () -> AssemblyCoiling::new;
    }

    public void readAdditional(JsonObject json) {
        this.springColor = json.has("springColor") ? Integer.parseInt(json.get("springColor").getAsString(), 16) : 10134685;
    }

    public void readAdditional(FriendlyByteBuf buffer) {
        this.springColor = buffer.readInt();
    }

    public void writeAdditional(JsonObject json) {
        json.addProperty("springColor", (Number)this.springColor);
    }

    public void writeAdditional(FriendlyByteBuf buffer) {
        buffer.writeInt(this.springColor);
    }
}

