/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.vintage.content.kinetics.curving_press;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import dev.bluephs.vintage.VintageBlockEntity;
import dev.bluephs.vintage.VintageItems;
import dev.bluephs.vintage.content.kinetics.curving_press.CurvingPressBlockEntity;
import dev.bluephs.vintage.foundation.advancement.VintageAdvancementBehaviour;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CurvingPressBlock
extends HorizontalKineticBlock
implements IBE<CurvingPressBlockEntity> {
    public static final TagKey<Item> headTag = ItemTags.create((ResourceLocation)new ResourceLocation("vintage", "curving_heads"));

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        VintageAdvancementBehaviour.setPlacedBy(level, pos, placer);
        super.m_6402_(level, pos, state, placer, stack);
    }

    public CurvingPressBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (context instanceof EntityCollisionContext && ((EntityCollisionContext)context).m_193113_() instanceof Player) {
            return AllShapes.CASING_14PX.get(Direction.DOWN);
        }
        return AllShapes.MECHANICAL_PROCESSOR_SHAPE;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return !AllBlocks.BASIN.has(worldIn.m_8055_(pos.m_7495_()));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction prefferedSide = this.getPreferredHorizontalFacing(context);
        if (prefferedSide != null) {
            return (BlockState)this.m_49966_().m_61124_(HORIZONTAL_FACING, (Comparable)prefferedSide);
        }
        return super.m_5573_(context);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122434_();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.m_122434_() == ((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122434_();
    }

    public Class<CurvingPressBlockEntity> getBlockEntityClass() {
        return CurvingPressBlockEntity.class;
    }

    public BlockEntityType<? extends CurvingPressBlockEntity> getBlockEntityType() {
        return (BlockEntityType)VintageBlockEntity.CURVING_PRESS.get();
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(handIn);
        return this.onBlockEntityUse((BlockGetter)worldIn, pos, be -> {
            if (be.mode == 0) {
                be.itemAsHead.m_6211_();
                if (heldItem.m_150930_((Item)VintageItems.CONVEX_CURVING_HEAD.get())) {
                    be.mode = 1;
                    be.durability = heldItem.m_41776_() - heldItem.m_41773_();
                    if (!player.m_7500_()) {
                        player.m_21120_(handIn).m_41774_(1);
                    }
                    if (worldIn.m_5776_()) {
                        AllSoundEvents.WRENCH_ROTATE.playAt(worldIn, (Vec3i)pos, 3.0f, 1.0f, true);
                    }
                    be.m_6596_();
                    return InteractionResult.SUCCESS;
                }
                if (heldItem.m_150930_((Item)VintageItems.CONCAVE_CURVING_HEAD.get())) {
                    be.mode = 2;
                    be.durability = heldItem.m_41776_() - heldItem.m_41773_();
                    if (!player.m_7500_()) {
                        player.m_21120_(handIn).m_41774_(1);
                    }
                    if (worldIn.m_5776_()) {
                        AllSoundEvents.WRENCH_ROTATE.playAt(worldIn, (Vec3i)pos, 3.0f, 1.0f, true);
                    }
                    be.m_6596_();
                    return InteractionResult.SUCCESS;
                }
                if (heldItem.m_150930_((Item)VintageItems.W_SHAPED_CURVING_HEAD.get())) {
                    be.mode = 3;
                    be.durability = heldItem.m_41776_() - heldItem.m_41773_();
                    if (!player.m_7500_()) {
                        player.m_21120_(handIn).m_41774_(1);
                    }
                    if (worldIn.m_5776_()) {
                        AllSoundEvents.WRENCH_ROTATE.playAt(worldIn, (Vec3i)pos, 3.0f, 1.0f, true);
                    }
                    be.m_6596_();
                    return InteractionResult.SUCCESS;
                }
                if (heldItem.m_150930_((Item)VintageItems.V_SHAPED_CURVING_HEAD.get())) {
                    be.mode = 4;
                    be.durability = heldItem.m_41776_() - heldItem.m_41773_();
                    if (!player.m_7500_()) {
                        player.m_21120_(handIn).m_41774_(1);
                    }
                    if (worldIn.m_5776_()) {
                        AllSoundEvents.WRENCH_ROTATE.playAt(worldIn, (Vec3i)pos, 3.0f, 1.0f, true);
                    }
                    be.m_6596_();
                    return InteractionResult.SUCCESS;
                }
                if (heldItem.m_150930_((Item)VintageItems.REDSTONE_MODULE.get())) {
                    be.redstoneModule = true;
                    be.m_6596_();
                    return InteractionResult.SUCCESS;
                }
                if (heldItem.m_204117_(headTag)) {
                    be.mode = 5;
                    be.durability = heldItem.m_41773_();
                    if (heldItem.m_41753_()) {
                        be.itemAsHead.m_6836_(0, new ItemStack((ItemLike)heldItem.m_41777_().m_41720_()));
                    } else {
                        be.itemAsHead.m_6836_(0, heldItem.m_41777_());
                    }
                    if (!player.m_7500_()) {
                        player.m_21120_(handIn).m_41774_(1);
                    }
                    if (worldIn.m_5776_()) {
                        AllSoundEvents.WRENCH_ROTATE.playAt(worldIn, (Vec3i)pos, 3.0f, 1.0f, true);
                    }
                    be.m_6596_();
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (heldItem.m_150930_(AllItems.WRENCH.m_5456_())) {
                    ItemStack stack;
                    switch (be.mode) {
                        case 2: {
                            stack = new ItemStack((ItemLike)VintageItems.CONCAVE_CURVING_HEAD.get());
                            break;
                        }
                        case 3: {
                            stack = new ItemStack((ItemLike)VintageItems.W_SHAPED_CURVING_HEAD.get());
                            break;
                        }
                        case 4: {
                            stack = new ItemStack((ItemLike)VintageItems.V_SHAPED_CURVING_HEAD.get());
                            break;
                        }
                        case 5: {
                            stack = be.itemAsHead != null ? be.itemAsHead.m_8020_(0).m_41777_() : ItemStack.f_41583_;
                            be.itemAsHead.m_6211_();
                            break;
                        }
                        default: {
                            stack = new ItemStack((ItemLike)VintageItems.CONVEX_CURVING_HEAD.get());
                        }
                    }
                    if (be.mode < 5) {
                        stack.m_41721_(1000 - be.durability);
                    }
                    player.m_150109_().m_150079_(stack);
                    be.mode = 0;
                    if (worldIn.m_5776_()) {
                        AllSoundEvents.WRENCH_ROTATE.playAt(worldIn, (Vec3i)pos, 3.0f, 1.0f, true);
                    }
                    be.m_6596_();
                    return InteractionResult.SUCCESS;
                }
                if (heldItem.m_150930_((Item)VintageItems.REDSTONE_MODULE.get())) {
                    be.redstoneModule = true;
                    be.m_6596_();
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.PASS;
        });
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return this.getBlockEntityOptional((BlockGetter)worldIn, pos).map(CurvingPressBlockEntity::getAnalogSignal).orElse(0);
    }
}

