/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.vintage.content.kinetics.vacuum_chamber;

import com.google.gson.JsonObject;
import com.simibubi.create.compat.jei.category.sequencedAssembly.SequencedAssemblySubCategory;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.sequenced.IAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import dev.bluephs.vintage.VintageBlocks;
import dev.bluephs.vintage.VintageLang;
import dev.bluephs.vintage.VintageRecipes;
import dev.bluephs.vintage.compat.jei.category.assemblies.AssemblyPressurizing;
import dev.bluephs.vintage.content.kinetics.vacuum_chamber.VacuumChamberBlockEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class PressurizingRecipe
extends BasinRecipe
implements IAssemblyRecipe {
    int secondaryFluidResults = -1;
    int secondaryFluidInputs = -1;

    public PressurizingRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super((IRecipeTypeInfo)VintageRecipes.PRESSURIZING, params);
    }

    protected boolean canSpecifyDuration() {
        return true;
    }

    public void addAssemblyIngredients(List<Ingredient> list) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getDescriptionForAssembly() {
        int startNum;
        MutableComponent result = VintageLang.translateDirect("recipe.assembly.pressurizing", new Object[0]);
        if (this.ingredients.size() <= 1 && this.fluidIngredients.isEmpty()) {
            return result;
        }
        result.m_130946_(" ").m_7220_((Component)VintageLang.translateDirect("recipe.assembly.with", new Object[0])).m_130946_(" ");
        if (this.ingredients.size() > 1) {
            if (((Ingredient)this.ingredients.get(1)).m_43908_().length > 0) {
                result.m_7220_(((Ingredient)this.ingredients.get(1)).m_43908_()[0].m_41720_().m_41466_());
            }
        } else if (!this.fluidIngredients.isEmpty() && !((FluidIngredient)this.fluidIngredients.get(0)).getMatchingFluidStacks().isEmpty()) {
            result.m_7220_(((FluidStack)((FluidIngredient)this.fluidIngredients.get(0)).getMatchingFluidStacks().get(0)).getDisplayName());
        }
        if (this.ingredients.size() > 2) {
            for (int i = 2; i < this.ingredients.size() - 1; ++i) {
                if (((Ingredient)this.ingredients.get(i)).m_43908_().length <= 0) continue;
                result.m_130946_(", ").m_7220_(((Ingredient)this.ingredients.get(i)).m_43908_()[0].m_41720_().m_41466_());
            }
            if (((Ingredient)this.ingredients.get(this.ingredients.size() - 1)).m_43908_().length > 0) {
                if (this.fluidIngredients.isEmpty()) {
                    result.m_130946_(" ").m_7220_((Component)VintageLang.translateDirect("recipe.assembly.and", new Object[0]).m_130946_(" ").m_7220_(((Ingredient)this.ingredients.get(this.ingredients.size() - 1)).m_43908_()[0].m_41720_().m_41466_()));
                } else {
                    result.m_130946_(", ").m_7220_(((Ingredient)this.ingredients.get(this.ingredients.size() - 1)).m_43908_()[0].m_41720_().m_41466_());
                }
            }
        }
        int n = startNum = this.ingredients.size() > 1 ? 0 : 1;
        if (this.fluidIngredients.size() > startNum) {
            for (int i = startNum; i < this.fluidIngredients.size() - 1; ++i) {
                if (((FluidIngredient)this.fluidIngredients.get(i)).getMatchingFluidStacks().isEmpty()) continue;
                result.m_130946_(", ").m_7220_(((FluidStack)((FluidIngredient)this.fluidIngredients.get(i)).getMatchingFluidStacks().get(0)).getDisplayName());
            }
            if (!((FluidIngredient)this.fluidIngredients.get(this.fluidIngredients.size() - 1)).getMatchingFluidStacks().isEmpty()) {
                result.m_130946_(" ").m_7220_((Component)VintageLang.translateDirect("recipe.assembly.and", new Object[0]).m_130946_(" ").m_7220_(((FluidStack)((FluidIngredient)this.fluidIngredients.get(this.fluidIngredients.size() - 1)).getMatchingFluidStacks().get(0)).getDisplayName()));
            }
        }
        return result;
    }

    public void addRequiredMachines(Set<ItemLike> list) {
        list.add((ItemLike)VintageBlocks.VACUUM_CHAMBER.get());
    }

    public Supplier<Supplier<SequencedAssemblySubCategory>> getJEISubCategory() {
        return () -> AssemblyPressurizing::new;
    }

    public static boolean match(BasinBlockEntity basin, Recipe<?> recipe, VacuumChamberBlockEntity be) {
        BasinRecipe basinRecipe;
        FilteringBehaviour filter = basin.getFilter();
        if (filter == null) {
            return false;
        }
        boolean filterTest = filter.test(recipe.m_8043_(basin.m_58904_().m_9598_()));
        if (recipe instanceof BasinRecipe && (basinRecipe = (BasinRecipe)recipe).getRollableResults().isEmpty() && !basinRecipe.getFluidResults().isEmpty()) {
            filterTest = filter.test((FluidStack)basinRecipe.getFluidResults().get(0));
        }
        if (!filterTest) {
            return false;
        }
        return PressurizingRecipe.apply(basin, recipe, be, true);
    }

    public static boolean apply(BasinBlockEntity basin, Recipe<?> recipe, VacuumChamberBlockEntity be) {
        return PressurizingRecipe.apply(basin, recipe, be, false);
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private static boolean apply(BasinBlockEntity basin, Recipe<?> recipe, VacuumChamberBlockEntity be, boolean test) {
        boolean isBasinRecipe = recipe instanceof BasinRecipe;
        IItemHandler availableItems = (IItemHandler)basin.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        IFluidHandler availableFluids = (IFluidHandler)basin.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
        IFluidHandler availableSecondaryFluids = (IFluidHandler)be.fluidCapability.orElse(null);
        if (availableItems == null) return false;
        if (availableFluids == null) return false;
        if (availableSecondaryFluids == null) {
            return false;
        }
        BlazeBurnerBlock.HeatLevel heat = BasinBlockEntity.getHeatLevelOf((BlockState)basin.m_58904_().m_8055_(basin.m_58899_().m_6625_(1)));
        if (isBasinRecipe && !((BasinRecipe)recipe).getRequiredHeat().testBlazeBurner(heat)) {
            return false;
        }
        ArrayList recipeOutputItems = new ArrayList();
        ArrayList<FluidStack> recipeOutputFluids = new ArrayList<FluidStack>();
        ArrayList<FluidStack> recipeSecondaryOutputFluids = new ArrayList<FluidStack>();
        LinkedList ingredients = new LinkedList(recipe.m_7527_());
        NonNullList fluidIngredients = isBasinRecipe ? ((BasinRecipe)recipe).getFluidIngredients() : Collections.emptyList();
        boolean[] blArray = Iterate.trueAndFalse;
        int n = blArray.length;
        int n2 = 0;
        block0: while (n2 < n) {
            boolean simulate = blArray[n2];
            if (!simulate && test) {
                return true;
            }
            int[] extractedItemsFromSlot = new int[availableItems.getSlots()];
            int[] extractedFluidsFromTank = new int[availableFluids.getTanks()];
            int[] extractedSecondaryFluidsFromTank = new int[availableSecondaryFluids.getTanks()];
            int i = 0;
            block1: while (true) {
                if (i >= ingredients.size()) break;
                Ingredient ingredient = (Ingredient)ingredients.get(i);
                int slot = 0;
                while (slot < availableItems.getSlots()) {
                    ItemStack extracted;
                    if ((!simulate || availableItems.getStackInSlot(slot).m_41613_() > extractedItemsFromSlot[slot]) && ingredient.test(extracted = availableItems.extractItem(slot, 1, true))) {
                        if (!simulate) {
                            availableItems.extractItem(slot, 1, false);
                        }
                        int n3 = slot;
                        extractedItemsFromSlot[n3] = extractedItemsFromSlot[n3] + 1;
                        ++i;
                        continue block1;
                    }
                    ++slot;
                }
                return false;
            }
            boolean fluidsAffected = false;
            int i2 = 0;
            while (true) {
                block25: {
                    int drainedAmount;
                    FluidStack fluidStack;
                    int tank;
                    int amountRequired;
                    FluidIngredient fluidIngredient;
                    block27: {
                        block28: {
                            block26: {
                                if (i2 >= fluidIngredients.size()) break block26;
                                fluidIngredient = (FluidIngredient)fluidIngredients.get(i2);
                                amountRequired = fluidIngredient.getRequiredAmount();
                                if (!(recipe instanceof PressurizingRecipe)) break block27;
                                PressurizingRecipe basinRecipe = (PressurizingRecipe)recipe;
                                if (basinRecipe.secondaryFluidInputs == i2) break block28;
                                break block27;
                            }
                            if (fluidsAffected) {
                                ((SmartFluidTankBehaviour)basin.getBehaviour(SmartFluidTankBehaviour.INPUT)).forEach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
                                ((SmartFluidTankBehaviour)basin.getBehaviour(SmartFluidTankBehaviour.OUTPUT)).forEach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
                                ((SmartFluidTankBehaviour)be.getBehaviour(SmartFluidTankBehaviour.INPUT)).forEach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
                                ((SmartFluidTankBehaviour)be.getBehaviour(SmartFluidTankBehaviour.OUTPUT)).forEach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
                            }
                            if (simulate && recipe instanceof PressurizingRecipe) {
                                int i3;
                                PressurizingRecipe basinRecipe = (PressurizingRecipe)recipe;
                                recipeOutputItems.addAll(basinRecipe.rollResults());
                                recipeOutputItems.addAll(basinRecipe.m_7457_((Container)basin.getInputInventory()));
                                NonNullList fss = basinRecipe.getFluidResults();
                                if (basinRecipe.secondaryFluidResults >= 0 && basinRecipe.secondaryFluidResults + 1 <= fss.size()) {
                                    recipeSecondaryOutputFluids.add((FluidStack)fss.get(basinRecipe.secondaryFluidResults));
                                }
                                for (i3 = 0; i3 < basinRecipe.secondaryFluidResults; ++i3) {
                                    recipeOutputFluids.add((FluidStack)fss.get(i3));
                                }
                                for (i3 = basinRecipe.secondaryFluidResults + 1; i3 < fss.size(); ++i3) {
                                    recipeOutputFluids.add((FluidStack)fss.get(i3));
                                }
                            }
                            if (!basin.acceptOutputs(recipeOutputItems, recipeOutputFluids, simulate)) {
                                return false;
                            }
                            if (recipe instanceof PressurizingRecipe) {
                                PressurizingRecipe basinRecipe = (PressurizingRecipe)recipe;
                                if (basinRecipe.secondaryFluidResults >= 0 && !be.acceptOutputs(recipeSecondaryOutputFluids, simulate)) {
                                    return false;
                                }
                            }
                            ++n2;
                            continue block0;
                        }
                        tank = 0;
                        while (tank < availableSecondaryFluids.getTanks()) {
                            fluidStack = availableSecondaryFluids.getFluidInTank(tank);
                            if ((!simulate || fluidStack.getAmount() > extractedSecondaryFluidsFromTank[tank]) && fluidIngredient.test(fluidStack)) {
                                drainedAmount = Math.min(amountRequired, fluidStack.getAmount());
                                if (!simulate) {
                                    fluidStack.shrink(drainedAmount);
                                    fluidsAffected = true;
                                }
                                if ((amountRequired -= drainedAmount) == 0) {
                                    int n4 = tank;
                                    extractedSecondaryFluidsFromTank[n4] = extractedSecondaryFluidsFromTank[n4] + drainedAmount;
                                    break block25;
                                }
                            }
                            ++tank;
                        }
                        return false;
                    }
                    tank = 0;
                    while (tank < availableFluids.getTanks()) {
                        fluidStack = availableFluids.getFluidInTank(tank);
                        if ((!simulate || fluidStack.getAmount() > extractedFluidsFromTank[tank]) && fluidIngredient.test(fluidStack)) {
                            drainedAmount = Math.min(amountRequired, fluidStack.getAmount());
                            if (!simulate) {
                                fluidStack.shrink(drainedAmount);
                                fluidsAffected = true;
                            }
                            if ((amountRequired -= drainedAmount) == 0) {
                                int n5 = tank;
                                extractedFluidsFromTank[n5] = extractedFluidsFromTank[n5] + drainedAmount;
                                break block25;
                            }
                        }
                        ++tank;
                    }
                    return false;
                }
                ++i2;
            }
            break;
        }
        return true;
    }

    public void readAdditional(JsonObject json) {
        if (json.has("secondaryFluidOutput")) {
            this.secondaryFluidResults = json.get("secondaryFluidOutput").getAsInt();
        }
        if (json.has("secondaryFluidInput")) {
            this.secondaryFluidInputs = json.get("secondaryFluidInput").getAsInt();
        }
    }

    public void readAdditional(FriendlyByteBuf buffer) {
        this.secondaryFluidResults = buffer.readInt();
        this.secondaryFluidInputs = buffer.readInt();
    }

    public void writeAdditional(JsonObject json) {
        json.addProperty("secondaryFluidOutput", (Number)this.secondaryFluidResults);
        json.addProperty("secondaryFluidInput", (Number)this.secondaryFluidInputs);
    }

    public void writeAdditional(FriendlyByteBuf buffer) {
        buffer.writeInt(this.secondaryFluidResults);
        buffer.writeInt(this.secondaryFluidInputs);
    }

    public int getSecondaryFluidResults() {
        return this.secondaryFluidResults;
    }

    public int getSecondaryFluidInputs() {
        return this.secondaryFluidInputs;
    }
}

