/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.createvintageneoforged.compat.jei.categories;

import com.simibubi.create.compat.jei.category.BasinCategory;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedBlazeBurner;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import dev.bluephs.createvintageneoforged.compat.jei.animated.AnimatedCentrifuge;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import net.minecraft.client.gui.GuiGraphics;

@ParametersAreNonnullByDefault
public class CentrifugationCategory
extends BasinCategory {
    private final AnimatedCentrifuge centrifuge = new AnimatedCentrifuge();
    private final AnimatedBlazeBurner heater = new AnimatedBlazeBurner();
    private final CentrifugatingType type;

    public CentrifugationCategory(CreateRecipeCategory.Info<BasinRecipe> info, CentrifugatingType type) {
        super(info, type == CentrifugatingType.CENTRIFUGATING);
        this.type = type;
    }

    public static CentrifugationCategory standard(CreateRecipeCategory.Info<BasinRecipe> info) {
        return new CentrifugationCategory(info, CentrifugatingType.CENTRIFUGATING);
    }

    public void draw(BasinRecipe recipe, IRecipeSlotsView iRecipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        super.draw(recipe, iRecipeSlotsView, graphics, mouseX, mouseY);
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        if (requiredHeat != HeatCondition.NONE) {
            this.heater.withHeat(requiredHeat.visualizeAsBlazeBurner()).draw(graphics, this.getBackground().getWidth() / 2 + 3, 55);
        }
        this.centrifuge.draw(graphics, this.getBackground().getWidth() / 2 + 3, 34);
    }

    public static enum CentrifugatingType {
        CENTRIFUGATING;

    }
}

