/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.createvintageneoforged.compat.jei.categories;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedBlazeBurner;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.item.ItemHelper;
import dev.bluephs.createvintageneoforged.compat.jei.VintageRecipeUtil;
import dev.bluephs.createvintageneoforged.compat.jei.animated.AnimatedVacuumChamber;
import dev.bluephs.createvintageneoforged.content.kinetics.vacuum_chamber.PressurizingRecipe;
import dev.bluephs.createvintageneoforged.foundation.gui.VintageGuiTextures;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.apache.commons.lang3.mutable.MutableInt;

@ParametersAreNonnullByDefault
public class PressurizingCategory
extends CreateRecipeCategory<PressurizingRecipe> {
    private final AnimatedVacuumChamber vacuum = new AnimatedVacuumChamber();
    private final AnimatedBlazeBurner heater = new AnimatedBlazeBurner();

    public PressurizingCategory(CreateRecipeCategory.Info<PressurizingRecipe> info) {
        super(info);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PressurizingRecipe recipe, IFocusGroup focuses) {
        List condensedIngredients = ItemHelper.condenseIngredients((NonNullList)recipe.getIngredients());
        int size = condensedIngredients.size() + recipe.getFluidIngredients().size();
        int xOffset = size < 3 ? (3 - size) * 19 / 2 : 0;
        int i = 0;
        for (Object pair : condensedIngredients) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (ItemStack itemStack : ((Ingredient)pair.getFirst()).getItems()) {
                ItemStack copy = itemStack.copy();
                copy.setCount(((MutableInt)pair.getSecond()).getValue().intValue());
                stacks.add(copy);
            }
            builder.addSlot(RecipeIngredientRole.INPUT, 17 + xOffset + i % 3 * 19, 51 - i / 3 * 19).setBackground(PressurizingCategory.getRenderedSlot(), -1, -1).addItemStacks(stacks);
            ++i;
        }
        int j = 0;
        for (SizedFluidIngredient fluidIngredient : recipe.getFluidIngredients()) {
            PressurizingRecipe r;
            if (recipe instanceof PressurizingRecipe && j == (r = recipe).getSecondaryFluidInputs()) {
                CreateRecipeCategory.addFluidSlot((IRecipeLayoutBuilder)builder, (int)21, (int)14, (SizedFluidIngredient)fluidIngredient).addRichTooltipCallback(VintageRecipeUtil.addTooltip("jei.text.secondary_fluid_ingredient"));
            } else {
                CreateRecipeCategory.addFluidSlot((IRecipeLayoutBuilder)builder, (int)(17 + xOffset + i % 3 * 19), (int)(51 - i / 3 * 19), (SizedFluidIngredient)fluidIngredient);
            }
            ++i;
            ++j;
        }
        size = recipe.getRollableResults().size() + recipe.getFluidResults().size();
        i = 0;
        for (ProcessingOutput result : recipe.getRollableResults()) {
            int xPosition = 142 - (size % 2 != 0 && i == size - 1 ? 0 : (i % 2 == 0 ? 10 : -9));
            int yPosition = -19 * (i / 2) + 51;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, xPosition, yPosition).setBackground(PressurizingCategory.getRenderedSlot((ProcessingOutput)result), -1, -1).addItemStack(result.getStack())).addRichTooltipCallback(PressurizingCategory.addStochasticTooltip((ProcessingOutput)result));
            ++i;
        }
        j = 0;
        for (FluidStack fluidResult : recipe.getFluidResults()) {
            if (!(recipe instanceof PressurizingRecipe)) continue;
            PressurizingRecipe vRecipe = recipe;
            int secondary = vRecipe.getSecondaryFluidResults();
            if (j == secondary) {
                xPosition = 140;
                yPosition = 2;
                CreateRecipeCategory.addFluidSlot((IRecipeLayoutBuilder)builder, (int)xPosition, (int)yPosition, (FluidStack)fluidResult).addRichTooltipCallback(VintageRecipeUtil.addTooltip("jei.text.secondary_fluid_result"));
            } else {
                xPosition = 142 - ((secondary >= 0 ? size - 1 : size) % 2 != 0 && i == (secondary >= 0 ? size - 1 : size) - 1 ? 0 : (i % 2 == 0 ? 10 : -9));
                yPosition = -19 * (i / 2) + 51;
                CreateRecipeCategory.addFluidSlot((IRecipeLayoutBuilder)builder, (int)xPosition, (int)yPosition, (FluidStack)fluidResult);
            }
            ++i;
            ++j;
        }
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.NONE)) {
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 134, 81).addItemStack(AllBlocks.BLAZE_BURNER.asStack());
        }
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.KINDLED)) {
            builder.addSlot(RecipeIngredientRole.CATALYST, 153, 81).addItemStack(AllItems.BLAZE_CAKE.asStack());
        }
    }

    public void draw(PressurizingRecipe recipe, IRecipeSlotsView iRecipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        HeatCondition requiredHeat;
        if (recipe instanceof PressurizingRecipe) {
            PressurizingRecipe vrecipe = recipe;
            if (vrecipe.getSecondaryFluidResults() >= 0 && vrecipe.getFluidResults().size() > 0) {
                VintageGuiTextures.JEI_UP_TO_RIGHT_ARROW.render(graphics, 120, 2);
            }
            if (vrecipe.getSecondaryFluidInputs() >= 0 && vrecipe.getFluidIngredients().size() > 0) {
                AllGuiTextures.JEI_ARROW.render(graphics, 45, 18);
            }
        }
        if ((requiredHeat = recipe.getRequiredHeat()) != HeatCondition.NONE) {
            this.heater.withHeat(requiredHeat.visualizeAsBlazeBurner()).draw(graphics, this.getBackground().getWidth() / 2 + 3, 55);
        }
        this.vacuum.draw(graphics, this.getBackground().getWidth() / 2 + 3, 34, true);
    }
}

